/*
 * Decompiled with CFR 0.152.
 */
package neoforge.ru.pinkgoosik.winterly.mixin.common;

import neoforge.ru.pinkgoosik.winterly.Winterly;
import neoforge.ru.pinkgoosik.winterly.block.CommonFrozenFlowerBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.SnowAndFreezeFeature;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={SnowAndFreezeFeature.class})
public abstract class FreezeTopLayerMixin {
    @Redirect(method={"place(Lnet/minecraft/world/level/levelgen/feature/FeaturePlaceContext;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/biome/Biome;shouldSnow(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;)Z"))
    boolean canSetIce(Biome biome, LevelReader view, BlockPos pos) {
        if (!biome.warmEnoughToRain(pos) && pos.getY() >= view.getMinBuildHeight() && pos.getY() < view.getMaxBuildHeight() && view.getBrightness(LightLayer.BLOCK, pos) < 10) {
            BlockState state = view.getBlockState(pos);
            if (view instanceof WorldGenLevel) {
                WorldGenLevel world = (WorldGenLevel)view;
                if (Winterly.config.generateFrozenGrass && (state.is(Blocks.SHORT_GRASS) || state.is(Blocks.FERN) || state.is(Blocks.LARGE_FERN) || state.is(Blocks.TALL_GRASS))) {
                    world.setBlock(pos, ((Block)BuiltInRegistries.BLOCK.get(Winterly.id("frozen_grass"))).defaultBlockState(), 3);
                    BlockState floor = world.getBlockState(pos.below());
                    if (floor.hasProperty((Property)SnowyDirtBlock.SNOWY)) {
                        world.setBlock(pos.below(), (BlockState)floor.setValue((Property)SnowyDirtBlock.SNOWY, (Comparable)Boolean.TRUE), 2);
                    }
                    if (state.is(Blocks.LARGE_FERN) || state.is(Blocks.TALL_GRASS)) {
                        world.setBlock(pos.above(), Blocks.AIR.defaultBlockState(), 2);
                    }
                    return false;
                }
                if (Winterly.config.generateFrozenFlowers && (state.getBlock() instanceof FlowerBlock || state.getBlock() instanceof TallFlowerBlock)) {
                    world.setBlock(pos, (BlockState)((Block)BuiltInRegistries.BLOCK.get(Winterly.id("frozen_flower"))).defaultBlockState().setValue((Property)CommonFrozenFlowerBlock.LAYERS, (Comparable)Integer.valueOf(1)), 3);
                    BlockState floor = world.getBlockState(pos.below());
                    if (floor.hasProperty((Property)SnowyDirtBlock.SNOWY)) {
                        world.setBlock(pos.below(), (BlockState)floor.setValue((Property)SnowyDirtBlock.SNOWY, (Comparable)Boolean.TRUE), 2);
                    }
                    if (state.getBlock() instanceof TallFlowerBlock) {
                        world.setBlock(pos.above(), Blocks.AIR.defaultBlockState(), 2);
                    }
                    return false;
                }
            }
        }
        return biome.shouldSnow(view, pos);
    }
}

