/*
 * Decompiled with CFR 0.152.
 */
package neoforge.ru.pinkgoosik.winterly.mixin.common;

import neoforge.ru.pinkgoosik.winterly.Winterly;
import neoforge.ru.pinkgoosik.winterly.extension.DecoratedMob;
import neoforge.ru.pinkgoosik.winterly.util.HolidayUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Zombie.class})
public abstract class ZombieExtension
extends Monster
implements DecoratedMob {
    private static final EntityDataAccessor<Boolean> winterly$DECORATED = SynchedEntityData.defineId(Zombie.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> winterly$INDEX = SynchedEntityData.defineId(Zombie.class, (EntityDataSerializer)EntityDataSerializers.INT);

    protected ZombieExtension(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    public boolean winterly$isDecorated() {
        return (Boolean)this.getEntityData().get(winterly$DECORATED);
    }

    @Override
    public int winterly$getIndex() {
        return (Integer)this.getEntityData().get(winterly$INDEX);
    }

    @Override
    public void winterly$setDecoration(int index) {
        this.getEntityData().set(winterly$DECORATED, (Object)true);
        this.getEntityData().set(winterly$INDEX, (Object)index);
    }

    @Inject(method={"defineSynchedData(Lnet/minecraft/network/syncher/SynchedEntityData$Builder;)V"}, at={@At(value="TAIL")})
    void initData(SynchedEntityData.Builder builder, CallbackInfo ci) {
        builder.define(winterly$DECORATED, (Object)false);
        builder.define(winterly$INDEX, (Object)0);
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    void write(CompoundTag nbt, CallbackInfo ci) {
        nbt.putBoolean("WinterlyDecorated", ((Boolean)this.getEntityData().get(winterly$DECORATED)).booleanValue());
        nbt.putInt("WinterlyIndex", ((Integer)this.getEntityData().get(winterly$INDEX)).intValue());
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    void read(CompoundTag nbt, CallbackInfo ci) {
        this.getEntityData().set(winterly$DECORATED, (Object)nbt.getBoolean("WinterlyDecorated"));
        this.getEntityData().set(winterly$INDEX, (Object)nbt.getInt("WinterlyIndex"));
    }

    @Inject(method={"finalizeSpawn(Lnet/minecraft/world/level/ServerLevelAccessor;Lnet/minecraft/world/DifficultyInstance;Lnet/minecraft/world/entity/MobSpawnType;Lnet/minecraft/world/entity/SpawnGroupData;)Lnet/minecraft/world/entity/SpawnGroupData;"}, at={@At(value="RETURN")})
    void finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, SpawnGroupData spawnGroupData, CallbackInfoReturnable<SpawnGroupData> cir) {
        int chance;
        if (!spawnType.equals((Object)MobSpawnType.SPAWNER) && !spawnType.equals((Object)MobSpawnType.CHUNK_GENERATION) && !this.isBaby() && (Winterly.config.mobDecorations.enabled && HolidayUtils.isWinterHolidays() || !Winterly.config.mobDecorations.onlyInWinter) && !this.level().dimension().equals(Level.NETHER) && (chance = Winterly.config.mobDecorations.chance) > 0 && Math.random() < (double)chance / 100.0) {
            this.winterly$setDecoration(level.getRandom().nextInt(11));
        }
    }
}

