/*
 * Decompiled with CFR 0.152.
 */
package neoforge.ru.pinkgoosik.winterly.neoforge.client;

import neoforge.ru.pinkgoosik.winterly.client.WinterlyModelLayers;
import neoforge.ru.pinkgoosik.winterly.client.model.SantaHatModel;
import neoforge.ru.pinkgoosik.winterly.client.model.ScarfModel;
import neoforge.ru.pinkgoosik.winterly.client.render.DecorationFeatureRenderer;
import neoforge.ru.pinkgoosik.winterly.client.render.MobDecorations;
import neoforge.ru.pinkgoosik.winterly.config.WinterlyClientConfig;
import neoforge.ru.pinkgoosik.winterly.item.CommonSantaHatItem;
import neoforge.ru.pinkgoosik.winterly.item.CommonScarfItem;
import neoforge.ru.pinkgoosik.winterly.neoforge.compat.WinterlyCuriosIntegration;
import neoforge.ru.pinkgoosik.winterly.registry.CommonWinterlyItems;
import net.minecraft.client.renderer.entity.DrownedRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.SkeletonRenderer;
import net.minecraft.client.renderer.entity.ZombieRenderer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;

@OnlyIn(value=Dist.CLIENT)
public class WinterlyNeoforgeClient {
    public static void init(IEventBus bus) {
        bus.addListener(WinterlyNeoforgeClient::clientSetup);
        bus.addListener(WinterlyNeoforgeClient::registerModelLayers);
        bus.addListener(WinterlyNeoforgeClient::registerRenderLayers);
    }

    private static void registerModelLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(WinterlyModelLayers.SANTA_HAT_LAYER, SantaHatModel::getTexturedModelData);
        event.registerLayerDefinition(WinterlyModelLayers.SCARF_LAYER, ScarfModel::getTexturedModelData);
    }

    private static void registerRenderLayers(EntityRenderersEvent.AddLayers event) {
        ZombieRenderer renderer;
        EntityRenderer entityRenderer = event.getRenderer(EntityType.ZOMBIE);
        if (entityRenderer instanceof ZombieRenderer) {
            renderer = (ZombieRenderer)entityRenderer;
            renderer.addLayer(new DecorationFeatureRenderer(renderer));
        }
        if ((entityRenderer = event.getRenderer(EntityType.DROWNED)) instanceof DrownedRenderer) {
            renderer = (DrownedRenderer)entityRenderer;
            renderer.addLayer(new DecorationFeatureRenderer(renderer));
        }
        if ((entityRenderer = event.getRenderer(EntityType.SKELETON)) instanceof SkeletonRenderer) {
            renderer = (SkeletonRenderer)entityRenderer;
            renderer.addLayer(new DecorationFeatureRenderer(renderer));
        }
    }

    private static void clientSetup(FMLClientSetupEvent event) {
        if (ModList.get().isLoaded("curios")) {
            CommonWinterlyItems.ITEMS.forEach((id, sup) -> {
                Object patt1$temp;
                Object patt0$temp = BuiltInRegistries.ITEM.get(id);
                if (patt0$temp instanceof CommonScarfItem) {
                    CommonScarfItem scarf = (CommonScarfItem)((Object)((Object)patt0$temp));
                    WinterlyCuriosIntegration.registerScarfRenderer(scarf);
                }
                if ((patt1$temp = BuiltInRegistries.ITEM.get(id)) instanceof CommonSantaHatItem) {
                    CommonSantaHatItem hat = (CommonSantaHatItem)((Object)((Object)patt1$temp));
                    WinterlyCuriosIntegration.registerSantaHatRenderer(hat);
                }
            });
        }
        MobDecorations.init();
        ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (client, screen) -> WinterlyClientConfig.buildScreen(screen));
    }
}

