/*
 * Decompiled with CFR 0.152.
 */
package neoforge.ru.pinkgoosik.winterly.registry;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import neoforge.ru.pinkgoosik.winterly.Winterly;
import neoforge.ru.pinkgoosik.winterly.block.GarlandLightsBlock;
import neoforge.ru.pinkgoosik.winterly.block.GiftBoxBlock;
import neoforge.ru.pinkgoosik.winterly.block.IcicleBlock;
import neoforge.ru.pinkgoosik.winterly.block.SnowballWallBlock;
import neoforge.ru.pinkgoosik.winterly.block.SnowguyBlock;
import neoforge.ru.pinkgoosik.winterly.block.base.BasePaneBlock;
import neoforge.ru.pinkgoosik.winterly.block.base.BaseStairsBlock;
import neoforge.ru.pinkgoosik.winterly.block.base.BaseTransparentBlock;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.PushReaction;

public abstract class CommonWinterlyBlocks {
    public static final Map<ResourceLocation, Supplier<Block>> BLOCKS = new LinkedHashMap<ResourceLocation, Supplier<Block>>();

    public static void init() {
        CommonWinterlyBlocks.add("icicle", () -> new IcicleBlock(CommonWinterlyBlocks.copyOf(Blocks.ICE).pushReaction(PushReaction.DESTROY)));
        CommonWinterlyBlocks.add("icicle_block", () -> new BaseTransparentBlock(CommonWinterlyBlocks.copyOf(Blocks.PACKED_ICE).noOcclusion()));
        CommonWinterlyBlocks.add("packed_icicle_block", () -> new BaseTransparentBlock(CommonWinterlyBlocks.copyOf(Blocks.PACKED_ICE).noOcclusion()));
        CommonWinterlyBlocks.add("icicle_pane", () -> new BasePaneBlock(CommonWinterlyBlocks.copyOf(Blocks.PACKED_ICE).noOcclusion()));
        CommonWinterlyBlocks.add("icicle_bars", () -> new BasePaneBlock(CommonWinterlyBlocks.copyOf(Blocks.ICE).noOcclusion()));
        CommonWinterlyBlocks.add("cryomarble_block", () -> new Block(CommonWinterlyBlocks.copyOf(Blocks.DIAMOND_BLOCK)));
        CommonWinterlyBlocks.add("snowguy", () -> new SnowguyBlock(CommonWinterlyBlocks.copyOf(Blocks.WHITE_WOOL).sound(SoundType.SNOW)));
        CommonWinterlyBlocks.add("snowball_wall", () -> new SnowballWallBlock(CommonWinterlyBlocks.copyOf(Blocks.WHITE_WOOL).sound(SoundType.SNOW).noOcclusion()));
        CommonWinterlyBlocks.add("dense_snow", () -> new Block(CommonWinterlyBlocks.copyOf(Blocks.WHITE_WOOL).sound(SoundType.SNOW)));
        CommonWinterlyBlocks.add("dense_snow_stairs", () -> new BaseStairsBlock(Blocks.SNOW_BLOCK.defaultBlockState(), CommonWinterlyBlocks.copyOf(Blocks.WHITE_WOOL).sound(SoundType.SNOW)));
        CommonWinterlyBlocks.add("dense_snow_slab", () -> new SlabBlock(CommonWinterlyBlocks.copyOf(Blocks.WHITE_WOOL).sound(SoundType.SNOW)));
        CommonWinterlyBlocks.add("snow_bricks", () -> new Block(CommonWinterlyBlocks.copyOf(Blocks.WHITE_WOOL).sound(SoundType.SNOW)));
        CommonWinterlyBlocks.add("snow_brick_stairs", () -> new BaseStairsBlock(Blocks.SNOW_BLOCK.defaultBlockState(), CommonWinterlyBlocks.copyOf(Blocks.WHITE_WOOL).sound(SoundType.SNOW)));
        CommonWinterlyBlocks.add("snow_brick_slab", () -> new SlabBlock(CommonWinterlyBlocks.copyOf(Blocks.WHITE_WOOL).sound(SoundType.SNOW)));
        CommonWinterlyBlocks.add("raw_cryomarble_shard", () -> new IcicleBlock(CommonWinterlyBlocks.copyOf(Blocks.WHITE_WOOL).sound(SoundType.GLASS).lightLevel(state -> 12)));
        CommonWinterlyBlocks.add("red_gift_box", () -> new GiftBoxBlock(CommonWinterlyBlocks.copyOf(Blocks.RED_WOOL).pushReaction(PushReaction.DESTROY)));
        CommonWinterlyBlocks.add("orange_gift_box", () -> new GiftBoxBlock(CommonWinterlyBlocks.copyOf(Blocks.RED_WOOL).pushReaction(PushReaction.DESTROY)));
        CommonWinterlyBlocks.add("yellow_gift_box", () -> new GiftBoxBlock(CommonWinterlyBlocks.copyOf(Blocks.RED_WOOL).pushReaction(PushReaction.DESTROY)));
        CommonWinterlyBlocks.add("green_gift_box", () -> new GiftBoxBlock(CommonWinterlyBlocks.copyOf(Blocks.RED_WOOL).pushReaction(PushReaction.DESTROY)));
        CommonWinterlyBlocks.add("cyan_gift_box", () -> new GiftBoxBlock(CommonWinterlyBlocks.copyOf(Blocks.RED_WOOL).pushReaction(PushReaction.DESTROY)));
        CommonWinterlyBlocks.add("blue_gift_box", () -> new GiftBoxBlock(CommonWinterlyBlocks.copyOf(Blocks.RED_WOOL).pushReaction(PushReaction.DESTROY)));
        CommonWinterlyBlocks.add("purple_gift_box", () -> new GiftBoxBlock(CommonWinterlyBlocks.copyOf(Blocks.RED_WOOL).pushReaction(PushReaction.DESTROY)));
        CommonWinterlyBlocks.add("black_gift_box", () -> new GiftBoxBlock(CommonWinterlyBlocks.copyOf(Blocks.RED_WOOL).pushReaction(PushReaction.DESTROY)));
        CommonWinterlyBlocks.add("white_gift_box", () -> new GiftBoxBlock(CommonWinterlyBlocks.copyOf(Blocks.RED_WOOL).pushReaction(PushReaction.DESTROY)));
        CommonWinterlyBlocks.add("garland_lights", () -> new GarlandLightsBlock(CommonWinterlyBlocks.copyOf(Blocks.GREEN_WOOL).pushReaction(PushReaction.DESTROY).noCollission().sound(SoundType.CANDLE)));
        CommonWinterlyBlocks.add("rainy_garland_lights", () -> new GarlandLightsBlock(CommonWinterlyBlocks.copyOf(Blocks.WHITE_WOOL).pushReaction(PushReaction.DESTROY).noCollission().sound(SoundType.CANDLE)));
    }

    public static void add(String name, Supplier<Block> block) {
        BLOCKS.put(Winterly.id(name), block);
    }

    public static BlockBehaviour.Properties copyOf(Block block) {
        return BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)block);
    }
}

