/*
 * Decompiled with CFR 0.152.
 */
package neoforge.ru.pinkgoosik.winterly.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import neoforge.ru.pinkgoosik.winterly.Winterly;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.SharedConstants;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class UpdateChecker {
    private static final Gson GSON = new GsonBuilder().setLenient().setPrettyPrinting().create();
    private static final HttpClient HTTP_CLIENT = HttpClient.newBuilder().build();
    private static Instant lastCheck = Instant.now().minus(4L, ChronoUnit.HOURS);
    private static String cachedLatest = "0";
    public static boolean updated = false;
    public static MutableComponent text = null;

    public static boolean check() {
        if (Winterly.config.updateCheckerEnabled) {
            String local = UpdateChecker.getLocalVersion();
            String remote = UpdateChecker.getLatestRemote();
            int localNum = Integer.parseInt(local.replaceAll("\\.", ""));
            int remoteNum = Integer.parseInt(remote.replaceAll("\\.", ""));
            if (remoteNum > localNum) {
                String temp = Language.getInstance().getOrDefault("itemGroup.winterly.items.button.updated");
                temp = temp.replaceAll("%local_version%", local);
                temp = temp.replaceAll("%remote_version%", remote);
                text = Component.literal((String)temp);
                updated = true;
            }
        }
        return updated;
    }

    static String getLatestRemote() {
        if (ChronoUnit.HOURS.between(lastCheck, Instant.now()) >= 4L) {
            String remote = "0";
            Optional<ArrayList<ProjectVersion>> versions = UpdateChecker.getModrinthVersions();
            if (versions.isPresent() && !versions.get().isEmpty()) {
                remote = versions.get().get((int)0).versionNumber;
            }
            cachedLatest = remote;
            lastCheck = Instant.now();
        }
        return cachedLatest;
    }

    static String getLocalVersion() {
        String version = "1000";
        Optional mod = FabricLoader.getInstance().getModContainer("winterly");
        if (mod.isPresent()) {
            version = ((ModContainer)mod.get()).getMetadata().getVersion().getFriendlyString();
        }
        return version;
    }

    static Optional<ArrayList<ProjectVersion>> getModrinthVersions() {
        try {
            HttpRequest request = HttpRequest.newBuilder().GET().uri(new URI("https://api.modrinth.com/v2/project/winterly/version")).headers("User-Agent", "tyap-lyap/winterly/" + UpdateChecker.getLocalVersion()).build();
            HttpResponse<InputStream> response = HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofInputStream());
            InputStreamReader reader = new InputStreamReader(response.body());
            ProjectVersion[] versions = (ProjectVersion[])GSON.fromJson((Reader)reader, ProjectVersion[].class);
            ArrayList array = new ArrayList();
            Arrays.asList(versions).forEach(version -> {
                if (version.gameVersions.contains(SharedConstants.getCurrentVersion().getName())) {
                    array.add(version);
                }
            });
            return Optional.of(array);
        }
        catch (FileNotFoundException e) {
            return Optional.empty();
        }
        catch (Exception e) {
            Winterly.LOGGER.info("Failed to parse modrinth project versions due to an exception:\n" + String.valueOf(e));
            return Optional.empty();
        }
    }

    static class ProjectVersion {
        public String id = "";
        @SerializedName(value="project_id")
        public String projectId = "";
        @SerializedName(value="author_id")
        public String authorId = "";
        public boolean featured = false;
        public String name = "";
        @SerializedName(value="version_number")
        public String versionNumber = "";
        public String changelog = "";
        @SerializedName(value="changelog_url")
        public String changelogUrl = "";
        @SerializedName(value="date_published")
        public String published = "";
        public int downloads = 0;
        @SerializedName(value="version_type")
        public String versionType = "";
        @SerializedName(value="game_versions")
        public ArrayList<String> gameVersions = new ArrayList();
        public ArrayList<String> loaders = new ArrayList();

        ProjectVersion() {
        }
    }
}

