/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.element;

import fuzs.betteranimationscollection.client.element.ModelElement;
import fuzs.betteranimationscollection.client.model.CatTailModel;
import fuzs.betteranimationscollection.client.model.OcelotTailModel;
import fuzs.betteranimationscollection.mixin.client.accessor.CatCollarLayerAccessor;
import fuzs.puzzleslib.api.config.v3.ValueCallback;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.class_1451;
import net.minecraft.class_3680;
import net.minecraft.class_3684;
import net.minecraft.class_5601;
import net.minecraft.class_5605;
import net.minecraft.class_5607;
import net.neoforged.neoforge.common.ModConfigSpec;

public class CatTailElement
extends ModelElement {
    public static int tailLength;
    public static int animationSpeed;
    private final class_5601 animatedCat;
    private final class_5601 animatedCatCollar;

    public CatTailElement(BiFunction<String, String, class_5601> factory) {
        this.animatedCat = factory.apply("animated_cat", "main");
        this.animatedCatCollar = factory.apply("animated_cat", "collar");
    }

    @Override
    public String[] modelDescription() {
        return new String[]{"Takes away the stick tails of the current cats and gives them something nicer instead.", "Fully animated flowing tails that move while they stand or run, and even curl around their bodies when they sit."};
    }

    @Override
    void onRegisterAnimatedModels(ModelElement.AnimatedModelsContext context, ModelElement.EntityModelBakery bakery) {
        context.registerAnimatedModel(class_3680.class, () -> new CatTailModel(bakery.bakeLayer(this.animatedCat)), (renderLayerParent, renderLayer) -> {
            if (renderLayer instanceof class_3684) {
                ((CatCollarLayerAccessor)renderLayer).setCatModel(new CatTailModel<class_1451>(bakery.bakeLayer(this.animatedCatCollar)));
            }
            return Optional.empty();
        });
    }

    @Override
    public void onRegisterLayerDefinitions(BiConsumer<class_5601, Supplier<class_5607>> context) {
        context.accept(this.animatedCat, () -> OcelotTailModel.createAnimatedBodyMesh(class_5605.field_27715));
        context.accept(this.animatedCatCollar, () -> OcelotTailModel.createAnimatedBodyMesh(new class_5605(0.01f)));
    }

    @Override
    public void setupModelConfig(ModConfigSpec.Builder builder, ValueCallback callback) {
        callback.accept((ModConfigSpec.ConfigValue)builder.comment("Define tail length.").defineInRange("tail_length", 15, 1, 15), v -> {
            tailLength = v;
        });
        callback.accept((ModConfigSpec.ConfigValue)builder.comment("Animation swing speed for tail.").defineInRange("animation_speed", 7, 1, 20), v -> {
            animationSpeed = v;
        });
    }
}

