/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.element;

import fuzs.betteranimationscollection.client.element.ModelElement;
import fuzs.betteranimationscollection.client.model.PlayfulDoggyModel;
import fuzs.puzzleslib.api.config.v3.ValueCallback;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.class_5601;
import net.minecraft.class_5605;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_624;
import net.minecraft.class_9085;
import net.neoforged.neoforge.common.ModConfigSpec;

public class PlayfulDoggyElement
extends ModelElement {
    public static int tailLength;
    public static boolean fluffyTail;
    public static int animationSpeed;
    public static SittingBehaviour sittingBehaviour;
    private final class_5601 animatedWolf;
    private final class_5601 animatedWolfArmor;

    public PlayfulDoggyElement(BiFunction<String, String, class_5601> factory) {
        this.animatedWolf = factory.apply("animated_wolf", "main");
        this.animatedWolfArmor = factory.apply("animated_wolf", "armor");
    }

    @Override
    public String[] modelDescription() {
        return new String[]{"Changes wolf tails to be fluffier and flowier, wagging realistically while they stand and run.", "Also makes tamed wolves lie down instead of sitting. Hold up some meat and they'll roll over, too."};
    }

    @Override
    void onRegisterAnimatedModels(ModelElement.AnimatedModelsContext context, ModelElement.EntityModelBakery bakery) {
        context.registerAnimatedModel(class_624.class, () -> new PlayfulDoggyModel(bakery.bakeLayer(this.animatedWolf)), (renderLayerParent, renderLayer) -> {
            if (renderLayer instanceof class_9085) {
                class_9085 wolfArmorLayer = (class_9085)renderLayer;
                wolfArmorLayer.field_47890 = new PlayfulDoggyModel(bakery.bakeLayer(this.animatedWolfArmor));
            }
            return Optional.empty();
        });
    }

    @Override
    public void onRegisterLayerDefinitions(BiConsumer<class_5601, Supplier<class_5607>> context) {
        context.accept(this.animatedWolf, () -> class_5607.method_32110((class_5609)PlayfulDoggyModel.createAnimatedBodyLayer(class_5605.field_27715), (int)64, (int)32));
        context.accept(this.animatedWolfArmor, () -> class_5607.method_32110((class_5609)PlayfulDoggyModel.createAnimatedBodyLayer(new class_5605(0.2f)), (int)64, (int)32));
    }

    @Override
    public void setupModelConfig(ModConfigSpec.Builder builder, ValueCallback callback) {
        callback.accept((ModConfigSpec.ConfigValue)builder.comment("Define tail length.").defineInRange("tail_length", 7, 1, 7), v -> {
            tailLength = v;
        });
        callback.accept((ModConfigSpec.ConfigValue)builder.comment("Make wolf tail fluffy.").define("fluffy_tail", true), v -> {
            fluffyTail = v;
        });
        callback.accept((ModConfigSpec.ConfigValue)builder.comment("Animation swing speed for tail.").defineInRange("animation_speed", 5, 1, 20), v -> {
            animationSpeed = v;
        });
        callback.accept((ModConfigSpec.ConfigValue)builder.comment(new String[]{"Pose and behaviour when sitting.", "By default makes wolves lie down instead, and roll over when a nearby player is holding a piece meat."}).defineEnum("sitting_behaviour", (Enum)SittingBehaviour.LIE_DOWN_AND_BEG_FOR_MEAT), v -> {
            sittingBehaviour = v;
        });
    }

    public static enum SittingBehaviour {
        DEFAULT,
        LIE_DOWN,
        ROLL_OVER,
        LIE_DOWN_AND_BEG_FOR_MEAT;


        public boolean lieDown() {
            return this != DEFAULT;
        }

        public boolean rollOver() {
            return this == ROLL_OVER || this == LIE_DOWN_AND_BEG_FOR_MEAT;
        }

        public boolean begForMeat() {
            return this == LIE_DOWN_AND_BEG_FOR_MEAT;
        }
    }
}

