/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.model;

import com.google.common.collect.ImmutableList;
import fuzs.betteranimationscollection.client.element.PlayfulDoggyElement;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.class_1493;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_624;
import net.minecraft.class_630;
import net.minecraft.class_7833;

public class PlayfulDoggyModel<T extends class_1493>
extends class_624<T> {
    public static final int WOLF_TAIL_LENGTH = 7;
    private final class_630 head;
    private final class_630 realHead;
    private final class_630 body;
    private final class_630 rightHindLeg;
    private final class_630 leftHindLeg;
    private final class_630 rightFrontLeg;
    private final class_630 leftFrontLeg;
    private final class_630 tail;
    private final class_630 realTail;
    private final class_630[] realTailParts;
    private final class_630 fluffyTail;
    private final class_630 realFluffyTail;
    private final class_630[] realFluffyTailParts;
    private final class_630 upperBody;
    private boolean isInSittingPose;
    private float rollOverAmount;
    private float tickDelta;

    public PlayfulDoggyModel(class_630 modelPart) {
        super(modelPart);
        this.head = modelPart.method_32086("head");
        this.realHead = this.head.method_32086("real_head");
        this.body = modelPart.method_32086("body");
        this.upperBody = modelPart.method_32086("upper_body");
        this.rightHindLeg = modelPart.method_32086("right_hind_leg");
        this.leftHindLeg = modelPart.method_32086("left_hind_leg");
        this.rightFrontLeg = modelPart.method_32086("right_front_leg");
        this.leftFrontLeg = modelPart.method_32086("left_front_leg");
        this.tail = modelPart.method_32086("tail");
        this.fluffyTail = modelPart.method_32086("fluffy_tail");
        class_630 modelPart1 = this.realTail = this.tail.method_32086("real_tail");
        this.realTailParts = new class_630[7];
        for (int i = 0; i < this.realTailParts.length; ++i) {
            this.realTailParts[i] = modelPart1 = modelPart1.method_32086("real_tail" + i);
        }
        class_630 modelPart2 = this.realFluffyTail = this.fluffyTail.method_32086("real_fluffy_tail");
        this.realFluffyTailParts = new class_630[7];
        for (int i = 0; i < this.realFluffyTailParts.length; ++i) {
            this.realFluffyTailParts[i] = modelPart2 = modelPart2.method_32086("real_fluffy_tail" + i);
        }
    }

    public static class_5609 createAnimatedBodyLayer(class_5605 cubeDeformation) {
        class_5609 meshDefinition = class_624.method_32068((class_5605)cubeDeformation);
        class_5610 partDefinition = meshDefinition.method_32111();
        class_5610 partDefinition1 = partDefinition.method_32116("tail");
        class_5610 partDefinition3 = partDefinition.method_32117("fluffy_tail", class_5606.method_32108(), class_5603.method_32091((float)-1.0f, (float)12.0f, (float)8.0f, (float)0.62831855f, (float)0.0f, (float)0.0f));
        class_5606 cubeListBuilder = class_5606.method_32108().method_32101(9, 18).method_32098(0.0f, 0.0f, -1.0f, 2.0f, 1.0f, 2.0f, cubeDeformation);
        class_5610 partDefinition2 = partDefinition1.method_32117("real_tail", cubeListBuilder, class_5603.field_27701);
        class_5610 partDefinition4 = partDefinition3.method_32117("real_fluffy_tail", cubeListBuilder, class_5603.field_27701);
        for (int i = 0; i < 7; ++i) {
            partDefinition2 = partDefinition2.method_32117("real_tail" + i, class_5606.method_32108().method_32101(9, Math.min(19 + i, 25)).method_32098(0.0f, 0.0f, -1.0f, 2.0f, 1.0f, 2.0f, cubeDeformation), class_5603.method_32090((float)0.0f, (float)1.0f, (float)0.0f));
            class_5605 cubeDeformation1 = cubeDeformation.method_32094(PlayfulDoggyModel.getTailFluffiness(i));
            partDefinition4 = partDefinition4.method_32117("real_fluffy_tail" + i, class_5606.method_32108().method_32101(9, Math.min(19 + i, 25)).method_32098(0.0f, 0.0f, -1.0f, 2.0f, 1.0f, 2.0f, cubeDeformation1), class_5603.method_32090((float)0.0f, (float)(1.0f + PlayfulDoggyModel.getTailFluffiness(i)), (float)0.0f));
        }
        return meshDefinition;
    }

    private static float getTailFluffiness(int index) {
        if (index < 5) {
            return 0.1f + 0.1f * (float)index;
        }
        if (index == 5) {
            return 0.4f;
        }
        return 0.15f;
    }

    protected Iterable<class_630> method_22948() {
        return (Iterable)Stream.concat(StreamSupport.stream(super.method_22948().spliterator(), false), Stream.of(this.fluffyTail)).collect(ImmutableList.toImmutableList());
    }

    public void method_2828(class_4587 poseStack, class_4588 buffer, int packedLight, int packedOverlay, int color) {
        if (!this.isInSittingPose || !PlayfulDoggyElement.sittingBehaviour.rollOver() || PlayfulDoggyElement.sittingBehaviour.begForMeat() && (double)this.rollOverAmount < 1.0E-4) {
            super.method_2828(poseStack, buffer, packedLight, packedOverlay, color);
            return;
        }
        float rollOverAmount = PlayfulDoggyElement.sittingBehaviour.begForMeat() ? this.rollOverAmount : 0.47123888f;
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 1.25f, 0.0f);
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(180.0f * rollOverAmount));
        poseStack.method_46416(0.0f, -1.25f, 0.0f);
        this.rightHindLeg.field_3654 += rollOverAmount * 1.5f;
        this.leftHindLeg.field_3654 += rollOverAmount * 1.5f;
        this.rightFrontLeg.field_3654 += rollOverAmount * 1.5f;
        this.leftFrontLeg.field_3654 += rollOverAmount * 1.5f;
        this.rightHindLeg.field_3656 -= rollOverAmount * 1.75f;
        this.leftHindLeg.field_3656 -= rollOverAmount * 1.75f;
        this.rightFrontLeg.field_3656 -= rollOverAmount * 1.75f;
        this.leftFrontLeg.field_3656 -= rollOverAmount * 1.75f;
        this.realHead.field_3674 = -rollOverAmount * 1.5f;
        super.method_2828(poseStack, buffer, packedLight, packedOverlay, color);
        poseStack.method_22909();
    }

    public void method_17131(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        this.tickDelta = partialTick;
        super.method_17131(entity, limbSwing, limbSwingAmount, partialTick);
        if (entity.method_6172()) {
            if (PlayfulDoggyElement.sittingBehaviour.lieDown()) {
                this.upperBody.method_2851(-1.0f, 17.5f, -3.0f);
                this.upperBody.field_3654 = 1.5707964f;
                this.upperBody.field_3675 = 0.0f;
                this.body.method_2851(0.0f, 17.5f, 0.0f);
                this.body.field_3654 = 1.3463969f;
                this.tail.method_2851(-1.0f, 19.0f, 6.0f);
                this.rightHindLeg.method_2851(-2.5f, 22.0f, 5.25f);
                this.rightHindLeg.field_3654 = 4.712389f;
                this.rightHindLeg.field_3675 = 0.4f;
                this.leftHindLeg.method_2851(0.5f, 22.0f, 5.25f);
                this.leftHindLeg.field_3654 = 4.712389f;
                this.leftHindLeg.field_3675 = -0.4f;
                this.rightFrontLeg.field_3654 = 4.712389f;
                this.rightFrontLeg.method_2851(-2.49f, 21.5f, -2.0f);
                this.rightFrontLeg.field_3675 = 0.15f;
                this.leftFrontLeg.field_3654 = 4.712389f;
                this.leftFrontLeg.method_2851(0.51f, 21.5f, -2.0f);
                this.leftFrontLeg.field_3675 = -0.15f;
                this.head.field_3656 = this.field_3448 ? 15.5f : 17.0f;
            } else {
                this.upperBody.method_2851(-1.0f, 16.0f, -3.0f);
                this.upperBody.field_3654 = 1.2566371f;
                this.upperBody.field_3675 = 0.0f;
                this.tail.method_2851(-1.0f, 21.0f, 6.0f);
            }
        } else {
            this.upperBody.method_2851(-1.0f, 14.0f, -3.0f);
            this.upperBody.field_3654 = this.body.field_3654;
            this.tail.method_2851(-1.0f, 12.0f, 8.0f);
            this.head.field_3656 = 13.5f;
            this.leftFrontLeg.field_3675 = 0.0f;
            this.rightFrontLeg.field_3675 = 0.0f;
            this.leftHindLeg.field_3675 = 0.0f;
            this.rightHindLeg.field_3675 = 0.0f;
        }
        this.upperBody.field_3674 = entity.method_6715(partialTick, -0.08f);
        this.realTail.field_3674 = entity.method_6715(partialTick, -0.2f);
    }

    public void method_17133(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.method_17133(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.isInSittingPose = entityIn.method_6172();
        this.rollOverAmount = entityIn.method_6719(1.0f) + entityIn.method_6715(1.0f, 0.0f);
        this.setupAnimTail(entityIn, limbSwing, limbSwingAmount, this.tickDelta);
    }

    private void setupAnimTail(T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTickTime) {
        float progress = ((float)((class_1493)entitylivingbaseIn).field_6012 + partialTickTime) / 3.978873f;
        float magnitude = (0.5f + Math.max(limbSwingAmount, entitylivingbaseIn.method_6719(partialTickTime) * 1.5f)) * 0.25f;
        float amplitude = limbSwing * 0.6662f + progress * 0.6662f;
        if (!entitylivingbaseIn.method_6181()) {
            this.tail.field_3654 += class_3532.method_15374((float)amplitude) * magnitude;
            this.tail.field_3675 = 0.0f;
            for (int i = 0; i < this.realTailParts.length; ++i) {
                this.realTailParts[i].field_3674 = 0.0f;
                this.realTailParts[i].field_3654 = class_3532.method_15374((float)(amplitude - (float)(i + 1) * (float)PlayfulDoggyElement.animationSpeed * 0.15f)) * magnitude;
            }
        } else {
            this.tail.field_3675 = class_3532.method_15374((float)amplitude) * magnitude;
            for (int i = 0; i < this.realTailParts.length; ++i) {
                this.realTailParts[i].field_3654 = 0.0f;
                this.realTailParts[i].field_3674 = class_3532.method_15374((float)(amplitude - (float)(i + 1) * (float)PlayfulDoggyElement.animationSpeed * 0.15f)) * magnitude;
            }
        }
        this.copyAllTailParts();
        this.setModelPartVisibilities();
    }

    private void copyAllTailParts() {
        this.fluffyTail.method_17138(this.tail);
        this.realFluffyTail.method_17138(this.realTail);
        for (int i = 0; i < this.realTailParts.length; ++i) {
            this.realFluffyTailParts[i].method_17138(this.realTailParts[i]);
        }
    }

    private void setModelPartVisibilities() {
        this.tail.field_3665 = !PlayfulDoggyElement.fluffyTail;
        this.fluffyTail.field_3665 = PlayfulDoggyElement.fluffyTail;
    }
}

