/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.render.entity.renderer.utils;

import immersive_aircraft.client.render.entity.renderer.utils.ModelPartRenderer;
import immersive_aircraft.resources.bbmodel.BBModel;
import immersive_aircraft.resources.bbmodel.BBObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

public class ModelPartRenderHandler<T extends class_1297> {
    private final Map<String, ModelPartRenderer<T>> objects = new HashMap<String, ModelPartRenderer<T>>();

    public ModelPartRenderHandler<T> add(String id, ModelPartRenderer.AnimationConsumer<T> animationConsumer) {
        return this.add(id, animationConsumer, null);
    }

    public ModelPartRenderHandler<T> add(String id, ModelPartRenderer.RenderConsumer<T> renderConsumer) {
        return this.add(id, null, renderConsumer);
    }

    public ModelPartRenderHandler<T> add(String id, ModelPartRenderer.AnimationConsumer<T> animationConsumer, ModelPartRenderer.RenderConsumer<T> renderConsumer) {
        ModelPartRenderer<T> o = new ModelPartRenderer<T>(id, animationConsumer, renderConsumer);
        this.objects.put(o.id(), o);
        return this;
    }

    public Map<String, ModelPartRenderer<T>> getObjects() {
        return this.objects;
    }

    public void animate(String name, T entity, class_4587 matrixStack, float time) {
        ModelPartRenderer<T> o = this.objects.get(name);
        if (o != null && o.animationConsumer() != null) {
            o.animationConsumer().run(entity, 0.0f, time, matrixStack);
        }
    }

    public boolean render(String name, BBModel model, BBObject object, class_4597 vertexConsumerProvider, T entity, class_4587 matrixStack, int light, float time, ModelPartRenderHandler<T> modelPartRenderer) {
        ModelPartRenderer<T> o = this.objects.get(name);
        if (o != null && o.renderConsumer() != null) {
            o.renderConsumer().run(model, object, vertexConsumerProvider, entity, matrixStack, light, time, modelPartRenderer);
            return true;
        }
        return false;
    }
}

