/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.loot;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class LootConfig {
    public LinkedHashMap<String, Pool> injectors = new LinkedHashMap();
    public LinkedHashMap<String, Pool> regex_injectors = new LinkedHashMap();

    public static LootConfig constrainValues(LootConfig config) {
        if (config.injectors != null) {
            for (Map.Entry<String, Pool> entry : config.injectors.entrySet()) {
                Pool pool = entry.getValue();
                for (Pool.Entry lootEntry : pool.entries) {
                    if (lootEntry.weight >= 1) continue;
                    lootEntry.weight = 1;
                }
            }
        }
        return config;
    }

    public static class Pool {
        public float rolls = 1.0f;
        public float bonus_rolls = 0.2f;
        public List<Entry> entries = new ArrayList<Entry>();

        public Pool rolls(double rolls) {
            this.rolls = (float)rolls;
            return this;
        }

        public Pool bonus_rolls(double bonus_roll) {
            this.bonus_rolls = (float)bonus_roll;
            return this;
        }

        public Pool add(Entry entry) {
            this.entries.add(entry);
            return this;
        }

        public Pool add(String id) {
            return this.add(id, false);
        }

        public Pool add(String id, boolean enchant) {
            return this.add(id, 0, enchant);
        }

        public Pool add(String id, int weight, boolean enchant) {
            Entry entry = new Entry(id);
            if (weight > 0) {
                entry.weight = weight;
            }
            if (enchant) {
                entry.enchant();
            }
            this.entries.add(entry);
            return this;
        }

        public static class Entry {
            public String id;
            public int weight = 1;
            public Enchant enchant = null;

            public Entry(String id) {
                this.id = id;
            }

            public Entry enchant() {
                this.enchant = new Enchant();
                return this;
            }

            public Entry enchant(int min, int max) {
                this.enchant = new Enchant(min, max);
                return this;
            }

            public static class Enchant {
                public float min_power = 1.0f;
                public float max_power = 30.0f;
                public boolean allow_treasure = true;

                public Enchant() {
                }

                public Enchant(float min_power, float max_power) {
                    this.min_power = min_power;
                    this.max_power = max_power;
                }

                public boolean isValid() {
                    return this.min_power > 0.0f && this.max_power > this.min_power;
                }
            }
        }
    }
}

