/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.loot;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.class_106;
import net.minecraft.class_117;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_40;
import net.minecraft.class_44;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_5662;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_85;
import net.minecraft.class_91;
import net.spell_engine.api.loot.LootConfig;
import net.tinyconfig.ConfigManager;

public class LootHelper {
    public static ConfigManager<TagCache> TAG_CACHE = new ConfigManager("tag_cache", (Object)new TagCache()).builder().setDirectory("rpg_series").sanitize(true).build();

    public static void updateTagCache(LootConfig lootConfig) {
        HashSet<String> updatedTags = new HashSet<String>();
        for (Map.Entry<String, LootConfig.Pool> entry : lootConfig.injectors.entrySet()) {
            String tableId = entry.getKey();
            LootConfig.Pool pool = entry.getValue();
            for (LootConfig.Pool.Entry itemInjectorEntry : pool.entries) {
                String tagString;
                String id = itemInjectorEntry.id;
                if (id == null || !id.startsWith("#") || updatedTags.contains(tagString = id.substring(1))) continue;
                class_2960 tagId = class_2960.method_60654((String)tagString);
                class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)tagId);
                ArrayList itemList = new ArrayList();
                class_7923.field_41178.method_40286(tag).forEach(itemEntry -> {
                    class_2960 itemId = ((class_5321)itemEntry.method_40230().get()).method_29177();
                    itemList.add(itemId.toString());
                });
                ((TagCache)LootHelper.TAG_CACHE.value).cache.put(tagString, itemList);
                updatedTags.add(tagString);
            }
        }
        TAG_CACHE.save();
    }

    public static void configureV2(class_7225.class_7874 registries, class_2960 id, class_52.class_53 tableBuilder, LootConfig config, HashMap<String, class_1792> entries) {
        String tableId = id.toString();
        LootConfig.Pool pool = config.injectors.get(tableId);
        if (pool == null) {
            for (String regex : config.regex_injectors.keySet()) {
                if (!tableId.matches(regex)) continue;
                pool = config.regex_injectors.get(regex);
                break;
            }
        }
        if (pool == null) {
            return;
        }
        float rolls = pool.rolls > 0.0f ? pool.rolls : 1.0f;
        class_55.class_56 lootPoolBuilder = class_55.method_347();
        double attempts = Math.ceil(rolls);
        double chance = (double)pool.rolls / attempts;
        lootPoolBuilder.method_352((class_5658)class_40.method_273((int)((int)attempts), (float)((float)chance)));
        lootPoolBuilder.method_35509((class_5658)class_44.method_32448((float)pool.bonus_rolls));
        for (LootConfig.Pool.Entry injectEntry : pool.entries) {
            String entryId = injectEntry.id;
            int weight = injectEntry.weight;
            LootConfig.Pool.Entry.Enchant enchant = injectEntry.enchant;
            if (entryId == null || entryId.isEmpty()) continue;
            if (entryId.startsWith("#")) {
                String tagString = entryId.substring(1);
                List<String> itemList = ((TagCache)LootHelper.TAG_CACHE.value).cache.get(tagString);
                if (itemList != null && !itemList.isEmpty()) {
                    for (String itemId : itemList) {
                        class_1792 item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)itemId));
                        if (item == null) continue;
                        class_85.class_86 entry = class_77.method_411((class_1935)item).method_437(weight);
                        if (enchant != null && enchant.isValid()) {
                            class_106.class_107 enchantFunction = class_106.method_481((class_7225.class_7874)registries, (class_5658)class_5662.method_32462((float)enchant.min_power, (float)enchant.max_power));
                            entry.method_438((class_117.class_118)enchantFunction);
                        }
                        lootPoolBuilder.method_351((class_79.class_80)entry);
                    }
                    continue;
                }
                class_2960 tagId = class_2960.method_60654((String)tagString);
                class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)tagId);
                if (tag == null) continue;
                class_85.class_86 entry = class_91.method_445((class_6862)tag).method_437(weight);
                if (enchant != null && enchant.isValid()) {
                    class_106.class_107 enchantFunction = class_106.method_481((class_7225.class_7874)registries, (class_5658)class_5662.method_32462((float)enchant.min_power, (float)enchant.max_power));
                    entry.method_438((class_117.class_118)enchantFunction);
                }
                lootPoolBuilder.method_351((class_79.class_80)entry);
                continue;
            }
            class_1792 item = entries.get(entryId);
            if (item == null) continue;
            class_85.class_86 entry = class_77.method_411((class_1935)item).method_437(weight);
            if (enchant != null && enchant.isValid()) {
                class_106.class_107 enchantFunction = class_106.method_481((class_7225.class_7874)registries, (class_5658)class_5662.method_32462((float)enchant.min_power, (float)enchant.max_power));
                entry.method_438((class_117.class_118)enchantFunction);
            }
            lootPoolBuilder.method_351((class_79.class_80)entry);
        }
        tableBuilder.pool(lootPoolBuilder.method_355());
    }

    public static class TagCache {
        public HashMap<String, List<String>> cache = new HashMap();
    }
}

