/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.spell;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;

public record SpellContainer(ContentType content, boolean is_proxy, String pool, int max_spell_count, List<String> spell_ids) {
    public static final Codec<SpellContainer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ContentType.CODEC.optionalFieldOf("content", (Object)ContentType.MAGIC).forGetter(x -> x.content), (App)Codec.BOOL.optionalFieldOf("is_proxy", (Object)false).forGetter(x -> x.is_proxy), (App)Codec.STRING.optionalFieldOf("pool", (Object)"").forGetter(x -> x.pool), (App)Codec.INT.optionalFieldOf("max_spell_count", (Object)0).forGetter(x -> x.max_spell_count), (App)Codec.STRING.listOf().optionalFieldOf("spell_ids", List.of()).forGetter(x -> x.spell_ids)).apply((Applicative)instance, SpellContainer::new));

    public SpellContainer(ContentType content, boolean is_proxy, String pool, int max_spell_count, List<String> spell_ids) {
        this.content = content != null ? content : ContentType.MAGIC;
        this.is_proxy = is_proxy;
        this.pool = pool != null ? pool : "";
        this.max_spell_count = max_spell_count;
        this.spell_ids = spell_ids != null ? spell_ids : List.of();
    }

    public int cappedIndex(int selected) {
        if (this.spell_ids.isEmpty()) {
            return 0;
        }
        int remainder = selected % this.spell_ids.size();
        return remainder >= 0 ? remainder : remainder + this.spell_ids.size();
    }

    public String spellId(int selected) {
        if (this.spell_ids == null || this.spell_ids.isEmpty()) {
            return null;
        }
        int index = this.cappedIndex(selected);
        return this.spell_ids.get(index);
    }

    public boolean isValid() {
        if (this.is_proxy) {
            return true;
        }
        if (this.max_spell_count < 0) {
            return false;
        }
        return !this.spell_ids.isEmpty() || this.pool != null && !this.pool.isEmpty();
    }

    public boolean isUsable() {
        return this.isValid() && !this.spell_ids.isEmpty();
    }

    public SpellContainer copy() {
        return new SpellContainer(this.content, this.is_proxy, this.pool, this.max_spell_count, new ArrayList<String>(this.spell_ids));
    }

    public SpellContainer copyWith(List<String> spell_ids) {
        return new SpellContainer(this.content, this.is_proxy, this.pool, this.max_spell_count, spell_ids);
    }

    public static enum ContentType {
        MAGIC,
        ARCHERY;

        public static Codec<ContentType> CODEC;

        static {
            CODEC = Codec.STRING.xmap(ContentType::valueOf, Enum::name);
        }
    }
}

