/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.input;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_315;
import net.minecraft.class_3675;
import net.minecraft.class_746;
import net.minecraft.class_8710;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.api.item.trinket.SpellBookItem;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.SpellContainer;
import net.spell_engine.api.spell.SpellInfo;
import net.spell_engine.client.SpellEngineClient;
import net.spell_engine.client.gui.HudMessages;
import net.spell_engine.client.input.Keybindings;
import net.spell_engine.client.input.WrappedKeybinding;
import net.spell_engine.internals.SpellContainerHelper;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.SpellRegistry;
import net.spell_engine.internals.casting.SpellCast;
import net.spell_engine.internals.casting.SpellCasterClient;
import net.spell_engine.mixin.client.control.KeybindingAccessor;
import net.spell_engine.network.Packets;
import org.jetbrains.annotations.Nullable;

public class SpellHotbar {
    public static SpellHotbar INSTANCE = new SpellHotbar();
    private static final class_2960 offhandUseSpellId = class_2960.method_60655((String)"spell_engine", (String)"use_offhand_item");
    private static class_304 deadKey = new class_304("keybindings.spell_engine.dead", class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), SpellEngineMod.modName());
    public List<Slot> slots = List.of();
    public StructuredSlots structuredSlots = new StructuredSlots(null, List.of());
    public boolean showsOffHandUse = false;
    @Nullable
    private Handle handledThisTick = null;
    @Nullable
    private Handle handledPreviousTick = null;
    private boolean skipHandling = false;
    private SpellCast.Attempt lastDisplayedAttempt = null;
    private class_2960 lastSyncedSpellId = null;
    private final HashMap<class_304, UseCase> debounced = new HashMap();

    public boolean update(class_746 player, class_315 options) {
        this.showsOffHandUse = false;
        boolean changed = false;
        int initialSlotCount = this.slots.size();
        class_1799 held = player.method_6047();
        SpellContainer container = SpellContainerHelper.getEquipped(held, (class_1657)player);
        ArrayList<Slot> slots = new ArrayList<Slot>();
        class_3675.class_306 useKey = ((KeybindingAccessor)options.field_1904).getBoundKey();
        Slot onUseKey = null;
        ArrayList<Slot> otherSlots = new ArrayList<Slot>();
        List<WrappedKeybinding> allBindings = Keybindings.Wrapped.all();
        if (!(held.method_7909() instanceof SpellBookItem) && container != null) {
            List<String> spellIds = container.spell_ids();
            List<SpellInfo> spellInfoList = spellIds.stream().map(idString -> {
                class_2960 id = class_2960.method_60654((String)idString);
                Spell spell = SpellRegistry.getSpell(id);
                if (spell == null) {
                    return null;
                }
                return new SpellInfo(spell, id);
            }).filter(Objects::nonNull).toList();
            SpellInfo foundSkillForUseKey = null;
            for (SpellInfo spellInfo : spellInfoList) {
                if (spellInfo.spell().mode != Spell.Mode.ITEM_USE || spellInfo.spell().item_use.requires_offhand_item && player.method_6079().method_7960()) continue;
                foundSkillForUseKey = spellInfo;
            }
            if (foundSkillForUseKey != null || container.content() == SpellContainer.ContentType.ARCHERY) {
                allBindings = allBindings.stream().filter(wrappedKeybinding -> {
                    class_304 vanillaKeybinding = wrappedKeybinding.alternative.keyBindingFrom(options);
                    return vanillaKeybinding == null || !vanillaKeybinding.method_1435(options.field_1904);
                }).toList();
            }
            int keyBindingIndex = 0;
            block5: for (SpellInfo spellInfo : spellInfoList) {
                WrappedKeybinding.Unwrapped unwrapped;
                class_2960 spellId = spellInfo.id();
                Spell spell = spellInfo.spell();
                if (spell == null) continue;
                WrappedKeybinding keyBinding = null;
                switch (spell.mode) {
                    case CAST: {
                        if (keyBindingIndex >= allBindings.size()) break;
                        keyBinding = allBindings.get(keyBindingIndex);
                        ++keyBindingIndex;
                        break;
                    }
                    case ITEM_USE: {
                        if (spell.item_use.requires_offhand_item && player.method_6079().method_7960()) continue block5;
                        keyBinding = new WrappedKeybinding(deadKey, WrappedKeybinding.VanillaAlternative.USE_KEY);
                    }
                }
                Slot slot = new Slot(new SpellInfo(spell, spellId), SpellCast.Mode.from(spell), keyBinding, null);
                if (keyBinding != null && (unwrapped = keyBinding.get(options)) != null) {
                    class_3675.class_306 hotbarKey = ((KeybindingAccessor)unwrapped.keyBinding()).getBoundKey();
                    if (hotbarKey.equals((Object)useKey)) {
                        onUseKey = slot;
                    } else {
                        otherSlots.add(slot);
                    }
                }
                slots.add(slot);
            }
        }
        if (SpellEngineClient.config.spellHotbarShowsOffhand) {
            class_1799 offHandStack = player.method_6079();
            boolean itemUseAssignedAlready = false;
            if (onUseKey != null) {
                boolean bl = itemUseAssignedAlready = onUseKey.castMode == SpellCast.Mode.ITEM_USE;
            }
            if (!(itemUseAssignedAlready || slots.isEmpty() || offHandStack.method_7960() || offHandStack.method_7976() == class_1839.field_8952)) {
                WrappedKeybinding keyBinding = new WrappedKeybinding(options.field_1904, WrappedKeybinding.VanillaAlternative.USE_KEY);
                class_2960 spellId = offhandUseSpellId;
                Spell spell = SpellRegistry.getSpell(spellId);
                if (spell != null) {
                    Slot slot = new Slot(new SpellInfo(spell, spellId), SpellCast.Mode.from(spell), keyBinding, Keybindings.bypass_spell_hotbar);
                    slots.add(slot);
                    this.showsOffHandUse = true;
                }
            }
        }
        changed = initialSlotCount != slots.size();
        this.structuredSlots = new StructuredSlots(onUseKey, otherSlots);
        this.slots = slots;
        return changed;
    }

    public void prepare(int itemUseCooldown) {
        this.handledPreviousTick = this.handledThisTick;
        this.handledThisTick = null;
        this.updateDebounced();
        this.skipHandling = !this.lastHandledWasItemBypass() && itemUseCooldown > 0;
    }

    public boolean lastHandledWasItemBypass() {
        return this.handledPreviousTick != null && this.handledPreviousTick.spell().spell().mode == Spell.Mode.ITEM_USE;
    }

    @Nullable
    public Handle handle(class_746 player, class_315 options) {
        return this.handle(player, this.slots, options);
    }

    @Nullable
    public Handle handle(class_746 player, @Nullable Slot slot, class_315 options) {
        if (slot == null) {
            return null;
        }
        return this.handle(player, List.of(slot), options);
    }

    @Nullable
    public Handle handle(class_746 player, List<Slot> slots, class_315 options) {
        if (this.handledThisTick != null || this.skipHandling || player.method_7325()) {
            return null;
        }
        if (Keybindings.bypass_spell_hotbar.method_1434() || SpellEngineClient.config.sneakingByPassSpellHotbar && options.field_1832.method_1434()) {
            return null;
        }
        SpellCasterClient caster = (SpellCasterClient)player;
        SpellCast.Progress casted = caster.getSpellCastProgress();
        class_1799 casterStack = player.method_6047();
        for (Slot slot : slots) {
            WrappedKeybinding.Unwrapped unwrapped;
            if (slot.keybinding == null || (unwrapped = slot.keybinding.get(options)) == null) continue;
            class_304 keyBinding = unwrapped.keyBinding();
            boolean pressed = keyBinding.method_1434();
            Handle handle = Handle.from(slot, keyBinding, unwrapped.vanillaHandle());
            switch (slot.castMode()) {
                case INSTANT: 
                case ITEM_USE: {
                    if (!pressed) break;
                    SpellCast.Attempt attempt = caster.startSpellCast(casterStack, slot.spell.id());
                    this.handledThisTick = handle;
                    this.displayAttempt(attempt);
                    return handle;
                }
                case CHARGE: 
                case CHANNEL: {
                    if (casted != null && casted.process().id().equals((Object)slot.spell.id())) {
                        boolean needsToBeHeld;
                        boolean bl = needsToBeHeld = SpellHelper.isChanneled(casted.process().spell()) ? SpellEngineClient.config.holdToCastChannelled : SpellEngineClient.config.holdToCastCharged;
                        if (needsToBeHeld) {
                            if (pressed) break;
                            caster.cancelSpellCast();
                            this.handledThisTick = handle;
                            return handle;
                        }
                        if (!pressed || !this.isReleased(keyBinding, UseCase.START)) break;
                        caster.cancelSpellCast();
                        this.debounce(keyBinding, UseCase.STOP);
                        this.handledThisTick = handle;
                        return handle;
                    }
                    if (!pressed || !this.isReleased(keyBinding, UseCase.STOP)) break;
                    SpellCast.Attempt attempt = caster.startSpellCast(casterStack, slot.spell.id());
                    this.debounce(keyBinding, UseCase.START);
                    this.handledThisTick = handle;
                    this.displayAttempt(attempt);
                    return handle;
                }
            }
            if (!pressed) continue;
            this.handledThisTick = handle;
            return handle;
        }
        this.lastDisplayedAttempt = null;
        return null;
    }

    private void displayAttempt(SpellCast.Attempt attempt) {
        if (this.lastDisplayedAttempt != null) {
            return;
        }
        if (attempt.isFail()) {
            HudMessages.INSTANCE.castAttemptError(attempt);
        }
        this.lastDisplayedAttempt = attempt;
    }

    public void syncItemUseSkill(class_746 player) {
        class_2960 idToSync = null;
        if (player.method_6115() && this.handledThisTick != null && this.handledThisTick.spell().spell().mode == Spell.Mode.ITEM_USE) {
            idToSync = this.handledThisTick.spell().id();
        }
        if (!Objects.equals(idToSync, this.lastSyncedSpellId)) {
            ClientPlayNetworking.send((class_8710)new Packets.SpellCastSync(idToSync, 1.0f, 1000));
            this.lastSyncedSpellId = idToSync;
        }
    }

    private boolean isReleased(class_304 keybinding, UseCase use) {
        return this.debounced.get(keybinding) != use;
    }

    private void debounce(class_304 keybinding, UseCase use) {
        this.debounced.put(keybinding, use);
    }

    private void updateDebounced() {
        this.debounced.entrySet().removeIf(entry -> !((class_304)entry.getKey()).method_1434());
    }

    public static class_1799 expectedUseStack(class_1657 player) {
        for (class_1268 hand : class_1268.values()) {
            class_1799 itemStack = player.method_5998(hand);
            if (itemStack.method_7976() == class_1839.field_8952) continue;
            return itemStack;
        }
        return class_1799.field_8037;
    }

    public record StructuredSlots(@Nullable Slot onUseKey, List<Slot> other) {
    }

    public record Slot(SpellInfo spell, SpellCast.Mode castMode, @Nullable WrappedKeybinding keybinding, @Nullable class_304 modifier) {
        @Nullable
        public class_304 getKeyBinding(class_315 options) {
            WrappedKeybinding.Unwrapped unwrapped;
            if (this.keybinding != null && (unwrapped = this.keybinding.get(options)) != null) {
                return unwrapped.keyBinding();
            }
            return null;
        }
    }

    public record Handle(SpellInfo spell, class_304 keyBinding, @Nullable WrappedKeybinding.Category category) {
        public static Handle from(Slot slot, class_304 keyBinding, @Nullable WrappedKeybinding.Category category) {
            return new Handle(slot.spell, keyBinding, category);
        }
    }

    private static enum UseCase {
        START,
        STOP;

    }
}

