/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.render;

import java.util.List;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_742;
import net.minecraft.class_7833;
import net.spell_engine.api.render.CustomLayers;
import net.spell_engine.api.render.LightEmission;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.client.beam.BeamEmitterEntity;
import net.spell_engine.internals.Beam;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.casting.SpellCasterEntity;
import net.spell_engine.utils.TargetHelper;

public class BeamRenderer
extends class_1921 {
    public static void setup() {
        WorldRenderEvents.AFTER_TRANSLUCENT.register(context -> {
            class_4597.class_4598 vcProvider = class_310.method_1551().method_22940().method_23000();
            BeamRenderer.renderAllInWorld(context, context.matrixStack(), vcProvider, context.camera(), 0xF000F0, context.tickCounter().method_60637(true));
        });
    }

    public static void renderAllInWorld(WorldRenderContext context, class_4587 matrices, class_4597.class_4598 vertexConsumers, class_4184 camera, int light, float delta) {
        class_1297 focusedEntity = context.camera().method_19331();
        if (focusedEntity == null) {
            return;
        }
        int renderDistance = (Integer)class_310.method_1551().field_1690.method_42503().method_41753() * 24;
        int squaredRenderDistance = renderDistance * renderDistance;
        List<class_742> players = context.world().method_18456().stream().filter(player -> player.method_5858(focusedEntity) < (double)squaredRenderDistance && ((SpellCasterEntity)player).getBeam() != null).toList();
        if (players.isEmpty()) {
            return;
        }
        matrices.method_22903();
        class_243 camPos = camera.method_19326();
        matrices.method_22904(-camPos.field_1352, -camPos.field_1351, -camPos.field_1350);
        for (class_742 livingEntity : players) {
            float launchHeight = SpellHelper.launchHeight((class_1309)livingEntity);
            class_243 offset = new class_243(0.0, (double)launchHeight, (double)SpellHelper.launchPointOffsetDefault);
            SpellCasterEntity caster = (SpellCasterEntity)livingEntity;
            matrices.method_22903();
            class_243 pos = new class_243(livingEntity.field_6014, livingEntity.field_6036, livingEntity.field_5969).method_35590(livingEntity.method_19538(), (double)delta);
            matrices.method_22904(pos.field_1352, pos.field_1351, pos.field_1350);
            class_243 from = livingEntity.method_19538().method_1031(0.0, (double)launchHeight, 0.0);
            class_243 lookVector = class_243.field_1353;
            if (livingEntity == class_310.method_1551().field_1724) {
                lookVector = class_243.method_1030((float)livingEntity.method_36455(), (float)livingEntity.method_36454());
            } else {
                lookVector = class_243.method_1030((float)livingEntity.field_6004, (float)livingEntity.field_5982);
                lookVector = lookVector.method_35590(class_243.method_1030((float)livingEntity.method_36455(), (float)livingEntity.method_36454()), (double)delta);
            }
            lookVector = lookVector.method_1029();
            Beam.Position beamPosition = TargetHelper.castBeam((class_1309)livingEntity, lookVector, 32.0f);
            lookVector = lookVector.method_1021((double)beamPosition.length());
            class_243 to = from.method_1019(lookVector);
            Spell.Release.Target.Beam beamAppearance = caster.getBeam();
            BeamRenderer.renderBeamFromPlayer(matrices, (class_4597)vertexConsumers, beamAppearance, from, to, offset, livingEntity.method_37908().method_8510(), delta);
            ((BeamEmitterEntity)livingEntity).setLastRenderedBeam(new Beam.Rendered(beamPosition, beamAppearance));
            matrices.method_22909();
        }
        vertexConsumers.method_22993();
        matrices.method_22909();
    }

    private static void renderBeamFromPlayer(class_4587 matrixStack, class_4597 vertexConsumerProvider, Spell.Release.Target.Beam beam, class_243 from, class_243 to, class_243 offset, long time, float tickDelta) {
        float absoluteTime = (float)Math.floorMod(time, 40) + tickDelta;
        matrixStack.method_22903();
        matrixStack.method_22904(0.0, offset.field_1351, 0.0);
        class_243 beamVector = to.method_1020(from);
        float length = (float)beamVector.method_1033();
        beamVector = beamVector.method_1029();
        float n = (float)Math.acos(beamVector.field_1351);
        float o = (float)Math.atan2(beamVector.field_1350, beamVector.field_1352);
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees((1.5707964f - o) * 57.295776f));
        matrixStack.method_22907(class_7833.field_40714.rotationDegrees(n * 57.295776f));
        matrixStack.method_22904(0.0, offset.field_1350, 0.0);
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(absoluteTime * 2.25f - 45.0f));
        class_2960 texture = class_2960.method_60654((String)beam.texture_id);
        long color = beam.color_rgba;
        long red = color >> 24 & 0xFFL;
        long green = color >> 16 & 0xFFL;
        long blue = color >> 8 & 0xFFL;
        long alpha = color & 0xFFL;
        BeamRenderer.renderBeam(matrixStack, vertexConsumerProvider, texture, time, tickDelta, beam.flow, true, (int)red, (int)green, (int)blue, (int)alpha, 0.0f, length, beam.width);
        matrixStack.method_22909();
    }

    public BeamRenderer(String name, class_293 vertexFormat, class_293.class_5596 drawMode, int expectedBufferSize, boolean hasCrumbling, boolean translucent, Runnable startAction, Runnable endAction) {
        super(name, vertexFormat, drawMode, expectedBufferSize, hasCrumbling, translucent, startAction, endAction);
    }

    public static void renderBeam(class_4587 matrices, class_4597 vertexConsumers, class_2960 texture, long time, float tickDelta, float direction, boolean center, int red, int green, int blue, int alpha, float yOffset, float height, float width) {
        matrices.method_22903();
        float shift = (float)Math.floorMod(time, 40) + tickDelta;
        float offset = class_3532.method_22450((float)(shift * 0.2f - (float)class_3532.method_15375((float)(shift * 0.1f)))) * -direction;
        class_1921 outerRenderLayer = CustomLayers.beam(texture, false, true);
        class_1921 innerRenderLayer = CustomLayers.spellObject(texture, LightEmission.RADIATE, false);
        float originalWidth = width;
        if (center) {
            BeamRenderer.renderBeamLayer(matrices, vertexConsumers.getBuffer(innerRenderLayer), red, green, blue, alpha, yOffset, height, 0.0f, width, width, 0.0f, -width, 0.0f, 0.0f, -width, 0.0f, 1.0f, height, offset);
        }
        width = originalWidth * 1.5f;
        BeamRenderer.renderBeamLayer(matrices, vertexConsumers.getBuffer(outerRenderLayer), red, green, blue, (int)((double)alpha * 0.75), yOffset, height, 0.0f, width, width, 0.0f, -width, 0.0f, 0.0f, -width, 0.0f, 1.0f, height, offset * 0.9f);
        width = originalWidth * 2.0f;
        BeamRenderer.renderBeamLayer(matrices, vertexConsumers.getBuffer(outerRenderLayer), red, green, blue, alpha / 3, yOffset, height, 0.0f, width, width, 0.0f, -width, 0.0f, 0.0f, -width, 0.0f, 1.0f, height, offset * 0.8f);
        matrices.method_22909();
    }

    private static void renderBeamLayer(class_4587 matrices, class_4588 vertices, int red, int green, int blue, int alpha, float yOffset, float height, float x1, float z1, float x2, float z2, float x3, float z3, float x4, float z4, float u1, float u2, float v1, float v2) {
        class_4587.class_4665 matrix = matrices.method_23760();
        BeamRenderer.renderBeamFace(matrix, vertices, red, green, blue, alpha, yOffset, height, x1, z1, x2, z2, u1, u2, v1, v2);
        BeamRenderer.renderBeamFace(matrix, vertices, red, green, blue, alpha, yOffset, height, x4, z4, x3, z3, u1, u2, v1, v2);
        BeamRenderer.renderBeamFace(matrix, vertices, red, green, blue, alpha, yOffset, height, x2, z2, x4, z4, u1, u2, v1, v2);
        BeamRenderer.renderBeamFace(matrix, vertices, red, green, blue, alpha, yOffset, height, x3, z3, x1, z1, u1, u2, v1, v2);
    }

    private static void renderBeamFace(class_4587.class_4665 matrix, class_4588 vertices, int red, int green, int blue, int alpha, float yOffset, float height, float x1, float z1, float x2, float z2, float u1, float u2, float v1, float v2) {
        BeamRenderer.renderBeamVertex(matrix, vertices, red, green, blue, alpha, height, x1, z1, u2, v1);
        BeamRenderer.renderBeamVertex(matrix, vertices, red, green, blue, alpha, yOffset, x1, z1, u2, v2);
        BeamRenderer.renderBeamVertex(matrix, vertices, red, green, blue, alpha, yOffset, x2, z2, u1, v2);
        BeamRenderer.renderBeamVertex(matrix, vertices, red, green, blue, alpha, height, x2, z2, u1, v1);
    }

    private static void renderBeamVertex(class_4587.class_4665 matrix, class_4588 vertices, int red, int green, int blue, int alpha, float y, float x, float z, float u, float v) {
        vertices.method_56824(matrix, x, y, z).method_1336(red, green, blue, alpha).method_22913(u, v).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(matrix, 0.0f, 1.0f, 0.0f);
    }
}

