/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.compat;

import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.util.TriState;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.spell_engine.api.item.trinket.SpellBookTrinketItem;
import net.spell_engine.api.spell.SpellContainer;
import net.spell_engine.internals.SpellContainerHelper;

public class TrinketsCompat {
    private static boolean intialized = false;
    private static boolean enabled = false;

    public static void init() {
        if (intialized) {
            return;
        }
        enabled = FabricLoader.getInstance().isModLoaded("trinkets");
        if (enabled) {
            TrinketsApi.registerTrinketPredicate((class_2960)class_2960.method_60655((String)"spell_engine", (String)"spell_book"), (itemStack, slotReference, livingEntity) -> {
                if (itemStack.method_7909() instanceof SpellBookTrinketItem) {
                    return TriState.TRUE;
                }
                return TriState.DEFAULT;
            });
            class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)SpellBookTrinketItem.EQUIP_SOUND_ID, (Object)SpellBookTrinketItem.EQUIP_SOUND);
        }
        intialized = true;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static List<String> getEquippedSpells(SpellContainer proxyContainer, class_1657 player) {
        if (!enabled) {
            return Collections.emptyList();
        }
        Optional component = TrinketsApi.getTrinketComponent((class_1309)player);
        if (component.isEmpty() || proxyContainer == null || !proxyContainer.is_proxy()) {
            return Collections.emptyList();
        }
        TrinketComponent trinketComponent = (TrinketComponent)component.get();
        SpellContainer.ContentType allowedContent = proxyContainer.content();
        LinkedHashSet<class_1799> items = new LinkedHashSet<class_1799>();
        TrinketInventory spellBookSlot = (TrinketInventory)((Map)trinketComponent.getInventory().get("charm")).get("spell_book");
        items.add(spellBookSlot.method_5438(0));
        trinketComponent.getAllEquipped().forEach(pair -> items.add((class_1799)pair.method_15441()));
        LinkedHashSet<String> collectedSpellIds = new LinkedHashSet<String>(proxyContainer.spell_ids());
        for (class_1799 stack : items) {
            SpellContainer container;
            if (stack.method_7960() || (container = SpellContainerHelper.containerFromItemStack(stack)) == null || !container.isValid() || container.content() != allowedContent) continue;
            collectedSpellIds.addAll(container.spell_ids());
        }
        return new ArrayList<String>(collectedSpellIds);
    }

    public static class_1799 getSpellBookStack(class_1657 player) {
        if (!enabled) {
            return class_1799.field_8037;
        }
        Optional component = TrinketsApi.getTrinketComponent((class_1309)player);
        if (component.isEmpty()) {
            return class_1799.field_8037;
        }
        return ((TrinketInventory)((Map)((TrinketComponent)component.get()).getInventory().get("charm")).get("spell_book")).method_5438(0);
    }
}

