/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.config;

import java.util.LinkedHashMap;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import net.spell_engine.utils.TargetHelper;

@Config(name="server")
public class ServerConfig
implements ConfigData {
    @Comment(value="Applied as multiplier on top of spell.cast.movement_speed. Default value of 1.0 means no change.")
    public float movement_multiplier_speed_while_casting = 1.0f;
    @Comment(value="Allow spells to bypass invulnerability frames. This is required in order for high attack frequency spells (such as beams) to work.")
    public boolean bypass_iframes = true;
    @Comment(value="Spell haste reduces the cooldown time of abilities")
    public boolean haste_affects_cooldown = true;
    @Comment(value="Spell costs exhausts (hunger) will be multiplied with this value. Set `0` for no exhaust.")
    public float spell_cost_exhaust_multiplier = 1.0f;
    @Comment(value="Spells should cost items. Set `false` to remove rune (or other item) cost from all spells.")
    public boolean spell_cost_item_allowed = true;
    @Comment(value="Spells should damage items on use. Set `false` to disable.")
    public boolean spell_cost_durability_allowed = true;
    @Comment(value="The time in ticks of global cooldown to apply to all instant cast spells when casted.")
    public int spell_instant_cast_gcd = 0;
    @Comment(value="Players cannot unequip a spell book, if one of the spells in it is on cooldown.")
    public boolean spell_book_cooldown_lock = true;
    @Comment(value="Players can use the Spell Binding Table to create spell books.")
    public boolean spell_book_creation_enabled = true;
    @Comment(value="Spell book creation level cost")
    public int spell_book_creation_cost = 1;
    @Comment(value="Spell book creation level requirement")
    public int spell_book_creation_requirement = 1;
    @Comment(value="Spell binding level cost multiplier")
    public int spell_binding_level_cost_multiplier = 1;
    @Comment(value="Spell binding lapis lazuli cost multiplier")
    public int spell_binding_lapis_cost_multiplier = 1;
    @Comment(value="Should the player be able to cast spells from the offhand spell book?")
    public boolean spell_book_offhand = false;
    @Comment(value="If set true, a Fireball doesn't collide with an ally, a healing projectile doesn't collide with an enemy")
    public boolean projectiles_pass_thru_irrelevant_targets = true;
    @Comment(value="Auto swap Bow & Spear cooldown ticks to apply for attack and itemUse")
    public int auto_swap_cooldown = 5;
    @Comment(value="Apply `Spell Casting from Spell Book` capability to anything that subclasses Sword")
    public boolean add_spell_casting_to_swords = true;
    @Comment(value="Apply `Spell Casting from Spell Book` capability to any item matching this regex. (Not applied of empty)")
    public String add_spell_casting_regex = "";
    @Comment(value="Do not apply `Spell Casting from Spell Book` capability to any item matching this regex. (Not applied of empty)")
    public String blacklist_spell_casting_regex = "";
    @Comment(value="Relations determine which cases the effect of a player casted spell can effect a target.\n+----------------+-------+----------+----------+----------+--------+\n|                | ALLY  | FRIENDLY | NEUTRAL  | HOSTILE  | MIXED  |\n+----------------+-------+----------+----------+----------+--------+\n| DIRECT DAMAGE  | \ud83d\udeab    | \u2705       | \u2705       | \u2705       | \u2705    |\n| AREA DAMAGE    | \ud83d\udeab    | \ud83d\udeab       | \ud83d\udeab       | \u2705       | \u2705    |\n| DIRECT HEALING | \u2705    | \u2705       | \u2705       | \ud83d\udeab       | \u2705    |\n| AREA HEALING   | \u2705    | \u2705       | \ud83d\udeab       | \ud83d\udeab       | \u2705    |\n+----------------+-------+----------+----------+----------+--------+\n\nThe various relation related configs are being checked in the following order:\n- `player_relations`\n- `player_relation_to_passives`\n- `player_relation_to_hostiles`\n- `player_relation_to_other`\n(The first relation to be found for the target will be applied.)\n")
    public LinkedHashMap<String, TargetHelper.Relation> player_relations = new LinkedHashMap<String, TargetHelper.Relation>(){
        {
            this.put("minecraft:player", TargetHelper.Relation.FRIENDLY);
            this.put("minecraft:villager", TargetHelper.Relation.FRIENDLY);
            this.put("minecraft:iron_golem", TargetHelper.Relation.NEUTRAL);
            this.put("guardvillagers:guard", TargetHelper.Relation.FRIENDLY);
            this.put("minecraft:cat", TargetHelper.Relation.FRIENDLY);
        }
    };
    @Comment(value="Relation to unspecified entities those are instance of PassiveEntity(Yarn)")
    public TargetHelper.Relation player_relation_to_passives = TargetHelper.Relation.HOSTILE;
    @Comment(value="Relation to unspecified entities those are instance of HostileEntity(Yarn)")
    public TargetHelper.Relation player_relation_to_hostiles = TargetHelper.Relation.HOSTILE;
    @Comment(value="Fallback relation")
    public TargetHelper.Relation player_relation_to_other = TargetHelper.Relation.HOSTILE;
}

