/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.entity;

import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_8046;
import net.spell_engine.api.spell.ParticleBatch;
import net.spell_engine.api.spell.Sound;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.SpellInfo;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.SpellRegistry;
import net.spell_engine.particle.ParticleHelper;
import net.spell_engine.utils.SoundPlayerWorld;
import org.jetbrains.annotations.Nullable;

public class SpellCloud
extends class_1297
implements class_8046 {
    public static class_1299<SpellCloud> ENTITY_TYPE;
    @Nullable
    private class_1309 owner;
    @Nullable
    private UUID ownerUuid;
    private int timeToLive;
    private class_2960 spellId;
    private int dataIndex = 0;
    private SpellHelper.ImpactContext context;
    private static final class_2940<String> SPELL_ID_TRACKER;
    private static final class_2940<Integer> DATA_INDEX_TRACKER;
    private static final class_2940<Float> RADIUS_TRACKER;
    private boolean presenceSoundFired = false;

    public SpellCloud(class_1299<? extends SpellCloud> entityType, class_1937 world) {
        super(entityType, world);
    }

    public SpellCloud(class_1937 world) {
        super(ENTITY_TYPE, world);
        this.field_5960 = true;
    }

    public void onCreatedFromSpell(class_2960 spellId, Spell.Release.Target.Cloud cloudData, SpellHelper.ImpactContext context) {
        this.spellId = spellId;
        this.context = context;
        Spell spell = this.getSpell();
        if (spell != null) {
            int index = -1;
            List<Spell.Release.Target.Cloud> dataList = List.of(spell.release.target.clouds);
            if (!dataList.isEmpty()) {
                index = dataList.indexOf(cloudData);
            }
            this.dataIndex = index;
        }
        this.method_5841().method_12778(SPELL_ID_TRACKER, (Object)this.spellId.toString());
        this.method_5841().method_12778(DATA_INDEX_TRACKER, (Object)this.dataIndex);
        this.method_5841().method_12778(RADIUS_TRACKER, (Object)Float.valueOf(this.calculateRadius()));
        this.timeToLive = (int)(cloudData.time_to_live_seconds * 20.0f);
    }

    private float calculateRadius() {
        Spell.Release.Target.Cloud cloudData = this.getCloudData();
        if (cloudData != null) {
            float radius = cloudData.volume.radius;
            if (this.context != null) {
                radius = cloudData.volume.combinedRadius(this.context.power());
            }
            return radius;
        }
        return 0.0f;
    }

    public class_4048 method_18377(class_4050 pose) {
        Spell.Release.Target.Cloud cloudData = this.getCloudData();
        if (cloudData != null) {
            Float radius = (Float)this.method_5841().method_12789(RADIUS_TRACKER);
            float heightMultiplier = cloudData.volume.area.vertical_range_multiplier;
            return class_4048.method_18384((float)(radius.floatValue() * 2.0f), (float)(radius.floatValue() * heightMultiplier));
        }
        return super.method_18377(pose);
    }

    public void setOwner(@Nullable class_1309 owner) {
        this.owner = owner;
        this.ownerUuid = owner == null ? null : owner.method_5667();
    }

    @Nullable
    public class_1297 method_24921() {
        class_1297 entity;
        if (this.owner == null && this.ownerUuid != null && this.method_37908() instanceof class_3218 && (entity = ((class_3218)this.method_37908()).method_14190(this.ownerUuid)) instanceof class_1309) {
            this.owner = (class_1309)entity;
        }
        return this.owner;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(SPELL_ID_TRACKER, (Object)"");
        builder.method_56912(DATA_INDEX_TRACKER, (Object)this.dataIndex);
        builder.method_56912(RADIUS_TRACKER, (Object)Float.valueOf(0.0f));
    }

    public void method_5674(class_2940<?> data) {
        super.method_5674(data);
        String rawSpellId = (String)this.method_5841().method_12789(SPELL_ID_TRACKER);
        if (rawSpellId != null && !rawSpellId.isEmpty()) {
            this.spellId = class_2960.method_60654((String)rawSpellId);
        }
        this.dataIndex = (Integer)this.method_5841().method_12789(DATA_INDEX_TRACKER);
        this.method_18382();
    }

    protected void method_5749(class_2487 nbt) {
        this.field_6012 = nbt.method_10550(NBTKey.AGE.key);
        this.timeToLive = nbt.method_10550(NBTKey.TIME_TO_LIVE.key);
        this.spellId = class_2960.method_60654((String)nbt.method_10558(NBTKey.SPELL_ID.key));
        this.dataIndex = nbt.method_10550(NBTKey.DATA_INDEX.key);
    }

    protected void method_5652(class_2487 nbt) {
        nbt.method_10569(NBTKey.AGE.key, this.field_6012);
        nbt.method_10569(NBTKey.TIME_TO_LIVE.key, this.timeToLive);
        nbt.method_10582(NBTKey.SPELL_ID.key, this.spellId.toString());
        nbt.method_10569(NBTKey.DATA_INDEX.key, this.dataIndex);
    }

    public boolean method_5701() {
        return false;
    }

    public void method_5773() {
        super.method_5773();
        Spell.Release.Target.Cloud cloudData = this.getCloudData();
        if (cloudData == null) {
            return;
        }
        class_1937 world = this.method_37908();
        if (world.field_9236) {
            Spell.Release.Target.Cloud.ClientData clientData = cloudData.client_data;
            for (ParticleBatch particleBatch : clientData.particles) {
                ParticleHelper.play(world, (class_1297)this, particleBatch);
            }
            Sound presence_sound = cloudData.presence_sound;
            if (!this.presenceSoundFired && presence_sound != null) {
                class_3414 soundEvent = class_3414.method_47908((class_2960)class_2960.method_60654((String)presence_sound.id()));
                ((SoundPlayerWorld)world).playSoundFromEntity(this, soundEvent, class_3419.field_15248, presence_sound.volume(), presence_sound.randomizedPitch());
                this.presenceSoundFired = true;
            }
        } else {
            if (this.field_6012 >= this.timeToLive) {
                this.method_31472();
                return;
            }
            if (this.field_6012 % cloudData.impact_tick_interval == 0) {
                Spell.AreaImpact area_impact = cloudData.volume;
                class_1309 owner = (class_1309)this.method_24921();
                Spell spell = this.getSpell();
                if (area_impact != null && owner != null && spell != null) {
                    SpellHelper.ImpactContext context = this.context;
                    if (context == null) {
                        context = new SpellHelper.ImpactContext();
                    }
                    SpellHelper.lookupAndPerformAreaImpact(area_impact, new SpellInfo(spell, this.spellId), owner, null, this, context.position(this.method_19538()), true);
                }
            }
        }
    }

    @Nullable
    public Spell.Release.Target.Cloud getCloudData() {
        Spell spell = this.getSpell();
        if (spell != null) {
            if (spell.release.target.clouds.length > 0) {
                return spell.release.target.clouds[this.dataIndex];
            }
            return spell.release.target.cloud;
        }
        return null;
    }

    public Spell getSpell() {
        return SpellRegistry.getSpell(this.spellId);
    }

    static {
        SPELL_ID_TRACKER = class_2945.method_12791(SpellCloud.class, (class_2941)class_2943.field_13326);
        DATA_INDEX_TRACKER = class_2945.method_12791(SpellCloud.class, (class_2941)class_2943.field_13327);
        RADIUS_TRACKER = class_2945.method_12791(SpellCloud.class, (class_2941)class_2943.field_13320);
    }

    private static enum NBTKey {
        AGE("Age"),
        TIME_TO_LIVE("TTL"),
        SPELL_ID("SpellId"),
        DATA_INDEX("DataIndex");

        public final String key;

        private NBTKey(String key) {
            this.key = key;
        }
    }
}

