/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.SpellContainer;
import net.spell_engine.api.spell.SpellDataComponents;
import net.spell_engine.api.spell.SpellInfo;
import net.spell_engine.api.spell.SpellPool;
import net.spell_engine.compat.TrinketsCompat;
import net.spell_engine.internals.SpellCasterItemStack;
import net.spell_engine.internals.SpellRegistry;
import org.jetbrains.annotations.Nullable;

public class SpellContainerHelper {
    public static final Comparator<Map.Entry<class_2960, Spell>> spellSorter = (spell1, spell2) -> {
        if (((Spell)spell1.getValue()).learn.tier > ((Spell)spell2.getValue()).learn.tier) {
            return 1;
        }
        if (((Spell)spell1.getValue()).learn.tier < ((Spell)spell2.getValue()).learn.tier) {
            return -1;
        }
        return ((class_2960)spell1.getKey()).toString().compareTo(((class_2960)spell2.getKey()).toString());
    };

    public static class_2960 getPoolId(SpellContainer container) {
        if (container != null && container.pool() != null) {
            return class_2960.method_60654((String)container.pool());
        }
        return null;
    }

    public static SpellPool getPool(SpellContainer container) {
        if (container != null && container.pool() != null) {
            class_2960 id = class_2960.method_60654((String)container.pool());
            return SpellRegistry.spellPool(id);
        }
        return SpellPool.empty;
    }

    public static SpellContainer getEquipped(class_1799 heldItemStack, class_1657 player) {
        SpellContainer weaponContainer = SpellContainerHelper.containerFromItemStack(heldItemStack);
        return SpellContainerHelper.getEquipped(weaponContainer, player);
    }

    public static SpellContainer getEquipped(SpellContainer proxyContainer, class_1657 player) {
        if (proxyContainer == null || !proxyContainer.is_proxy()) {
            return proxyContainer;
        }
        LinkedHashSet<String> spellIds = new LinkedHashSet<String>(proxyContainer.spell_ids());
        if (TrinketsCompat.isEnabled()) {
            spellIds.addAll(TrinketsCompat.getEquippedSpells(proxyContainer, player));
        }
        if (SpellEngineMod.config.spell_book_offhand && SpellContainerHelper.isOffhandContainerValid(player, proxyContainer.content())) {
            spellIds.addAll(SpellContainerHelper.getOffhandSpellIds(player));
        }
        ArrayList<SpellInfo> spells = new ArrayList<SpellInfo>();
        for (String idString : spellIds) {
            class_2960 id = class_2960.method_60654((String)idString);
            Spell spell = SpellRegistry.getSpell(id);
            if (spell == null) continue;
            spells.add(new SpellInfo(spell, id));
        }
        HashSet<String> toRemove = new HashSet<String>();
        for (SpellInfo spell : spells) {
            String tag = spell.spell().group;
            if (tag == null) continue;
            for (SpellInfo other : spells) {
                if (spell.id().equals((Object)other.id()) || !tag.equals(other.spell().group)) continue;
                if (spell.spell().learn.tier == other.spell().learn.tier && spell.spell().rank > other.spell().rank) {
                    toRemove.add(other.id().toString());
                }
                if (spell.spell().learn.tier <= other.spell().learn.tier) continue;
                toRemove.add(other.id().toString());
            }
        }
        spellIds.removeAll(toRemove);
        return new SpellContainer(proxyContainer.content(), false, null, 0, new ArrayList<String>(spellIds));
    }

    private static boolean isOffhandContainerValid(class_1657 player, SpellContainer.ContentType allowedContent) {
        class_1799 offhandItemStack = SpellContainerHelper.getOffhandItemStack(player);
        SpellContainer container = SpellContainerHelper.containerFromItemStack(offhandItemStack);
        return container != null && container.isValid() && container.content() == allowedContent;
    }

    private static List<String> getOffhandSpellIds(class_1657 player) {
        class_1799 offhandItemStack = SpellContainerHelper.getOffhandItemStack(player);
        SpellContainer container = SpellContainerHelper.containerFromItemStack(offhandItemStack);
        if (container == null) {
            return Collections.emptyList();
        }
        return container.spell_ids();
    }

    private static class_1799 getOffhandItemStack(class_1657 player) {
        return (class_1799)player.method_31548().field_7544.get(0);
    }

    public static SpellContainer containerFromItemStack(class_1799 itemStack) {
        SpellCasterItemStack stack;
        SpellContainer container;
        if (itemStack.method_7960()) {
            return null;
        }
        class_1799 object = itemStack;
        if (object instanceof SpellCasterItemStack && (container = (stack = (SpellCasterItemStack)object).getSpellContainer()) != null && container.isValid()) {
            return container;
        }
        return null;
    }

    public static boolean contains(SpellContainer container, class_2960 spellId) {
        return container != null && container.spell_ids().contains(spellId.toString());
    }

    public static void addContainerToItemStack(SpellContainer container, class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return;
        }
        itemStack.method_57379(SpellDataComponents.SPELL_CONTAINER, (Object)container);
    }

    @Nullable
    public static class_2960 spellId(SpellContainer container, int selectedIndex) {
        if (container == null || !container.isUsable()) {
            return null;
        }
        return class_2960.method_60654((String)container.spellId(selectedIndex));
    }

    public static SpellContainer addSpell(class_2960 spellId, SpellContainer container) {
        ArrayList<String> spellIds = new ArrayList<String>(container.spell_ids());
        spellIds.add(spellId.toString());
        HashMap<class_2960, Spell> spells = new HashMap<class_2960, Spell>();
        for (String idString : spellIds) {
            class_2960 id = class_2960.method_60654((String)idString);
            Spell spell = SpellRegistry.getSpell(id);
            if (spell == null) continue;
            spells.put(id, spell);
        }
        List<String> sortedSpellIds = spells.entrySet().stream().sorted(spellSorter).map(entry -> ((class_2960)entry.getKey()).toString()).collect(Collectors.toList());
        return container.copyWith(sortedSpellIds);
    }

    public static void addSpell(class_2960 spellId, class_1799 itemStack) {
        SpellContainer container = SpellContainerHelper.containerFromItemStack(itemStack);
        if (container == null || !container.isValid()) {
            System.err.println("Trying to add spell: " + String.valueOf(spellId) + " to an ItemStack without valid spell container");
            return;
        }
        SpellContainer modifiedContainer = SpellContainerHelper.addSpell(spellId, container);
        itemStack.method_57379(SpellDataComponents.SPELL_CONTAINER, (Object)modifiedContainer);
    }

    public static boolean hasValidContainer(class_1799 itemStack) {
        return SpellContainerHelper.containerFromItemStack(itemStack) != null;
    }

    public static boolean hasBindableContainer(class_1799 itemStack) {
        SpellContainer container = SpellContainerHelper.containerFromItemStack(itemStack);
        return container != null && container.pool() != null && !container.pool().isEmpty();
    }

    public static boolean hasUsableContainer(class_1799 itemStack) {
        SpellContainer container = SpellContainerHelper.containerFromItemStack(itemStack);
        return container != null && (container.isUsable() || container.is_proxy());
    }
}

