/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.mixin.client;

import com.mojang.authlib.GameProfile;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.api.layered.AnimationStack;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.api.layered.modifier.AdjustmentModifier;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Ease;
import dev.kosmx.playerAnim.core.util.Vec3f;
import dev.kosmx.playerAnim.impl.IAnimatedPlayer;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.util.Optional;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.spell_engine.api.spell.ParticleBatch;
import net.spell_engine.api.spell.Sound;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.client.animation.AnimatablePlayer;
import net.spell_engine.client.animation.AnimationSubStack;
import net.spell_engine.client.animation.StateCollectionHelper;
import net.spell_engine.client.compatibility.FirstPersonModelCompatibility;
import net.spell_engine.client.sound.SpellCastingSound;
import net.spell_engine.internals.casting.SpellCast;
import net.spell_engine.internals.casting.SpellCasterEntity;
import net.spell_engine.mixin.entity.LivingEntityAccessor;
import net.spell_engine.particle.ParticleHelper;
import net.spell_engine.utils.StringUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_742.class})
public abstract class AbstractClientPlayerEntityMixin
extends class_1657
implements AnimatablePlayer,
SpellCastingSound.Listener {
    private final AnimationSubStack castingAnimation = new AnimationSubStack(this.createPitchAdjustment_SpellEngine());
    private final AnimationSubStack releaseAnimation = new AnimationSubStack(this.createPitchAdjustment_SpellEngine());
    private String lastCastAnimationName;
    private String lastCastSoundId;
    private SpellCastingSound lastCastSound;

    public AbstractClientPlayerEntityMixin(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void postInit_SpellEngine(class_638 world, GameProfile profile, CallbackInfo ci) {
        AnimationStack stack = ((IAnimatedPlayer)this).getAnimationStack();
        stack.addAnimLayer(950, (IAnimation)this.releaseAnimation.base);
        stack.addAnimLayer(900, (IAnimation)this.castingAnimation.base);
    }

    @Override
    public void updateSpellCastAnimationsOnTick() {
        AbstractClientPlayerEntityMixin instance = this;
        class_1657 player = instance;
        String castAnimationName = null;
        Sound castSound = null;
        float speed = 1.0f;
        Spell spell = ((SpellCasterEntity)player).getCurrentSpell();
        if (spell != null) {
            castAnimationName = spell.cast.animation;
            castSound = spell.cast.sound;
            ((LivingEntityAccessor)player).invokeTurnHead(player.method_5791(), 0.0f);
            for (ParticleBatch batch : spell.cast.particles) {
                ParticleHelper.play(player.method_37908(), (class_1297)player, player.method_36454(), this.method_36455(), batch);
            }
            speed = ((SpellCasterEntity)player).getCurrentCastingSpeed();
        }
        this.updateCastingAnimation(castAnimationName, speed);
        this.updateCastingSound(castSound);
    }

    private void updateCastingAnimation(String animationName, float speed) {
        if (!StringUtil.matching(animationName, this.lastCastAnimationName)) {
            this.playSpellAnimation(SpellCast.Animation.CASTING, animationName, speed);
        }
        this.lastCastAnimationName = animationName;
    }

    private void updateCastingSound(Sound castSound) {
        String soundId = null;
        if (castSound != null) {
            soundId = castSound.id();
        }
        if (!StringUtil.matching(soundId, this.lastCastSoundId)) {
            if (this.lastCastSound != null) {
                class_310.method_1551().method_1483().method_4870((class_1113)this.lastCastSound);
                this.lastCastSound = null;
            }
            if (castSound != null && soundId != null && !soundId.isEmpty()) {
                class_2960 id = class_2960.method_60654((String)soundId);
                SpellCastingSound sound = new SpellCastingSound((class_1309)this, id, castSound.volume(), castSound.randomizedPitch());
                sound.listener = this;
                class_310.method_1551().method_1483().method_4873((class_1113)sound);
                this.lastCastSound = sound;
            }
        }
        this.lastCastSoundId = soundId;
    }

    @Override
    public void onSpellCastingSoundDone() {
        this.lastCastSound = null;
        this.lastCastSoundId = null;
    }

    private AdjustmentModifier createPitchAdjustment_SpellEngine() {
        AbstractClientPlayerEntityMixin player = this;
        return new AdjustmentModifier(partName -> {
            float rotationX = 0.0f;
            float rotationY = 0.0f;
            float rotationZ = 0.0f;
            float offsetX = 0.0f;
            float offsetY = 0.0f;
            float offsetZ = 0.0f;
            if (FirstPersonMode.isFirstPersonPass()) {
                float pitch = player.method_36455();
                pitch = (float)Math.toRadians(pitch);
                switch (partName) {
                    case "rightArm": 
                    case "leftArm": {
                        rotationX = pitch;
                        break;
                    }
                    default: {
                        return Optional.empty();
                    }
                }
            } else {
                float pitch = player.method_36455() / 2.0f;
                pitch = (float)Math.toRadians(pitch);
                switch (partName) {
                    case "body": {
                        rotationX = -1.0f * pitch;
                        break;
                    }
                    case "rightArm": 
                    case "leftArm": {
                        rotationX = pitch;
                        break;
                    }
                    case "rightLeg": 
                    case "leftLeg": {
                        rotationX = -1.0f * pitch;
                        break;
                    }
                    default: {
                        return Optional.empty();
                    }
                }
            }
            return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(rotationX, rotationY, rotationZ), new Vec3f(offsetX, offsetY, offsetZ)));
        });
    }

    private void updateAnimationByCurrentActivity_SpellEngine(KeyframeAnimation.AnimationBuilder animation) {
        if (this.isMounting_SpellEngine()) {
            StateCollectionHelper.configure(animation.rightLeg, false, false);
            StateCollectionHelper.configure(animation.leftLeg, false, false);
        }
    }

    @Override
    public void playSpellAnimation(SpellCast.Animation type, String name, float speed) {
        try {
            AnimationSubStack stack = this.spellAnimationStackFor(type);
            if (name != null && !name.isEmpty()) {
                class_2960 id = class_2960.method_60654((String)name);
                KeyframeAnimation animation = (KeyframeAnimation)PlayerAnimationRegistry.getAnimation((class_2960)id);
                KeyframeAnimation.AnimationBuilder copy = animation.mutableCopy();
                this.updateAnimationByCurrentActivity_SpellEngine(copy);
                copy.torso.fullyEnablePart(true);
                copy.head.pitch.setEnabled(false);
                copy.head.yaw.setEnabled(true);
                boolean mirror = this.isLeftHanded_SpellEngine();
                int fadeIn = copy.beginTick;
                stack.mirror.setEnabled(mirror);
                stack.base.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)fadeIn, (Ease)Ease.INOUTSINE), (IAnimation)new KeyframeAnimationPlayer(copy.build(), 0).setFirstPersonMode(FirstPersonModelCompatibility.isActive() ? FirstPersonMode.NONE : FirstPersonMode.THIRD_PERSON_MODEL));
                stack.speed.speed = speed;
            } else {
                int fadeOutLength = 5;
                stack.base.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)fadeOutLength, (Ease)Ease.INOUTSINE), null);
                stack.adjustment.fadeOut(fadeOutLength);
                stack.speed.speed = 1.0f;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private AnimationSubStack spellAnimationStackFor(SpellCast.Animation type) {
        switch (type) {
            case CASTING: {
                return this.castingAnimation;
            }
            case RELEASE: {
                return this.releaseAnimation;
            }
        }
        return null;
    }

    private boolean isMounting_SpellEngine() {
        return this.method_5854() != null;
    }

    public boolean isLeftHanded_SpellEngine() {
        return this.method_6068() == class_1306.field_6182;
    }
}

