/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polydex.api.v1.recipe;

import eu.pb4.polydex.api.v1.recipe.PolydexStack;
import eu.pb4.polydex.impl.book.PolydexIngredientImpl;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import org.jetbrains.annotations.ApiStatus;

public interface PolydexIngredient<T> {
    public List<PolydexStack<T>> asStacks();

    public float chance();

    public long amount();

    default public Optional<PolydexStack<T>> asFirstStack() {
        List<PolydexStack<T>> x = this.asStacks();
        if (x.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(x.getFirst());
    }

    default public boolean matches(PolydexStack<?> stack, boolean strict) {
        return this.matchesInternal(stack, strict);
    }

    @ApiStatus.OverrideOnly
    default public boolean matchesInternal(PolydexStack<?> stack, boolean strict) {
        if (stack.getBackingClass().isAssignableFrom(this.getBackingClass())) {
            return this.matchesDirect(stack, strict);
        }
        return false;
    }

    @ApiStatus.OverrideOnly
    public boolean matchesDirect(PolydexStack<T> var1, boolean var2);

    public boolean isEmpty();

    public Class<T> getBackingClass();

    public static PolydexIngredient<class_1799> of(class_1856 ingredient) {
        return PolydexIngredient.of(ingredient, 1L, 1.0f);
    }

    public static PolydexIngredient<class_1799> of(class_1856 ingredient, long count) {
        return PolydexIngredient.of(ingredient, count, 1.0f);
    }

    public static PolydexIngredient<class_1799> of(class_1856 ingredient, long count, float chance) {
        return PolydexIngredientImpl.of(ingredient, count, chance);
    }
}

