/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polydex.api.v1.recipe;

import eu.pb4.polydex.api.v1.recipe.PolydexCategory;
import eu.pb4.polydex.api.v1.recipe.PolydexEntry;
import eu.pb4.polydex.api.v1.recipe.PolydexPage;
import eu.pb4.polydex.api.v1.recipe.PolydexStack;
import eu.pb4.polydex.impl.PolydexImpl;
import eu.pb4.polydex.impl.book.ui.PageViewerGui;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class PolydexPageUtils {
    public static Event<Consumer<MinecraftServer>> BEFORE_PAGE_LOADING = EventFactory.createArrayBacked(Consumer.class, x -> server -> {
        for (Consumer r : x) {
            r.accept(server);
        }
    });
    public static Event<Consumer<MinecraftServer>> AFTER_PAGE_LOADING = EventFactory.createArrayBacked(Consumer.class, x -> server -> {
        for (Consumer r : x) {
            r.accept(server);
        }
    });
    @Deprecated
    public static Event<Runnable> BEFORE_LOADING = EventFactory.createArrayBacked(Runnable.class, x -> () -> {
        for (Runnable r : x) {
            r.run();
        }
    });
    @Deprecated
    public static Event<Runnable> AFTER_LOADING = EventFactory.createArrayBacked(Runnable.class, x -> () -> {
        for (Runnable r : x) {
            r.run();
        }
    });

    public static class_2960 identifierFromRecipe(class_2960 identifier) {
        return identifier.method_45138("recipe/");
    }

    public static class_2561 createText(class_1799 stack) {
        if (stack.method_7960()) {
            return class_2561.method_43471((String)"text.polydex.empty");
        }
        if (stack.method_7947() == 1) {
            return stack.method_7964();
        }
        return class_2561.method_43470((String)(stack.method_7947() + " \u00d7 ")).method_10852(stack.method_7964());
    }

    public static boolean isReady() {
        return PolydexImpl.isReady();
    }

    public static List<PolydexEntry> getAllEntries() {
        return PolydexPageUtils.getAllEntries(true);
    }

    public static List<PolydexEntry> getAllEntries(boolean withEmpty) {
        return PolydexImpl.ITEM_ENTRIES.get(withEmpty);
    }

    public static Collection<PolydexPage> getAllPages() {
        return PolydexImpl.ID_TO_PAGE.values();
    }

    @Nullable
    public static PolydexEntry getItemEntryFor(class_1799 stack) {
        return PolydexImpl.getEntry(stack);
    }

    @Nullable
    public static PolydexEntry getEntry(class_2960 identifier) {
        return PolydexImpl.ITEM_ENTRIES.byId().get(identifier);
    }

    @Nullable
    public static List<PolydexPage> getPagesForCategory(PolydexCategory category) {
        return PolydexImpl.CATEGORY_TO_PAGES.getOrDefault(category, List.of());
    }

    public static boolean openCategoryUi(class_3222 player, PolydexCategory category, @Nullable Runnable closeCallback) {
        if (!PolydexPageUtils.isReady()) {
            return false;
        }
        List<PolydexPage> entry = PolydexPageUtils.getPagesForCategory(category);
        if (entry.isEmpty()) {
            return false;
        }
        ArrayList<PolydexPage> list = new ArrayList<PolydexPage>();
        for (PolydexPage polydexPage : entry) {
            if (!polydexPage.canDisplay(null, player)) continue;
            list.add(polydexPage);
        }
        if (!entry.isEmpty()) {
            PageViewerGui.openCategory(player, category, list, closeCallback);
            return true;
        }
        return false;
    }

    @Nullable
    public static PolydexPage getPageById(class_2960 identifier) {
        if (!PolydexPageUtils.isReady()) {
            return null;
        }
        return PolydexImpl.ID_TO_PAGE.get(identifier);
    }

    public static boolean openRecipeListUi(class_3222 player, class_1799 stack, @Nullable Runnable closeCallback) {
        if (!PolydexPageUtils.isReady()) {
            return false;
        }
        PolydexEntry entry = PolydexPageUtils.getItemEntryFor(stack);
        if (entry == null) {
            return false;
        }
        if (entry.getVisiblePagesSize(player) > 0) {
            PageViewerGui.openEntry(player, entry, false, closeCallback);
            return true;
        }
        return false;
    }

    public static boolean openRecipeListUi(class_3222 player, PolydexStack<?> stack, @Nullable Runnable closeCallback) {
        if (!PolydexPageUtils.isReady()) {
            return false;
        }
        PolydexEntry entry = PolydexImpl.STACK_TO_ENTRY.get(stack);
        if (entry == null) {
            return false;
        }
        if (entry.getVisiblePagesSize(player) > 0) {
            PageViewerGui.openEntry(player, entry, false, closeCallback);
            return true;
        }
        return false;
    }

    public static boolean openRecipeListUi(class_3222 player, PolydexEntry entry, @Nullable Runnable closeCallback) {
        if (!PolydexPageUtils.isReady()) {
            return false;
        }
        if (entry.getVisiblePagesSize(player) > 0) {
            PageViewerGui.openEntry(player, entry, false, closeCallback);
            return true;
        }
        return false;
    }

    public static boolean openUsagesListUi(class_3222 player, class_1799 stack, @Nullable Runnable closeCallback) {
        if (!PolydexPageUtils.isReady()) {
            return false;
        }
        PolydexEntry entry = PolydexPageUtils.getItemEntryFor(stack);
        if (entry == null) {
            return false;
        }
        if (entry.getVisibleIngredientPagesSize(player) > 0) {
            PageViewerGui.openEntry(player, entry, true, closeCallback);
            return true;
        }
        return false;
    }

    public static boolean openUsagesListUi(class_3222 player, PolydexStack<?> stack, @Nullable Runnable closeCallback) {
        if (!PolydexPageUtils.isReady()) {
            return false;
        }
        PolydexEntry entry = PolydexImpl.STACK_TO_ENTRY.get(stack);
        if (entry == null) {
            return false;
        }
        if (entry.getVisibleIngredientPagesSize(player) > 0) {
            PageViewerGui.openEntry(player, entry, true, closeCallback);
            return true;
        }
        return false;
    }

    public static boolean openUsagesListUi(class_3222 player, PolydexEntry entry, @Nullable Runnable closeCallback) {
        if (!PolydexPageUtils.isReady()) {
            return false;
        }
        if (entry.getVisibleIngredientPagesSize(player) > 0) {
            PageViewerGui.openEntry(player, entry, true, closeCallback);
            return true;
        }
        return false;
    }

    public static boolean openCustomPageUi(class_3222 player, class_2561 text, List<PolydexPage> pages, boolean useTypeIcon, @Nullable Runnable closeCallback) {
        if (!PolydexPageUtils.isReady()) {
            return false;
        }
        if (!pages.isEmpty()) {
            PageViewerGui.openCustom(player, text, pages, useTypeIcon, closeCallback);
            return true;
        }
        return false;
    }

    static {
        BEFORE_PAGE_LOADING.register(s -> ((Runnable)BEFORE_LOADING.invoker()).run());
        AFTER_PAGE_LOADING.register(s -> ((Runnable)AFTER_LOADING.invoker()).run());
    }
}

