/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polydex.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import eu.pb4.polydex.api.v1.hover.HoverDisplay;
import eu.pb4.polydex.api.v1.hover.HoverDisplayBuilder;
import eu.pb4.polydex.api.v1.hover.HoverSettings;
import eu.pb4.polydex.api.v1.recipe.PolydexCategory;
import eu.pb4.polydex.api.v1.recipe.PolydexEntry;
import eu.pb4.polydex.api.v1.recipe.PolydexPage;
import eu.pb4.polydex.api.v1.recipe.PolydexPageUtils;
import eu.pb4.polydex.impl.GenericModInfo;
import eu.pb4.polydex.impl.PolydexConfigImpl;
import eu.pb4.polydex.impl.PolydexImpl;
import eu.pb4.polydex.impl.book.ui.MainIndexGui;
import eu.pb4.polydex.impl.display.PolydexTargetImpl;
import java.util.List;
import java.util.Locale;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import net.minecraft.class_7225;

public class Commands {
    public static final DynamicCommandExceptionType INVALID_ARGUMENT = new DynamicCommandExceptionType(x -> class_2561.method_43469((String)"argument.enum.invalid", (Object[])new Object[]{x}));

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"polydex").executes(ctx -> Commands.openIndex((CommandContext<class_2168>)ctx, 0))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"hover").requires(Permissions.require((String)"polydex.display", (int)0).and(ctx -> PolydexImpl.config.displayEnabled))).then(class_2170.method_9247((String)"style").then(class_2170.method_9244((String)"style", (ArgumentType)class_2232.method_9441()).suggests((context, builder) -> class_2172.method_9270(PolydexImpl.DISPLAYS.keySet(), (SuggestionsBuilder)builder)).executes(Commands::changeStyle)))).then(class_2170.method_9247((String)"information").then(class_2170.method_9244((String)"component", (ArgumentType)class_2232.method_9441()).suggests((context, builder) -> class_2172.method_9270(HoverDisplayBuilder.ComponentType.getAllIds(), (SuggestionsBuilder)builder)).then(Commands.enumArgument((String)"show", (Enum[])HoverDisplayBuilder.ComponentType.Visibility.values()).executes(Commands::setComponent))))).then(class_2170.method_9247((String)"displaymode").then(Commands.enumArgument((String)"type", (Enum[])HoverSettings.DisplayMode.values()).executes(Commands::setDisplayMode))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"page").requires(Permissions.require((String)"polydex.page", (int)0))).then(class_2170.method_9244((String)"number", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> Commands.openIndex((CommandContext<class_2168>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"number") - 1))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"open_page").requires(Permissions.require((String)"polydex.open_page", (int)0))).then(class_2170.method_9244((String)"page", (ArgumentType)class_2232.method_9441()).suggests((context, builder) -> {
            for (class_2960 id : PolydexImpl.ID_TO_PAGE.keySet()) {
                if (!id.toString().startsWith(builder.getRemaining()) && !id.method_12832().startsWith(builder.getRemaining())) continue;
                builder.suggest(id.toString());
            }
            return builder.buildFuture();
        }).executes(Commands::openPage)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"entry_usage").requires(Permissions.require((String)"polydex.open_entry", (int)0))).then(class_2170.method_9244((String)"entry", (ArgumentType)class_2232.method_9441()).suggests((context, builder) -> {
            for (class_2960 id : PolydexImpl.ITEM_ENTRIES.nonEmptyById().keySet()) {
                if (!id.toString().startsWith(builder.getRemaining()) && !id.method_12832().startsWith(builder.getRemaining())) continue;
                builder.suggest(id.toString());
            }
            return builder.buildFuture();
        }).executes(Commands::openEntryUsages)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"entry_result").requires(Permissions.require((String)"polydex.open_entry", (int)0))).then(class_2170.method_9244((String)"entry", (ArgumentType)class_2232.method_9441()).suggests((context, builder) -> {
            for (class_2960 id : PolydexImpl.ITEM_ENTRIES.nonEmptyById().keySet()) {
                if (!id.toString().startsWith(builder.getRemaining()) && !id.method_12832().startsWith(builder.getRemaining())) continue;
                builder.suggest(id.toString());
            }
            return builder.buildFuture();
        }).executes(Commands::openEntryResult)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"category").requires(Permissions.require((String)"polydex.category", (int)0))).then(class_2170.method_9244((String)"category", (ArgumentType)class_2232.method_9441()).suggests((context, builder) -> {
            for (class_2960 id : PolydexImpl.CATEGORY_BY_ID.keySet()) {
                if (!id.toString().startsWith(builder.getRemaining()) && !id.method_12832().startsWith(builder.getRemaining())) continue;
                builder.suggest(id.toString());
            }
            return builder.buildFuture();
        }).executes(Commands::openCategory)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(Permissions.require((String)"polydex.reload", (int)3))).executes(Commands::reload))).then(class_2170.method_9247((String)"about").executes(Commands::about)));
    }

    private static <T extends ArgumentBuilder<class_2168, T>, G extends Enum<G>> T enumArgument(String name, G[] values) {
        return (T)class_2170.method_9244((String)name, (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            String string = builder.getRemaining().toLowerCase(Locale.ROOT);
            for (Enum value : values) {
                if (!value.name().toLowerCase(Locale.ROOT).startsWith(string)) continue;
                builder.suggest(value.name().toLowerCase(Locale.ROOT));
            }
            return builder.buildFuture();
        });
    }

    private static <T extends Enum<T>> T getEnum(CommandContext<?> context, String name, Class<T> tClass) throws CommandSyntaxException {
        String obj = StringArgumentType.getString(context, (String)name);
        try {
            return Enum.valueOf(tClass, obj.toUpperCase(Locale.ROOT));
        }
        catch (Throwable e) {
            throw INVALID_ARGUMENT.create((Object)obj);
        }
    }

    private static int openCategory(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2960 id = class_2232.method_9443(context, (String)"category");
        PolydexCategory category = PolydexImpl.CATEGORY_BY_ID.get(id);
        if (category != null) {
            PolydexPageUtils.openCategoryUi(((class_2168)context.getSource()).method_9207(), category, null);
        }
        return 0;
    }

    private static int openPage(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2960 id = class_2232.method_9443(context, (String)"page");
        PolydexPage page = PolydexImpl.ID_TO_PAGE.get(id);
        if (page != null) {
            PolydexPageUtils.openCustomPageUi(((class_2168)context.getSource()).method_9207(), (class_2561)class_2561.method_43471((String)"text.polydex.recipes_title_custom"), List.of(page), true, null);
        }
        return 1;
    }

    private static int openEntryResult(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2960 id = class_2232.method_9443(context, (String)"entry");
        PolydexEntry entry = PolydexImpl.ITEM_ENTRIES.nonEmptyById().get(id);
        if (entry != null) {
            PolydexPageUtils.openRecipeListUi(((class_2168)context.getSource()).method_9207(), entry, null);
        }
        return 1;
    }

    private static int openEntryUsages(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2960 id = class_2232.method_9443(context, (String)"entry");
        PolydexEntry entry = PolydexImpl.ITEM_ENTRIES.nonEmptyById().get(id);
        if (entry != null) {
            PolydexPageUtils.openUsagesListUi(((class_2168)context.getSource()).method_9207(), entry, null);
        }
        return 1;
    }

    private static int reload(CommandContext<class_2168> context) {
        PolydexImpl.config = PolydexConfigImpl.loadOrCreateConfig((class_7225.class_7874)((class_2168)context.getSource()).method_30497());
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"text.polydex.config_reloaded"), false);
        return 1;
    }

    private static int openIndex(CommandContext<class_2168> context, int page) throws CommandSyntaxException {
        try {
            new MainIndexGui(((class_2168)context.getSource()).method_44023(), true, page, 0).open();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
        return 1;
    }

    private static int about(CommandContext<class_2168> context) {
        for (class_2561 text : ((class_2168)context.getSource()).method_9228() instanceof class_3222 ? GenericModInfo.getAboutFull() : GenericModInfo.getAboutConsole()) {
            ((class_2168)context.getSource()).method_9226(() -> text, false);
        }
        return 1;
    }

    private static int changeStyle(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2960 id = class_2232.method_9443(context, (String)"style");
        if (PolydexImpl.DISPLAYS.containsKey(id)) {
            HoverDisplay.set(((class_2168)context.getSource()).method_44023(), id);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"text.polydex.changed_style", (Object[])new Object[]{id.toString()}), false);
            return 1;
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"text.polydex.invalid_style", (Object[])new Object[]{id.toString()}).method_27692(class_124.field_1061), false);
        return 0;
    }

    private static int setComponent(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2960 id = class_2232.method_9443(context, (String)"component");
        HoverDisplayBuilder.ComponentType.Visibility value = Commands.getEnum(context, "show", HoverDisplayBuilder.ComponentType.Visibility.class);
        if (HoverDisplayBuilder.ComponentType.getAllIds().contains(id)) {
            PolydexTargetImpl.get(((class_2168)context.getSource()).method_9207()).settings().setComponentVisible(id, value);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"text.polydex.changed_component_visibility", (Object[])new Object[]{id.toString(), value.name().toLowerCase(Locale.ROOT)}), false);
            return 1;
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"text.polydex.invalid_component_type", (Object[])new Object[]{id.toString()}).method_27692(class_124.field_1061), false);
        return 0;
    }

    private static int setDisplayMode(CommandContext<class_2168> context) throws CommandSyntaxException {
        HoverSettings.DisplayMode value = Commands.getEnum(context, "type", HoverSettings.DisplayMode.class);
        PolydexTargetImpl.get(((class_2168)context.getSource()).method_9207()).settings().setDisplayMode(value);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"text.polydex.changed_display_mode", (Object[])new Object[]{value.name().toLowerCase(Locale.ROOT)}), false);
        return 1;
    }
}

