/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polydex.impl.book.ui;

import eu.pb4.polydex.impl.book.ui.GuiUtils;
import eu.pb4.polydex.impl.book.ui.PageAware;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.layered.Layer;
import net.minecraft.class_3222;

public abstract class PagedLayer
extends Layer
implements PageAware {
    public final int pageSize;
    public final class_3222 player;
    private final boolean withNavigation;
    protected int page = 0;

    public PagedLayer(class_3222 player, int height, int width, boolean withNavigation) {
        super(height, width);
        this.withNavigation = withNavigation;
        this.player = player;
        this.pageSize = this.withNavigation ? (height - 1) * width : height * width;
    }

    protected abstract int getEntryCount();

    @Override
    public int getPageAmount() {
        return (this.getEntryCount() - 1) / this.pageSize + 1;
    }

    protected void updateDisplay() {
        int i;
        int offset = this.page * this.pageSize;
        for (i = 0; i < this.pageSize; ++i) {
            GuiElementInterface element = this.getElement(offset + i);
            if (element == null) {
                element = GuiElement.EMPTY;
            }
            this.setSlot(i, element);
        }
        for (i = 0; i < this.width; ++i) {
            GuiElementInterface navElement = this.getNavElement(i);
            if (navElement == null) {
                navElement = GuiElement.EMPTY;
            }
            this.setSlot(i + this.pageSize, navElement);
        }
    }

    private GuiElement filler() {
        return PolymerResourcePackUtils.hasMainPack((class_3222)this.player) ? GuiElement.EMPTY : GuiUtils.FILLER;
    }

    @Override
    public int getPage() {
        return this.page;
    }

    @Override
    public void setPage(int page) {
        this.page = page % Math.max(this.getPageAmount(), 1);
        this.updateDisplay();
    }

    protected abstract GuiElementInterface getElement(int var1);

    protected GuiElementInterface getNavElement(int id) {
        return switch (id) {
            case 3 -> {
                if (this.getPageAmount() > 1) {
                    yield GuiUtils.previousPage(this.player, this);
                }
                yield this.filler();
            }
            case 4 -> {
                if (this.getPageAmount() > 1) {
                    yield GuiUtils.page(this.player, this.page + 1, this.getPageAmount()).build();
                }
                yield this.filler();
            }
            case 5 -> {
                if (this.getPageAmount() > 1) {
                    yield GuiUtils.nextPage(this.player, this);
                }
                yield this.filler();
            }
            default -> this.filler();
        };
    }
}

