/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polydex.mixin;

import eu.pb4.playerdata.api.PlayerDataApi;
import eu.pb4.polydex.api.v1.hover.HoverDisplay;
import eu.pb4.polydex.api.v1.hover.PolydexTarget;
import eu.pb4.polydex.impl.PlayerInterface;
import eu.pb4.polydex.impl.PolydexImpl;
import eu.pb4.polydex.impl.display.BossbarTargetDisplay;
import eu.pb4.polydex.impl.display.NoopTargetDisplay;
import eu.pb4.polydex.impl.display.PolydexTargetImpl;
import eu.pb4.predicate.api.PredicateContext;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2535;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_4614;
import net.minecraft.class_8609;
import net.minecraft.class_8792;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3244.class})
public abstract class ServerPlayNetworkHandlerMixin
extends class_8609
implements PlayerInterface {
    @Shadow
    public class_3222 field_14140;
    @Unique
    private HoverDisplay polydex_display;
    @Unique
    private PolydexTargetImpl polydex_target;
    @Unique
    private class_3222 polydex_oldPlayer;
    @Unique
    private int polydex_tick = 0;
    @Unique
    private final List<class_2960> polydex$lastViewed = new ArrayList<class_2960>();
    @Unique
    private boolean polydex_globalEnabled = true;

    public ServerPlayNetworkHandlerMixin(MinecraftServer server, class_2535 connection, class_8792 clientData) {
        super(server, connection, clientData);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void polydex_create(MinecraftServer server, class_2535 connection, class_3222 player, class_8792 clientData, CallbackInfo ci) {
        if (this.getClass() == class_3244.class) {
            this.polydex_target = new PolydexTargetImpl((class_3244)this);
            Function<PolydexTarget, HoverDisplay> creator = PolydexImpl.DISPLAYS.get(this.polydex_target.settings().currentType());
            this.polydex_display = creator != null ? creator.apply(this.polydex_target) : new BossbarTargetDisplay(this.polydex_target);
        } else {
            this.polydex_display = NoopTargetDisplay.INSTANCE;
        }
        class_2499 list = (class_2499)PlayerDataApi.getGlobalDataFor((class_3222)player, (class_2960)PolydexImpl.id("last_viewed"), (class_4614)class_2499.field_21039);
        if (list != null) {
            for (class_2520 x : list) {
                class_2960 y = class_2960.method_12829((String)x.method_10714());
                this.polydex$lastViewed.add(y);
            }
        }
    }

    @Inject(method={"cleanUp"}, at={@At(value="HEAD")})
    private void saveList(CallbackInfo ci) {
        try {
            class_2499 list = new class_2499();
            for (class_2960 x : this.polydex$lastViewed) {
                list.add((Object)class_2519.method_23256((String)x.toString()));
            }
            PlayerDataApi.setGlobalDataFor((class_3222)this.field_14140, (class_2960)PolydexImpl.id("last_viewed"), (class_2520)list);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void polydex_tick(CallbackInfo ci) {
        boolean value;
        if (this.polydex_display == NoopTargetDisplay.INSTANCE) {
            return;
        }
        if (this.field_14140.field_6012 % 32 == 0 && this.polydex_globalEnabled != (value = PolydexImpl.config.displayPredicate.test(PredicateContext.of((class_3222)this.field_14140)).success())) {
            this.polydex_globalEnabled = value;
            if (!value && !this.polydex_display.isHidden()) {
                this.polydex_display.hideDisplay();
            }
            return;
        }
        if (!this.polydex_globalEnabled) {
            return;
        }
        if (this.field_14140 != this.polydex_oldPlayer) {
            this.polydex_oldPlayer = this.field_14140;
            this.polydex_update();
            return;
        }
        if (this.polydex_tick == PolydexImpl.config.displayUpdateRate) {
            this.polydex_tick = 0;
            this.polydex_update();
        }
        ++this.polydex_tick;
    }

    private void polydex_update() {
        this.polydex_target.updateRaycast();
        if (this.polydex_display.isHidden() && this.polydex_target.hasTarget()) {
            this.polydex_display.showDisplay();
        } else if (!this.polydex_display.isHidden()) {
            if (!this.polydex_target.hasTarget()) {
                this.polydex_display.hideDisplay();
            } else {
                this.polydex_display.onTargetUpdate();
            }
        }
    }

    @Override
    public PolydexTargetImpl polydex_getTarget() {
        return this.polydex_target;
    }

    @Override
    public HoverDisplay polydex_getDisplay() {
        return this.polydex_display;
    }

    @Override
    public List<class_2960> polydex_lastViewed() {
        return this.polydex$lastViewed;
    }

    @Override
    public void polydex_setDisplay(class_2960 identifier, Function<PolydexTarget, HoverDisplay> displayCreator) {
        this.polydex_display.remove();
        this.polydex_display = displayCreator.apply(this.polydex_target);
        this.polydex_target.settings().setDisplay(identifier);
    }
}

