/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.creeperoverhaul.common.entity.base;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1320;
import net.minecraft.class_1324;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1548;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_5147;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationProcessor;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import tech.thatgravyboat.creeperoverhaul.api.PluginRegistry;
import tech.thatgravyboat.creeperoverhaul.common.entity.base.CreeperType;
import tech.thatgravyboat.creeperoverhaul.common.entity.base.NeutralCreeper;
import tech.thatgravyboat.creeperoverhaul.common.entity.base.PassiveCreeper;
import tech.thatgravyboat.creeperoverhaul.common.entity.goals.CreeperAvoidEntitiesGoal;
import tech.thatgravyboat.creeperoverhaul.common.entity.goals.CreeperMeleeAttackGoal;
import tech.thatgravyboat.creeperoverhaul.common.entity.goals.CreeperSwellGoal;
import tech.thatgravyboat.creeperoverhaul.common.utils.AnimationConstants;
import tech.thatgravyboat.creeperoverhaul.common.utils.PlatformUtils;

public class BaseCreeper
extends class_1548
implements GeoEntity,
class_5147 {
    private static final class_2940<Boolean> DATA_IS_ATTACKING = class_2945.method_12791(BaseCreeper.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DATA_IS_SHEARED = class_2945.method_12791(BaseCreeper.class, (class_2941)class_2943.field_13323);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int oldSwell;
    private int swell;
    private int maxSwell = 30;
    public final CreeperType type;

    public BaseCreeper(class_1299<? extends class_1548> entityType, class_1937 level, CreeperType type) {
        super(entityType, level);
        this.type = type;
        if (!level.field_9236) {
            this.type.entities().forEach(e -> this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, e, true)));
        }
    }

    public static class_1299.class_4049<BaseCreeper> of(CreeperType type) {
        return (entityType, level) -> new BaseCreeper((class_1299<? extends class_1548>)entityType, level, type);
    }

    public static class_1299.class_4049<PassiveCreeper> ofPassive(CreeperType type) {
        return (entityType, level) -> new PassiveCreeper((class_1299<? extends NeutralCreeper>)entityType, level, type);
    }

    public static class_1299.class_4049<NeutralCreeper> ofNeutral(CreeperType type) {
        return (entityType, level) -> new NeutralCreeper((class_1299<? extends NeutralCreeper>)entityType, level, type);
    }

    protected void method_5959() {
        this.field_6201.method_6277(2, (class_1352)new CreeperSwellGoal(this));
        this.field_6201.method_6277(3, (class_1352)new CreeperAvoidEntitiesGoal(this, 6.0f, 1.0, 1.2));
        this.registerMovementGoals();
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(6, (class_1352)new class_1376((class_1308)this));
        this.registerAttackGoals();
        if (this.shouldRevenge()) {
            this.field_6185.method_6277(2, (class_1352)new class_1399((class_1314)this, new Class[0]));
        }
    }

    protected void registerAttackGoals() {
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, true, entity -> PluginRegistry.getInstance().canAttack(this, (class_1309)entity)));
        this.field_6201.method_6277(4, (class_1352)new CreeperMeleeAttackGoal(this, 1.0, false));
    }

    protected void registerMovementGoals() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(5, (class_1352)new class_1394((class_1314)this, 0.8));
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(DATA_IS_ATTACKING, (Object)false);
        builder.method_56912(DATA_IS_SHEARED, (Object)false);
    }

    public boolean isAttacking() {
        return (Boolean)this.method_5841().method_12789(DATA_IS_ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.method_5841().method_12778(DATA_IS_ATTACKING, (Object)attacking);
    }

    public boolean isSheared() {
        return (Boolean)this.field_6011.method_12789(DATA_IS_SHEARED);
    }

    public void setSheared(boolean sheared) {
        this.method_5841().method_12778(DATA_IS_SHEARED, (Object)sheared);
    }

    public void method_5652(@NotNull class_2487 tag) {
        super.method_5652(tag);
        tag.method_10556("Sheared", this.isSheared());
        tag.method_10575("Fuse", (short)this.maxSwell);
    }

    public void method_5749(@NotNull class_2487 tag) {
        super.method_5749(tag);
        this.setSheared(tag.method_10577("Sheared"));
        if (tag.method_10573("Fuse", 99)) {
            this.maxSwell = tag.method_10568("Fuse");
        }
    }

    public boolean method_5747(float f, float g, @NotNull class_1282 source) {
        boolean bl = super.method_5747(f, g, source);
        this.swell += (int)(f * 1.5f);
        if (this.swell > this.maxSwell - 5) {
            this.swell = this.maxSwell - 5;
        }
        return bl;
    }

    public void method_5773() {
        if (this.method_5805()) {
            int i;
            this.oldSwell = this.swell;
            if (this.method_7000()) {
                this.method_7005(1);
            }
            if ((i = this.method_7007()) > 0 && this.swell == 0) {
                this.method_5783(this.type.getPrimeSound(this).orElse(class_3417.field_15057), 1.0f, 0.5f);
                this.method_32876((class_6880)class_5712.field_28727);
            }
            this.swell += i;
            if (this.swell < 0) {
                this.swell = 0;
            }
            if (this.swell >= this.maxSwell) {
                this.swell = this.maxSwell;
                this.explode();
            }
        }
        super.method_5773();
    }

    public void explode() {
        if (!this.method_37908().field_9236) {
            class_1937.class_7867 interaction = PlatformUtils.getInteractionForCreeper(this);
            this.field_6272 = true;
            class_1927 explosion = this.method_37908().method_8437((class_1297)this, this.method_23317(), this.method_23318(), this.method_23321(), 3.0f * (this.method_6872() ? 2.0f : 1.0f), interaction);
            this.type.getExplosionSound(this).ifPresent(s -> this.method_37908().method_43129(null, (class_1297)this, s, class_3419.field_15245, 4.0f, (1.0f + (this.method_37908().field_9229.method_43057() - this.method_37908().field_9229.method_43057()) * 0.2f) * 0.7f));
            this.method_31472();
            if (!this.type.inflictingPotions().isEmpty()) {
                explosion.method_8351().keySet().forEach(player -> {
                    List<class_1293> inflictingPotions = this.type.inflictingPotions().stream().map(class_1293::new).toList();
                    inflictingPotions.forEach(arg_0 -> ((class_1657)player).method_6092(arg_0));
                });
            }
            if (!this.type.replacer().isEmpty()) {
                Set<Map.Entry<Predicate<class_2680>, Function<class_5819, class_2680>>> entries = this.type.replacer().entrySet();
                explosion.method_8346().stream().map(class_2338::method_10074).forEach(pos -> {
                    class_2680 state = this.method_37908().method_8320(pos);
                    for (Map.Entry entry : entries) {
                        class_2680 newState;
                        if (!((Predicate)entry.getKey()).test(state) || (newState = (class_2680)((Function)entry.getValue()).apply(this.field_5974)) == null) continue;
                        this.method_37908().method_8652(pos, newState, 3);
                        break;
                    }
                });
            }
            Stream<class_1293> potions = Stream.concat(this.method_6026().stream().map(class_1293::new), this.type.potionsWhenDead().stream().map(class_1293::new));
            this.summonCloudWithEffects(potions.toList());
        }
    }

    private void summonCloudWithEffects(Collection<class_1293> effects) {
        if (!effects.isEmpty()) {
            class_1295 cloud = new class_1295(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321());
            cloud.method_5603(2.5f);
            cloud.method_5609(-0.5f);
            cloud.method_5595(10);
            cloud.method_5604(cloud.method_5605() / 2);
            cloud.method_5596(-cloud.method_5599() / (float)cloud.method_5605());
            effects.forEach(arg_0 -> ((class_1295)cloud).method_5610(arg_0));
            this.method_37908().method_8649((class_1297)cloud);
        }
    }

    public float method_7003(float f) {
        return class_3532.method_16439((float)f, (float)this.oldSwell, (float)this.swell) / ((float)this.maxSwell - 2.0f);
    }

    public boolean canSwell() {
        return this.isExplodingCreeper();
    }

    public boolean isExplodingCreeper() {
        return this.type.melee() == 0;
    }

    @NotNull
    protected class_1269 method_5992(@NotNull class_1657 player, @NotNull class_1268 hand) {
        class_1304 slot;
        class_1799 stack = player.method_5998(hand);
        class_1304 class_13042 = slot = hand == class_1268.field_5808 ? class_1304.field_6173 : class_1304.field_6171;
        if (this.isExplodingCreeper() && PlatformUtils.isFlintAndSteel(stack)) {
            this.method_37908().method_8396(player, this.method_24515(), class_3417.field_15145, this.method_5634(), 1.0f, this.field_5974.method_43057() * 0.4f + 0.8f);
            if (!this.method_37908().method_8608()) {
                this.method_7004();
                stack.method_7970(1, (class_1309)player, slot);
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        if (this.method_27072() && PlatformUtils.isShears(stack)) {
            this.method_6636(class_3419.field_15256);
            this.method_32875((class_6880)class_5712.field_28730, (class_1297)player);
            stack.method_7970(1, (class_1309)player, slot);
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        return class_1269.field_5811;
    }

    public boolean shouldRevenge() {
        return true;
    }

    public double method_45325(class_6880<class_1320> attribute) {
        return super.method_45325(attribute) * (double)(attribute.equals((Object)class_5134.field_23721) && this.method_6872() ? 2 : 1);
    }

    public boolean method_6121(@NotNull class_1297 entity) {
        if (this.canSwell()) {
            return true;
        }
        class_1282 damageSource = this.method_37908().method_48963().method_48812((class_1309)this);
        float damage = (float)this.method_45325((class_6880<class_1320>)class_5134.field_23721);
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            damage = class_1890.method_60120((class_3218)serverLevel, (class_1799)this.method_59958(), (class_1297)entity, (class_1282)damageSource, (float)damage);
        }
        if (entity.method_5643(damageSource, damage)) {
            class_1937 class_19373;
            float knockback = this.method_59924(entity, damageSource);
            if ((double)knockback > 0.0 && entity instanceof class_1309) {
                class_1309 living = (class_1309)entity;
                living.method_6005((double)(knockback * 0.5f), (double)class_3532.method_15374((float)(this.method_36454() * ((float)Math.PI / 180))), (double)(-class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180)))));
                this.method_18799(this.method_18798().method_18805(0.6, 1.0, 0.6));
            }
            if ((class_19373 = this.method_37908()) instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19373;
                class_1890.method_60107((class_3218)serverLevel, (class_1297)entity, (class_1282)damageSource);
            }
            this.method_6114(entity);
            return true;
        }
        return false;
    }

    public float method_6029() {
        return super.method_6029() * (this.method_6872() ? 1.5f : 1.0f);
    }

    public boolean method_6061(@NotNull class_1282 source) {
        return super.method_6061(source) || this.type.immunities().contains(source);
    }

    @NotNull
    protected class_238 method_53511() {
        class_1324 reachAttribute = this.method_5996(class_5134.field_47759);
        double reach = reachAttribute != null ? reachAttribute.method_6194() : 0.0;
        return super.method_53511().method_1009(reach, 0.0, reach);
    }

    protected class_3414 method_6011(@NotNull class_1282 source) {
        return this.type.getHurtSound(this).orElseGet(() -> super.method_6011(source));
    }

    protected class_3414 method_6002() {
        return this.type.getDeathSound(this).orElseGet(() -> super.method_6002());
    }

    @NotNull
    protected class_3414 method_5737() {
        return this.type.getSwimSound(this).orElseGet(() -> super.method_5737());
    }

    protected <E extends GeoAnimatable> PlayState idle(AnimationState<E> event) {
        event.getController().setAnimation(AnimationConstants.IDLE);
        return PlayState.CONTINUE;
    }

    protected <E extends GeoAnimatable> PlayState action(AnimationState<E> event) {
        AnimationProcessor.QueuedAnimation animation = event.getController().getCurrentAnimation();
        if (this.isAttacking()) {
            event.getController().setAnimation(AnimationConstants.ATTACK);
            return PlayState.CONTINUE;
        }
        if (animation != null && animation.animation().name().equals("animation.creeper.attack") && event.getController().getAnimationState().equals((Object)AnimationController.State.RUNNING)) {
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            event.getController().setAnimation(AnimationConstants.WALK);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "action_controller", 3, this::action));
        controllers.add(new AnimationController((GeoAnimatable)this, "idle_controller", 0, this::idle));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void method_6636(class_3419 soundSource) {
        this.method_37908().method_43129(null, (class_1297)this, class_3417.field_22273, soundSource, 1.0f, 1.0f);
        if (!this.method_37908().method_8608()) {
            this.method_5699(this.type.shearDrop().get(), 1.7f);
        }
    }

    public boolean method_27072() {
        return !this.isSheared() && this.type.isShearable();
    }
}

