/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.creeperoverhaul.common.entity.custom;

import java.util.List;
import net.minecraft.class_1266;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1400;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3417;
import net.minecraft.class_3483;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4051;
import net.minecraft.class_5425;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.thatgravyboat.creeperoverhaul.api.PluginRegistry;
import tech.thatgravyboat.creeperoverhaul.common.entity.base.CreeperType;
import tech.thatgravyboat.creeperoverhaul.common.entity.base.WaterCreeper;
import tech.thatgravyboat.creeperoverhaul.common.entity.goals.CreeperMeleeAttackGoal;
import tech.thatgravyboat.creeperoverhaul.common.registry.ModSounds;

public class PufferfishCreeper
extends WaterCreeper {
    private static final class_4051 TARGETS = class_4051.method_36626().method_18424().method_36627().method_18420(entity -> !entity.method_5864().method_20210(class_3483.field_48283) && class_1301.field_6156.test(entity) && entity.method_5805());
    private static final List<class_4048> DIMENSIONS = List.of(class_4048.method_18384((float)0.6875f, (float)1.125f), class_4048.method_18384((float)0.625f, (float)0.9375f), class_4048.method_18384((float)1.0f, (float)1.375f));
    private static final class_2940<Byte> VARIANT = class_2945.method_12791(PufferfishCreeper.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Byte> PUFF_STATE = class_2945.method_12791(PufferfishCreeper.class, (class_2941)class_2943.field_13319);
    private int inflateCounter;
    private int deflateTimer;

    public PufferfishCreeper(class_1299<? extends PufferfishCreeper> entityType, class_1937 level, CreeperType type) {
        super(entityType, level, type);
    }

    public static class_1299.class_4049<PufferfishCreeper> ofPufferfish(CreeperType type) {
        return (entityType, level) -> new PufferfishCreeper((class_1299<? extends PufferfishCreeper>)entityType, level, type);
    }

    @Nullable
    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 type, @Nullable class_1315 data) {
        this.setVariant(level.method_8409().method_43056() ? Variant.TEAL : Variant.BROWN);
        return super.method_5943(level, difficulty, type, data);
    }

    @Override
    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(1, (class_1352)new PuffGoal(this));
    }

    @Override
    protected void registerAttackGoals() {
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, true, entity -> PluginRegistry.getInstance().canAttack(this, (class_1309)entity)));
        this.field_6201.method_6277(4, (class_1352)new CreeperMeleeAttackGoal(this, 3.0, false));
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(VARIANT, (Object)0);
        builder.method_56912(PUFF_STATE, (Object)0);
    }

    public void method_5674(@NotNull class_2940<?> accessor) {
        super.method_5674(accessor);
        if (VARIANT.equals(accessor)) {
            this.method_18382();
        }
    }

    @Override
    public void method_5749(@NotNull class_2487 tag) {
        super.method_5749(tag);
        this.field_6011.method_12778(VARIANT, (Object)(tag.method_10571("Variant") == 0 ? (byte)0 : 1));
    }

    @Override
    public void method_5652(@NotNull class_2487 tag) {
        super.method_5652(tag);
        tag.method_10567("Variant", ((Byte)this.field_6011.method_12789(VARIANT)).byteValue());
    }

    public byte getPuffState() {
        return (Byte)this.field_6011.method_12789(PUFF_STATE);
    }

    public void setPuffState(int puffState) {
        this.field_6011.method_12778(PUFF_STATE, (Object)((byte)puffState));
    }

    public Variant getVariant() {
        return Variant.byId((Byte)this.field_6011.method_12789(VARIANT));
    }

    public void setVariant(Variant variant) {
        this.field_6011.method_12778(VARIANT, (Object)((byte)variant.ordinal()));
    }

    public int getPuffId() {
        return switch (this.getPuffState()) {
            case 0 -> 1;
            case 1 -> 2;
            default -> 3;
        };
    }

    @Override
    public void method_5773() {
        if (!this.method_37908().field_9236 && this.method_5805() && this.method_6034()) {
            if (this.inflateCounter > 0) {
                if (this.getPuffState() == 0) {
                    this.method_5783(ModSounds.OCEAN_INFLATE.get(), this.method_6107(), this.method_6017());
                    this.setPuffState(1);
                } else if (this.inflateCounter > 40 && this.getPuffState() == 1) {
                    this.method_5783(ModSounds.OCEAN_INFLATE.get(), this.method_6107(), this.method_6017());
                    this.setPuffState(2);
                }
                ++this.inflateCounter;
            } else if (this.getPuffState() != 0) {
                if (this.deflateTimer > 60 && this.getPuffState() == 2) {
                    this.method_5783(ModSounds.OCEAN_DEFLATE.get(), this.method_6107(), this.method_6017());
                    this.setPuffState(1);
                } else if (this.deflateTimer > 100 && this.getPuffState() == 1) {
                    this.method_5783(ModSounds.OCEAN_DEFLATE.get(), this.method_6107(), this.method_6017());
                    this.setPuffState(0);
                }
                ++this.deflateTimer;
            }
        }
        super.method_5773();
    }

    @Override
    public boolean method_6121(@NotNull class_1297 entity) {
        byte state = this.getPuffState();
        if (entity.method_5643(this.method_37908().method_48963().method_48812((class_1309)this), (6.0f + (float)state) * (this.method_6872() ? 2.0f : 1.0f))) {
            this.method_5783(class_3417.field_14848, 1.0f, 1.0f);
            if (entity instanceof class_1309) {
                class_1309 living = (class_1309)entity;
                living.method_6092(new class_1293(class_1294.field_5899, 60 * state, 0));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canSwell() {
        return false;
    }

    private boolean canTouch(class_1309 entity) {
        return TARGETS.method_18419((class_1309)this, entity);
    }

    @NotNull
    public class_4048 method_55694(@NotNull class_4050 pose) {
        return DIMENSIONS.get(this.getPuffId() - 1);
    }

    public static enum Variant {
        TEAL,
        BROWN;


        public static Variant byId(byte id) {
            return id == 0 ? TEAL : BROWN;
        }
    }

    public static class PuffGoal
    extends class_1352 {
        private final PufferfishCreeper creeper;

        public PuffGoal(PufferfishCreeper creeper) {
            this.creeper = creeper;
        }

        public boolean method_6264() {
            List list = this.creeper.method_37908().method_8390(class_1657.class, this.creeper.method_5829().method_1014(6.0), this.creeper::canTouch);
            return !list.isEmpty();
        }

        public void method_6269() {
            this.creeper.inflateCounter = 1;
            this.creeper.deflateTimer = 0;
        }

        public void method_6270() {
            this.creeper.inflateCounter = 0;
        }
    }
}

