/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.client.gui.overlays;

import com.li64.tide.Tide;
import com.li64.tide.network.messages.MinigameServerMsg;
import com.li64.tide.registries.entities.misc.fishing.HookAccessor;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_9779;

public class CatchMinigameOverlay {
    private static final class_2960 BAR_BG_TEX = Tide.resource("textures/gui/fishing/catch_bar_bg.png");
    private static final class_2960 MARKER_TEX = Tide.resource("textures/gui/fishing/catch_marker.png");
    private static final class_2960 SELECT_TEX = Tide.resource("textures/gui/fishing/catch_marker_select.png");
    private static float timeLeft = 80.0f;
    private static float animProgress = 0.0f;
    private static float timer = 20.0f;
    private static boolean active = false;
    private static class_5250 accuracyText = null;
    private static class_124 textColor = class_124.field_1068;
    private static float fishStrength;
    private static final float DEFAULT_SPEED = 0.12f;

    public static void start(float strength) {
        if (active) {
            return;
        }
        fishStrength = strength;
        accuracyText = null;
        animProgress = new Random().nextFloat() * 100.0f;
        timeLeft = 0.0f;
        timer = 0.0f;
        active = true;
    }

    public static void interact() {
        if (!active) {
            return;
        }
        float accuracy = Math.abs(class_3532.method_15374((float)(animProgress * CatchMinigameOverlay.getSpeed())));
        String accuracyKey = "minigame.rating.trash";
        float catchChance = 0.0f;
        textColor = class_124.field_1074;
        if (accuracy < 0.05f) {
            accuracyKey = "minigame.rating.perfect";
            catchChance = 1.0f;
            textColor = class_124.field_1065;
        } else if (accuracy < 0.15f) {
            accuracyKey = "minigame.rating.great";
            catchChance = 1.0f;
            textColor = class_124.field_1060;
        } else if (accuracy < 0.3f) {
            accuracyKey = "minigame.rating.good";
            catchChance = 0.95f;
            textColor = class_124.field_1077;
        } else if (accuracy < 0.45f) {
            accuracyKey = "minigame.rating.ok";
            catchChance = 0.5f;
            textColor = class_124.field_1054;
        } else if (accuracy < 0.6f) {
            accuracyKey = "minigame.rating.bad";
            catchChance = 0.4f;
            textColor = class_124.field_1061;
        } else if (accuracy < 0.78f) {
            accuracyKey = "minigame.rating.terrible";
            catchChance = 0.1f;
            textColor = class_124.field_1079;
        }
        accuracyText = class_2561.method_43471((String)accuracyKey);
        Random random = new Random();
        if (random.nextFloat() < catchChance) {
            Tide.NETWORK.sendToServer(new MinigameServerMsg(2));
        } else {
            Tide.NETWORK.sendToServer(new MinigameServerMsg(1));
        }
        CatchMinigameOverlay.close();
    }

    public static void close() {
        active = false;
        timer = 0.0f;
    }

    public static float getSpeed() {
        return (fishStrength * 0.048f + 0.12f) * (float)Tide.CONFIG.general.minigameDifficulty;
    }

    public static void render(class_332 graphics, class_9779 deltaTracker) {
        float delta = deltaTracker.method_60638();
        if (timer >= 20.0f) {
            return;
        }
        if (!active) {
            timer += delta;
        } else {
            animProgress += delta;
            if ((timeLeft += delta) >= 80.0f || HookAccessor.bobberRemoved((class_1657)class_310.method_1551().field_1724)) {
                Tide.LOG.debug("Timeout!");
                CatchMinigameOverlay.close();
                Tide.NETWORK.sendToServer(new MinigameServerMsg(0));
            }
        }
        float alpha = -class_3532.method_15363((float)((timer - 10.0f) / 10.0f), (float)0.0f, (float)1.0f) + 1.0f;
        int texWidth = 32;
        int texHeight = 16;
        int x = (graphics.method_51421() - texWidth) / 2;
        int y = graphics.method_51443() / 2 - texHeight - 6;
        int markerX = (int)((float)x + class_3532.method_15374((float)(animProgress * CatchMinigameOverlay.getSpeed())) * ((float)texWidth / 2.0f - 2.0f));
        RenderSystem.enableBlend();
        graphics.method_51422(1.0f, 1.0f, 1.0f, alpha);
        graphics.method_25290(BAR_BG_TEX, x, y, 0.0f, 0.0f, texWidth, texHeight, texWidth, texHeight);
        graphics.method_25290(MARKER_TEX, markerX, y, 0.0f, 0.0f, texWidth, texHeight, texWidth, texHeight);
        if (accuracyText == null) {
            return;
        }
        class_327 font = class_310.method_1551().field_1772;
        graphics.method_51439(font, (class_2561)accuracyText.method_27696(accuracyText.method_10866().method_10977(textColor)), (graphics.method_51421() - font.method_27525((class_5348)accuracyText)) / 2, y - 10, 0, false);
        RenderSystem.disableBlend();
        graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }
}

