/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.journal.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.li64.tide.Tide;
import com.li64.tide.data.journal.JournalLayout;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.jetbrains.annotations.NotNull;

public class JournalPageCustomData
extends class_4309 {
    public static final String DATA_PATH = "journal/pages";
    private static final Gson GSON = new Gson();
    private List<JournalLayout.Page> pages;

    public JournalPageCustomData() {
        super(GSON, DATA_PATH);
    }

    @NotNull
    public String method_22322() {
        return "Tide Journal Page Data Loader";
    }

    protected Map<class_2960, JsonElement> method_20731(class_3300 pResourceManager, class_3695 pProfiler) {
        return super.method_20731(pResourceManager, pProfiler);
    }

    protected void apply(@NotNull Map<class_2960, JsonElement> map, @NotNull class_3300 manager, @NotNull class_3695 profiler) {
        ArrayList output = new ArrayList();
        for (Map.Entry<class_2960, JsonElement> entry : map.entrySet()) {
            class_2960 entryKey = entry.getKey();
            try {
                JournalLayout.Page.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue()).result().ifPresentOrElse(output::add, () -> Tide.LOG.warn("Did not load invalid profile entry {}", (Object)entryKey));
            }
            catch (JsonParseException | IllegalArgumentException parseException) {
                Tide.LOG.error("Parsing error loading custom journal page {}", (Object)entryKey, (Object)parseException);
            }
        }
        this.pages = ImmutableList.copyOf(output);
        Tide.LOG.info("Loaded {} custom journal pages", (Object)this.pages.size());
        Tide.JOURNAL = new JournalLayout();
        Tide.JOURNAL.addPageConfigs(this.pages);
    }

    public List<JournalLayout.Page> getPageConfigs() {
        return this.pages;
    }
}

