/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.journal.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.li64.tide.Tide;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.jetbrains.annotations.NotNull;

public class JournalRemovalCustomData
extends class_4309 {
    public static final String DATA_PATH = "journal/removals";
    private static final Gson GSON = new Gson();
    private List<Removal> removals;

    public JournalRemovalCustomData() {
        super(GSON, DATA_PATH);
    }

    @NotNull
    public String method_22322() {
        return "Tide Journal Profile Data Loader";
    }

    protected void apply(@NotNull Map<class_2960, JsonElement> map, @NotNull class_3300 manager, @NotNull class_3695 profiler) {
        ArrayList output = new ArrayList();
        for (Map.Entry<class_2960, JsonElement> entry : map.entrySet()) {
            class_2960 entryKey = entry.getKey();
            try {
                Removal.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue()).result().ifPresentOrElse(output::add, () -> Tide.LOG.warn("Did not load invalid removal entry {}", (Object)entryKey));
            }
            catch (JsonParseException | IllegalArgumentException parseException) {
                Tide.LOG.error("Parsing error loading journal removal {}", (Object)entryKey, (Object)parseException);
            }
        }
        this.removals = ImmutableList.copyOf(output);
        Tide.LOG.info("Loaded {} journal removals", (Object)this.removals.size());
        Tide.JOURNAL.removeProfileConfigs(this.removals);
    }

    public List<Removal> getRemovalConfigs() {
        return this.removals;
    }

    public record Removal(String item) {
        public static final Codec<Removal> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("item").forGetter(Removal::item)).apply((Applicative)instance, Removal::new));
    }
}

