/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.player;

import com.li64.tide.Tide;
import com.li64.tide.client.gui.JournalPage;
import com.li64.tide.data.journal.JournalLayout;
import com.li64.tide.network.messages.SyncDataMsg;
import com.li64.tide.util.TideUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;

public class TidePlayerData {
    public static TidePlayerData CLIENT_DATA = new TidePlayerData();
    private static final String NBT_TAG = "TidePlayerData";
    public List<Integer> fishUnlocked = new ArrayList<Integer>();
    public List<Integer> unreadProfiles = new ArrayList<Integer>();
    public List<Integer> pagesUnlocked = new ArrayList<Integer>();
    public List<Integer> pagesCompleted = new ArrayList<Integer>();
    public boolean gotJournal = false;
    public boolean finishedJournal = false;

    public static TidePlayerData getOrCreate(class_3222 player) {
        return TidePlayerData.getOrCreate(Tide.PLATFORM.getPlayerData(player));
    }

    public static TidePlayerData getOrCreate(class_2487 tag) {
        if (!tag.method_10545(NBT_TAG)) {
            tag.method_10566(NBT_TAG, (class_2520)new class_2487());
        }
        return new TidePlayerData(tag.method_10562(NBT_TAG));
    }

    public TidePlayerData(class_2487 tag) {
        this.deserializeNBT(tag);
    }

    public TidePlayerData() {
    }

    public void deserializeNBT(class_2487 tag) {
        this.fishUnlocked = TidePlayerData.fromIntArray(tag.method_10561("fish_unlocked"));
        this.unreadProfiles = TidePlayerData.fromIntArray(tag.method_10561("unread_pages"));
        this.pagesUnlocked = TidePlayerData.fromIntArray(tag.method_10561("pages_unlocked"));
        this.pagesCompleted = TidePlayerData.fromIntArray(tag.method_10561("pages_completed"));
        this.gotJournal = tag.method_10577("got_journal");
        this.finishedJournal = tag.method_10577("finished_journal");
    }

    public class_2487 serializeNBT() {
        class_2487 tag = new class_2487();
        tag.method_10572("fish_unlocked", this.fishUnlocked);
        tag.method_10572("unread_pages", this.unreadProfiles);
        tag.method_10572("pages_unlocked", this.pagesUnlocked);
        tag.method_10572("pages_completed", this.pagesCompleted);
        tag.method_10556("got_journal", this.gotJournal);
        tag.method_10556("finished_journal", this.finishedJournal);
        return tag;
    }

    public void syncTo(class_3222 player) {
        class_2487 playerData = Tide.PLATFORM.getPlayerData(player);
        playerData.method_10566(NBT_TAG, (class_2520)this.serializeNBT());
        if (player instanceof class_3222) {
            class_3222 serverPlayer = player;
            Tide.NETWORK.sendToPlayer(new SyncDataMsg(this), serverPlayer);
        }
    }

    public static ArrayList<Integer> fromIntArray(int[] array) {
        ArrayList<Integer> newList = new ArrayList<Integer>();
        for (int value : array) {
            newList.add(value);
        }
        return newList;
    }

    public int[] pagesIntArray() {
        int[] intArray = new int[this.pagesUnlocked.size()];
        for (int i = 0; i < this.pagesUnlocked.size(); ++i) {
            intArray[i] = this.pagesUnlocked.get(i);
        }
        return intArray;
    }

    public int[] pagesCompletedIntArray() {
        int[] intArray = new int[this.pagesUnlocked.size()];
        for (int i = 0; i < this.pagesUnlocked.size(); ++i) {
            intArray[i] = this.pagesUnlocked.get(i);
        }
        return intArray;
    }

    public int[] fishIntArray() {
        int[] intArray = new int[this.fishUnlocked.size()];
        for (int i = 0; i < this.fishUnlocked.size(); ++i) {
            intArray[i] = this.fishUnlocked.get(i);
        }
        return intArray;
    }

    public int[] unreadIntArray() {
        int[] intArray = new int[this.unreadProfiles.size()];
        for (int i = 0; i < this.unreadProfiles.size(); ++i) {
            intArray[i] = this.unreadProfiles.get(i);
        }
        return intArray;
    }

    public boolean hasPageUnlocked(JournalPage page) {
        return this.pagesUnlocked.contains(page.id()) || page.unlockedByDefault();
    }

    public boolean unlockPage(JournalPage page) {
        if (!this.hasPageUnlocked(page)) {
            this.pagesUnlocked.add(page.id());
            return true;
        }
        return false;
    }

    public void lockAllPages() {
        this.pagesUnlocked.clear();
    }

    public boolean hasFishUnlocked(class_1799 fish) {
        return this.hasFishUnlocked(fish.method_7909());
    }

    public boolean hasFishUnlocked(class_1792 fish) {
        int fishId = class_1792.method_7880((class_1792)fish);
        return this.fishUnlocked.contains(fishId);
    }

    public void unlockFish(class_1799 fish) {
        if (!this.hasFishUnlocked(fish)) {
            int fishId = class_1792.method_7880((class_1792)fish.method_7909());
            this.fishUnlocked.add(fishId);
            this.markAsUnread(fishId);
        }
    }

    public void lockAllFish() {
        this.pagesCompleted.clear();
        this.pagesUnlocked.clear();
        this.fishUnlocked.clear();
        this.unreadProfiles.clear();
    }

    public boolean hasPageCompleted(JournalPage page) {
        return this.pagesCompleted.contains(page.id());
    }

    public boolean isUnread(JournalLayout.Profile profile) {
        class_1792 fish = TideUtils.getItemFromName(profile.fishItem());
        int fishId = class_1792.method_7880((class_1792)fish);
        return this.unreadProfiles.contains(fishId);
    }

    public void markAsRead(int fishId) {
        Tide.LOG.info("Marked id {} as read", (Object)fishId);
        this.unreadProfiles.remove((Object)fishId);
    }

    public void markAsUnread(int fishId) {
        Tide.LOG.info("Marked id {} as unread", (Object)fishId);
        if (!this.unreadProfiles.contains(fishId)) {
            this.unreadProfiles.add(fishId);
        }
    }
}

