/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.registries;

import com.li64.tide.registries.TideEntityTypes;
import com.li64.tide.registries.entities.misc.DeepAquaArrowRenderer;
import com.li64.tide.registries.entities.misc.LootCrateRenderer;
import com.li64.tide.registries.entities.misc.fishing.TideFishingHookRenderer;
import com.li64.tide.registries.entities.models.SimpleFishModel;
import com.li64.tide.registries.entities.renderers.AngelfishRenderer;
import com.li64.tide.registries.entities.renderers.BarracudaRenderer;
import com.li64.tide.registries.entities.renderers.CatfishRenderer;
import com.li64.tide.registries.entities.renderers.GuppyRenderer;
import com.li64.tide.registries.entities.renderers.SailfishRenderer;
import com.li64.tide.registries.entities.renderers.SimpleFishRenderer;
import com.li64.tide.registries.entities.util.AbstractTideFish;
import java.util.ArrayList;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_5617;

public class TideEntityRenderers {
    public static final ArrayList<Registration<?>> REGISTRY = new ArrayList();

    public static void init() {
        TideEntityRenderers.registerEntityRenderer(TideEntityTypes.LOOT_CRATE, LootCrateRenderer::new);
        TideEntityRenderers.registerEntityRenderer(TideEntityTypes.FISHING_BOBBER, TideFishingHookRenderer::new);
        TideEntityRenderers.registerEntityRenderer(TideEntityTypes.DEEP_AQUA_ARROW, DeepAquaArrowRenderer::new);
        TideEntityRenderers.registerSimpleFishRenderer(TideEntityTypes.TROUT, "trout", SimpleFishModel.Variant.NOSE_NORMAL);
        TideEntityRenderers.registerSimpleFishRenderer(TideEntityTypes.BASS, "bass", SimpleFishModel.Variant.NOSE_FULL);
        TideEntityRenderers.registerSimpleFishRenderer(TideEntityTypes.YELLOW_PERCH, "yellow_perch", SimpleFishModel.Variant.NOSE_NORMAL);
        TideEntityRenderers.registerSimpleFishRenderer(TideEntityTypes.BLUEGILL, "bluegill", SimpleFishModel.Variant.NOSE_LOWER);
        TideEntityRenderers.registerSimpleFishRenderer(TideEntityTypes.MINT_CARP, "mint_carp", SimpleFishModel.Variant.NOSE_UPPER);
        TideEntityRenderers.registerSimpleFishRenderer(TideEntityTypes.PIKE, "pike", SimpleFishModel.Variant.NOSE_NORMAL);
        TideEntityRenderers.registerEntityRenderer(TideEntityTypes.GUPPY, GuppyRenderer::new);
        TideEntityRenderers.registerEntityRenderer(TideEntityTypes.CATFISH, CatfishRenderer::new);
        TideEntityRenderers.registerSimpleFishRenderer(TideEntityTypes.CLAYFISH, "clayfish", SimpleFishModel.Variant.NOSE_NORMAL);
        TideEntityRenderers.registerSimpleFishRenderer(TideEntityTypes.TUNA, "tuna", SimpleFishModel.Variant.NOSE_NORMAL);
        TideEntityRenderers.registerSimpleFishRenderer(TideEntityTypes.OCEAN_PERCH, "ocean_perch", SimpleFishModel.Variant.NOSE_UPPER);
        TideEntityRenderers.registerSimpleFishRenderer(TideEntityTypes.MACKEREL, "mackerel", SimpleFishModel.Variant.NOSE_NORMAL);
        TideEntityRenderers.registerEntityRenderer(TideEntityTypes.ANGELFISH, AngelfishRenderer::new);
        TideEntityRenderers.registerEntityRenderer(TideEntityTypes.BARRACUDA, BarracudaRenderer::new);
        TideEntityRenderers.registerEntityRenderer(TideEntityTypes.SAILFISH, SailfishRenderer::new);
    }

    public static <T extends AbstractTideFish> void registerSimpleFishRenderer(class_1299<T> entityType, String name, SimpleFishModel.Variant variant) {
        TideEntityRenderers.registerEntityRenderer(entityType, context -> new SimpleFishRenderer(name, variant, context));
    }

    public static <T extends class_1297> void registerEntityRenderer(class_1299<T> entityType, class_5617<T> renderer) {
        REGISTRY.add(new Registration<T>(entityType, renderer));
    }

    public record Registration<T extends class_1297>(class_1299<T> entityType, class_5617<T> renderer) {
    }
}

