/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.registries.entities.misc.fishing;

import com.li64.tide.Tide;
import com.li64.tide.data.TideCriteriaTriggers;
import com.li64.tide.data.TideTags;
import com.li64.tide.data.rods.CustomRodManager;
import com.li64.tide.registries.TideBlocks;
import com.li64.tide.registries.TideItems;
import com.li64.tide.registries.entities.misc.LootCrateEntity;
import com.li64.tide.registries.entities.misc.fishing.HookAccessor;
import com.li64.tide.registries.items.TideFishingRodItem;
import com.li64.tide.util.TideUtils;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1313;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_173;
import net.minecraft.class_174;
import net.minecraft.class_1787;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_39;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_8567;
import org.slf4j.Logger;

public class TideFishingHook
extends class_1676 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final class_5819 synchronizedRandom = class_5819.method_43047();
    private boolean biting;
    private int outOfWaterTime;
    private static final class_2940<Integer> DATA_HOOKED_ENTITY = class_2945.method_12791(TideFishingHook.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> DATA_BITING = class_2945.method_12791(TideFishingHook.class, (class_2941)class_2943.field_13323);
    private static final class_2940<class_1799> DATA_ROD_ITEM = class_2945.method_12791(TideFishingHook.class, (class_2941)class_2943.field_13322);
    private static final class_2940<Integer> DATA_CATCH_TYPE = class_2945.method_12791(TideFishingHook.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> DATA_MINIGAME_ACTIVE = class_2945.method_12791(TideFishingHook.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Float> DATA_INITIAL_YAW = class_2945.method_12791(TideFishingHook.class, (class_2941)class_2943.field_13320);
    private int life;
    private int nibble;
    private int timeUntilLured;
    private int timeUntilHooked;
    private float fishAngle;
    private boolean openWater = true;
    private class_1297 hookedIn;
    private FishHookState currentState = FishHookState.FLYING;
    private class_3610 fluid;
    private final int luck;
    private final int lureSpeed;
    private boolean minigameActive = false;
    protected class_1799 rod;
    protected class_1799 hookedItem;
    protected CatchType catchType = CatchType.NOTHING;

    private TideFishingHook(class_1299<? extends TideFishingHook> entityType, class_1937 level, int luck, int lureSpeed, class_1799 rod) {
        super(entityType, level);
        this.field_5985 = true;
        this.rod = rod;
        this.field_6011.method_12778(DATA_ROD_ITEM, (Object)rod);
        this.luck = Math.max(0, luck + (this.getLine().method_31574(TideItems.FORTUNE_LINE) ? 1 : 0));
        this.lureSpeed = Math.max(0, lureSpeed);
    }

    public TideFishingHook(class_1299<? extends TideFishingHook> entityType, class_1937 level) {
        this(entityType, level, 0, 0, class_1802.field_8378.method_7854());
    }

    public TideFishingHook(class_1299<? extends TideFishingHook> hookType, class_1657 player, class_1937 level, int luck, int lureSpeed, float charge, class_1799 rod) {
        this(hookType, level, luck, lureSpeed, rod);
        this.method_7432((class_1297)player);
        float f = player.method_36455();
        float f1 = player.method_36454();
        float f2 = class_3532.method_15362((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = class_3532.method_15374((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -class_3532.method_15362((float)(-f * ((float)Math.PI / 180)));
        float f5 = class_3532.method_15374((float)(-f * ((float)Math.PI / 180)));
        double d0 = player.method_23317() - (double)f3 * 0.3;
        double d1 = player.method_23320();
        double d2 = player.method_23321() - (double)f2 * 0.3;
        this.method_5808(d0, d1, d2, f1, f);
        class_243 vec3 = new class_243((double)(-f3), (double)class_3532.method_15363((float)(-(f5 / f4)), (float)-5.0f, (float)5.0f), (double)(-f2));
        double d3 = vec3.method_1033();
        vec3 = vec3.method_18805((double)charge, (double)charge, (double)charge);
        vec3 = vec3.method_18805(0.6 / d3 + this.field_5974.method_43385(0.5, 0.0103365), 0.6 / d3 + this.field_5974.method_43385(0.5, 0.0103365), 0.6 / d3 + this.field_5974.method_43385(0.5, 0.0103365));
        this.method_18799(vec3);
        this.method_36456(f1);
        this.method_36457(0.0f);
        this.field_5982 = this.method_36454();
        this.field_6004 = this.method_36455();
        this.field_6011.method_12778(DATA_INITIAL_YAW, (Object)Float.valueOf(f1));
        this.field_6011.method_12778(DATA_ROD_ITEM, (Object)rod);
    }

    public void invalidateCatch() {
        this.hookedItem = null;
        this.catchType = CatchType.NOTHING;
        this.method_5841().method_12778(DATA_CATCH_TYPE, (Object)this.catchType.ordinal());
    }

    public int getLuck() {
        return this.luck;
    }

    public float getInitialYaw() {
        return ((Float)this.field_6011.method_12789(DATA_INITIAL_YAW)).floatValue();
    }

    public int getLureSpeed() {
        return this.lureSpeed;
    }

    public class_6880<class_1959> getBiome() {
        return this.method_37908().method_23753(this.method_24515());
    }

    public boolean isOpenWaterFishing() {
        return this.openWater;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(DATA_HOOKED_ENTITY, (Object)0);
        builder.method_56912(DATA_BITING, (Object)false);
        builder.method_56912(DATA_ROD_ITEM, (Object)class_1802.field_8378.method_7854());
        builder.method_56912(DATA_CATCH_TYPE, (Object)CatchType.NOTHING.ordinal());
        builder.method_56912(DATA_MINIGAME_ACTIVE, (Object)false);
        builder.method_56912(DATA_INITIAL_YAW, (Object)Float.valueOf(0.0f));
    }

    public void method_5674(class_2940<?> data) {
        if (DATA_HOOKED_ENTITY.equals(data)) {
            int i = (Integer)this.method_5841().method_12789(DATA_HOOKED_ENTITY);
            class_1297 class_12972 = this.hookedIn = i > 0 ? this.method_37908().method_8469(i - 1) : null;
        }
        if (DATA_BITING.equals(data)) {
            this.biting = (Boolean)this.method_5841().method_12789(DATA_BITING);
            if (this.biting) {
                this.method_18800(this.method_18798().field_1352, -0.4f * class_3532.method_15344((class_5819)this.synchronizedRandom, (float)0.6f, (float)1.0f), this.method_18798().field_1350);
            }
        }
        if (DATA_ROD_ITEM.equals(data)) {
            this.rod = (class_1799)this.method_5841().method_12789(DATA_ROD_ITEM);
        }
        if (DATA_CATCH_TYPE.equals(data) && this.method_37908().method_8608()) {
            this.catchType = CatchType.values()[(Integer)this.method_5841().method_12789(DATA_CATCH_TYPE)];
        }
        if (DATA_MINIGAME_ACTIVE.equals(data)) {
            this.minigameActive = (Boolean)this.method_5841().method_12789(DATA_MINIGAME_ACTIVE);
            if (!this.method_37908().method_8608() && !this.minigameActive) {
                this.restartFishingSequence();
            }
        }
        super.method_5674(data);
    }

    public boolean method_5640(double dst) {
        return dst < 4096.0;
    }

    public void lerpTo(double p_37127_, double p_37128_, double p_37129_, float p_37130_, float p_37131_, int p_37132_, boolean p_37133_) {
    }

    public static class_243 lerpPos(class_243 start, class_243 end, float t) {
        double x = start.field_1352 + (end.field_1352 - start.field_1352) * (double)t;
        double y = start.field_1351 + (end.field_1351 - start.field_1351) * (double)t;
        double z = start.field_1350 + (end.field_1350 - start.field_1350) * (double)t;
        return new class_243(x, y, z);
    }

    public void method_5773() {
        this.synchronizedRandom.method_43052(this.method_5667().getLeastSignificantBits() ^ this.method_37908().method_8510());
        super.method_5773();
        class_1657 player = this.getPlayerOwner();
        if (player == null) {
            this.method_31472();
        } else if (this.method_37908().field_9236 || !this.shouldStopFishing(player)) {
            boolean flag;
            class_3610 fluidstate;
            if (this.method_24828()) {
                ++this.life;
                if (this.life >= 1200) {
                    this.method_31472();
                    return;
                }
            } else {
                this.life = 0;
            }
            float f = 0.0f;
            class_2338 blockpos = this.method_24515();
            this.fluid = fluidstate = this.method_37908().method_8316(blockpos);
            if (this.canFishIn(fluidstate)) {
                f = fluidstate.method_15763((class_1922)this.method_37908(), blockpos);
            }
            boolean bl = flag = f > 0.0f;
            if (this.currentState == FishHookState.FLYING) {
                if (this.hookedIn != null) {
                    this.method_18799(class_243.field_1353);
                    this.currentState = FishHookState.HOOKED_IN_ENTITY;
                    return;
                }
                if (flag) {
                    this.method_18799(this.method_18798().method_18805(0.3, 0.2, 0.3));
                    this.currentState = FishHookState.BOBBING;
                    return;
                }
                this.checkCollision();
            } else {
                if (this.currentState == FishHookState.HOOKED_IN_ENTITY) {
                    if (this.hookedIn != null) {
                        if (!this.hookedIn.method_31481() && this.hookedIn.method_37908().method_27983() == this.method_37908().method_27983()) {
                            this.method_5814(this.hookedIn.method_23317(), this.hookedIn.method_23323(0.8), this.hookedIn.method_23321());
                        } else {
                            this.setHookedEntity(null);
                            this.currentState = FishHookState.FLYING;
                        }
                    }
                    return;
                }
                if (this.currentState == FishHookState.BOBBING) {
                    class_243 vec3 = this.method_18798();
                    double d0 = this.method_23318() + vec3.field_1351 - (double)blockpos.method_10264() - (double)f;
                    if (Math.abs(d0) < 0.01) {
                        d0 += Math.signum(d0) * 0.1;
                    }
                    this.method_18800(vec3.field_1352 * 0.9, vec3.field_1351 - d0 * (double)this.field_5974.method_43057() * 0.2, vec3.field_1350 * 0.9);
                    if (this.nibble <= 0 && this.timeUntilHooked <= 0) {
                        this.openWater = true;
                    } else {
                        boolean bl2 = this.openWater = this.openWater && this.outOfWaterTime < 10 && this.calculateOpenWater(blockpos);
                    }
                    if (flag) {
                        this.outOfWaterTime = Math.max(0, this.outOfWaterTime - 1);
                        if (this.biting) {
                            this.method_18799(this.method_18798().method_1031(0.0, -0.1 * (double)this.synchronizedRandom.method_43057() * (double)this.synchronizedRandom.method_43057(), 0.0));
                        }
                        if (!this.method_37908().field_9236) {
                            this.catchingFish(blockpos);
                        }
                    } else {
                        this.outOfWaterTime = Math.min(10, this.outOfWaterTime + 1);
                    }
                }
            }
            if (!this.canFishIn(fluidstate)) {
                this.method_18799(this.method_18798().method_1031(0.0, -0.03, 0.0));
            }
            this.method_5784(class_1313.field_6308, this.method_18798());
            if (this.currentState == FishHookState.FLYING && (this.method_24828() || this.field_5976)) {
                this.method_18799(class_243.field_1353);
            }
            double d1 = 0.92;
            this.method_18799(this.method_18798().method_1021(d1));
            this.method_23311();
        }
    }

    private boolean shouldStopFishing(class_1657 player) {
        class_1799 mainHand = player.method_6047();
        class_1799 offHand = player.method_6079();
        boolean flag = mainHand.method_7909() instanceof class_1787;
        boolean flag1 = offHand.method_7909() instanceof class_1787;
        if (!player.method_31481() && player.method_5805() && (flag || flag1) && !(this.method_5858((class_1297)player) > 1224.0)) {
            return false;
        }
        this.method_31472();
        return true;
    }

    private void checkCollision() {
        class_239 hitresult = class_1675.method_49997((class_1297)this, this::method_26958);
        this.method_59860(hitresult);
    }

    protected boolean method_26958(class_1297 entity) {
        return super.method_26958(entity) || entity.method_5805() && entity instanceof class_1542;
    }

    protected void method_7454(class_3966 result) {
        super.method_7454(result);
        if (!this.method_37908().field_9236) {
            if (result.method_17782() == this.method_24921()) {
                this.method_31472();
            }
            this.setHookedEntity(result.method_17782());
        }
    }

    protected void method_24920(class_3965 result) {
        super.method_24920(result);
        this.method_18799(this.method_18798().method_1029().method_1021(result.method_24801((class_1297)this)));
    }

    private void setHookedEntity(class_1297 p_150158_) {
        this.hookedIn = p_150158_;
        this.method_5841().method_12778(DATA_HOOKED_ENTITY, (Object)(p_150158_ == null ? 0 : p_150158_.method_5628() + 1));
    }

    private void catchingFish(class_2338 pos) {
        if (Tide.PLATFORM.isModLoaded("stardew_fishing") && Tide.PLATFORM.stardewGetRewards((HookAccessor)this.getPlayerOwner().field_7513).isEmpty()) {
            return;
        }
        class_3218 level = (class_3218)this.method_37908();
        int i = 1;
        class_2338 abovePos = pos.method_10084();
        if (this.field_5974.method_43057() < 0.25f && this.method_37908().method_8520(abovePos)) {
            ++i;
        }
        if (this.field_5974.method_43057() < 0.5f && !this.method_37908().method_8311(abovePos)) {
            --i;
        }
        if (this.nibble > 0) {
            if (!this.minigameActive) {
                --this.nibble;
            }
            if (this.nibble <= 0) {
                this.restartFishingSequence();
            }
        } else if (this.timeUntilHooked > 0) {
            this.timeUntilHooked -= i;
            if (this.timeUntilHooked > 0) {
                double d2;
                double d1;
                this.fishAngle += (float)this.field_5974.method_43385(0.0, 9.188);
                float f = this.fishAngle * ((float)Math.PI / 180);
                float f1 = class_3532.method_15374((float)f);
                float f2 = class_3532.method_15362((float)f);
                double d0 = this.method_23317() + (double)(f1 * (float)this.timeUntilHooked * 0.1f);
                class_2680 blockstate = level.method_8320(class_2338.method_49637((double)d0, (double)((d1 = (double)((float)class_3532.method_15357((double)this.method_23318()) + 1.0f)) - 1.0), (double)(d2 = this.method_23321() + (double)(f2 * (float)this.timeUntilHooked * 0.1f))));
                if (blockstate.method_27852(class_2246.field_10382)) {
                    this.fluid = class_3612.field_15910.method_15785();
                    if (this.field_5974.method_43057() < 0.15f) {
                        level.method_14199((class_2394)class_2398.field_11247, d0, d1 - (double)0.1f, d2, 1, (double)f1, 0.1, (double)f2, 0.0);
                    }
                    float f3 = f1 * 0.04f;
                    float f4 = f2 * 0.04f;
                    level.method_14199((class_2394)class_2398.field_11244, d0, d1, d2, 0, (double)f4, 0.01, (double)(-f3), 1.0);
                    level.method_14199((class_2394)class_2398.field_11244, d0, d1, d2, 0, (double)(-f4), 0.01, (double)f3, 1.0);
                } else if (blockstate.method_27852(class_2246.field_10164)) {
                    this.fluid = class_3612.field_15908.method_15785();
                    if (this.field_5974.method_43057() < 0.15f) {
                        level.method_14199((class_2394)class_2398.field_11240, d0, d1 - (double)0.1f, d2, 1, (double)f1, 0.1, (double)f2, 0.0);
                    }
                    float f3 = f1 * 0.04f;
                    float f4 = f2 * 0.04f;
                    level.method_14199((class_2394)class_2398.field_11239, d0, d1, d2, 0, (double)f4, 0.01, (double)(-f3), 1.0);
                    level.method_14199((class_2394)class_2398.field_11251, d0, d1, d2, 0, 0.0, 0.01, 0.0, 1.0);
                    level.method_14199((class_2394)class_2398.field_11239, d0, d1, d2, 0, (double)(-f4), 0.01, (double)f3, 1.0);
                }
            } else {
                if (this.fluid.method_15767(TideTags.Fluids.LAVA_FISHING)) {
                    this.method_5783(class_3417.field_15010, 0.25f, 1.0f + (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.4f);
                    if (Tide.PLATFORM.isModLoaded("stardew_fishing")) {
                        this.method_5783(class_3417.field_14660, 0.25f, 1.0f + (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.4f);
                    }
                    double d3 = this.method_23318() + 0.5;
                    level.method_14199((class_2394)class_2398.field_11239, this.method_23317(), d3, this.method_23321(), (int)(1.0f + this.method_17681() * 20.0f), (double)this.method_17681(), 0.0, (double)this.method_17681(), (double)0.2f);
                    level.method_14199((class_2394)class_2398.field_11251, this.method_23317(), d3, this.method_23321(), (int)(1.0f + this.method_17681() * 20.0f), (double)this.method_17681(), 0.0, (double)this.method_17681(), (double)0.2f);
                } else {
                    this.method_5783(class_3417.field_14660, 0.25f, 1.0f + (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.4f);
                    double d3 = this.method_23318() + 0.5;
                    level.method_14199((class_2394)class_2398.field_11247, this.method_23317(), d3, this.method_23321(), (int)(1.0f + this.method_17681() * 20.0f), (double)this.method_17681(), 0.0, (double)this.method_17681(), (double)0.2f);
                    level.method_14199((class_2394)class_2398.field_11244, this.method_23317(), d3, this.method_23321(), (int)(1.0f + this.method_17681() * 20.0f), (double)this.method_17681(), 0.0, (double)this.method_17681(), (double)0.2f);
                }
                this.nibble = class_3532.method_15395((class_5819)this.field_5974, (int)20, (int)40);
                this.method_5841().method_12778(DATA_BITING, (Object)true);
                if (this.getPlayerOwner() != null) {
                    this.selectCatch(this.getPlayerOwner(), this.rod);
                } else {
                    this.catchType = CatchType.NOTHING;
                    this.method_5841().method_12778(DATA_CATCH_TYPE, (Object)this.catchType.ordinal());
                }
            }
        } else if (this.timeUntilLured > 0) {
            this.timeUntilLured -= i;
            float f5 = 0.15f;
            if (this.timeUntilLured < 20) {
                f5 += (float)(20 - this.timeUntilLured) * 0.05f;
            } else if (this.timeUntilLured < 40) {
                f5 += (float)(40 - this.timeUntilLured) * 0.02f;
            } else if (this.timeUntilLured < 60) {
                f5 += (float)(60 - this.timeUntilLured) * 0.01f;
            }
            if (this.field_5974.method_43057() < f5) {
                double d6;
                double d5;
                float f6 = class_3532.method_15344((class_5819)this.field_5974, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float f7 = class_3532.method_15344((class_5819)this.field_5974, (float)25.0f, (float)60.0f);
                double d4 = this.method_23317() + (double)(class_3532.method_15374((float)f6) * f7) * 0.1;
                class_2680 blockstate1 = level.method_8320(class_2338.method_49637((double)d4, (double)((d5 = (double)((float)class_3532.method_15357((double)this.method_23318()) + 1.0f)) - 1.0), (double)(d6 = this.method_23321() + (double)(class_3532.method_15362((float)f6) * f7) * 0.1)));
                if (blockstate1.method_27852(class_2246.field_10382)) {
                    level.method_14199((class_2394)class_2398.field_11202, d4, d5, d6, 2 + this.field_5974.method_43048(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                } else if (blockstate1.method_27852(class_2246.field_10164)) {
                    level.method_14199((class_2394)class_2398.field_11239, d4, d5, d6, 2 + this.field_5974.method_43048(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                }
            }
            if (this.timeUntilLured <= 0) {
                this.fishAngle = class_3532.method_15344((class_5819)this.field_5974, (float)0.0f, (float)360.0f);
                this.timeUntilHooked = class_3532.method_15395((class_5819)this.field_5974, (int)20, (int)80);
            }
        } else {
            this.timeUntilLured = class_3532.method_15395((class_5819)this.field_5974, (int)100, (int)600);
            this.timeUntilLured -= this.lureSpeed * 20 * 5;
        }
    }

    public void restartFishingSequence() {
        this.catchType = CatchType.NOTHING;
        this.method_5841().method_12778(DATA_CATCH_TYPE, (Object)this.catchType.ordinal());
        this.timeUntilLured = 0;
        this.timeUntilHooked = 0;
        this.method_5841().method_12778(DATA_BITING, (Object)false);
    }

    private boolean calculateOpenWater(class_2338 p_37159_) {
        OpenFluidType openWaterType = OpenFluidType.INVALID;
        for (int i = -1; i <= 2; ++i) {
            OpenFluidType openWaterType1 = this.getOpenWaterTypeForArea(p_37159_.method_10069(-2, i, -2), p_37159_.method_10069(2, i, 2));
            switch (openWaterType1.ordinal()) {
                case 2: {
                    return false;
                }
                case 0: {
                    if (openWaterType != OpenFluidType.INVALID) break;
                    return false;
                }
                case 1: {
                    if (openWaterType != OpenFluidType.ABOVE_WATER) break;
                    return false;
                }
            }
            openWaterType = openWaterType1;
        }
        return true;
    }

    private OpenFluidType getOpenWaterTypeForArea(class_2338 p_37148_, class_2338 p_37149_) {
        return class_2338.method_20437((class_2338)p_37148_, (class_2338)p_37149_).map(this::getOpenWaterTypeForBlock).reduce((p_37139_, p_37140_) -> p_37139_ == p_37140_ ? p_37139_ : OpenFluidType.INVALID).orElse(OpenFluidType.INVALID);
    }

    private OpenFluidType getOpenWaterTypeForBlock(class_2338 p_37164_) {
        class_2680 blockstate = this.method_37908().method_8320(p_37164_);
        if (!blockstate.method_26215() && !blockstate.method_27852(class_2246.field_10588)) {
            class_3610 fluidstate = blockstate.method_26227();
            return this.canFishIn(fluidstate) && fluidstate.method_15771() && blockstate.method_26220((class_1922)this.method_37908(), p_37164_).method_1110() ? OpenFluidType.INSIDE_WATER : OpenFluidType.INVALID;
        }
        return OpenFluidType.ABOVE_WATER;
    }

    public void method_5652(class_2487 tag) {
    }

    public void method_5749(class_2487 tag) {
    }

    public void retrieve() {
        this.getRodItem().retrieveHook(this.rod, this.getPlayerOwner(), this.method_37908());
    }

    public int retrieve(class_1799 stack, class_3218 level, class_1657 player) {
        if (!this.method_37908().field_9236 && player != null && !this.shouldStopFishing(player)) {
            int i = 0;
            if (this.getHookedIn() != null) {
                this.pullEntity(this.getHookedIn());
                class_174.field_1203.method_8939((class_3222)player, stack, player.field_7513, Collections.emptyList());
                this.method_37908().method_8421((class_1297)this, (byte)31);
                i = this.getHookedIn() instanceof class_1542 ? 3 : 5;
            } else if (this.nibble > 0) {
                ArrayList<class_1799> itemList = new ArrayList<class_1799>();
                switch (this.catchType.ordinal()) {
                    case 0: 
                    case 2: {
                        boolean canceled;
                        if (!this.hasHookedItem()) {
                            return 0;
                        }
                        itemList.add(this.hookedItem);
                        if (this.fluid.method_15767(TideTags.Fluids.LAVA_FISHING)) {
                            TideCriteriaTriggers.FISHED_IN_LAVA.trigger((class_3222)player);
                        }
                        if (canceled = Tide.PLATFORM.forgeItemFishedEvent(itemList, this.method_24828() ? 2 : 1, player.field_7513)) {
                            this.method_31472();
                            return 1;
                        }
                        class_1542 itemEntity = new class_1542(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), this.hookedItem);
                        double d0 = player.method_23317() - this.method_23317();
                        double d1 = player.method_23318() - this.method_23318();
                        double d2 = player.method_23321() - this.method_23321();
                        itemEntity.method_18800(d0 * 0.1, d1 * 0.1 + Math.sqrt(Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2)) * 0.08, d2 * 0.1);
                        this.method_37908().method_8649((class_1297)itemEntity);
                        player.method_37908().method_8649((class_1297)new class_1303(player.method_37908(), player.method_23317(), player.method_23318() + 0.5, player.method_23321() + 0.5, this.field_5974.method_43048(6) + 1));
                        if (this.hookedItem.method_31573(class_3489.field_15527)) {
                            player.method_7339(class_3468.field_15391, 1);
                        }
                        class_174.field_1203.method_8939((class_3222)player, stack, player.field_7513, itemList);
                        Tide.LOG.info("Caught fish: {}", (Object)this.hookedItem.method_7922());
                        break;
                    }
                    case 1: {
                        class_5321<class_52> lootTable = TideUtils.getCrateLoot(this.method_23317(), this.method_23318(), this.method_23321(), this.fluid, this.method_37908());
                        class_2680 lootCrate = this.getCrateBlock(this.fluid);
                        class_8567.class_8568 lootParamsBuilder = new class_8567.class_8568((class_3218)this.method_37908()).method_51874(class_181.field_24424, (Object)this.method_19538()).method_51874(class_181.field_1229, (Object)stack).method_51874(class_181.field_1226, (Object)this);
                        if (!Tide.PLATFORM.isFabric()) {
                            lootParamsBuilder = lootParamsBuilder.method_51874(class_181.field_1230, (Object)Objects.requireNonNull(this.method_24921()));
                        }
                        class_8567 lootParams = lootParamsBuilder.method_51871((float)this.luck + player.method_7292()).method_51875(class_173.field_1176);
                        level.method_8501(this.method_24515(), lootCrate);
                        double dx = player.method_23317() - (double)this.method_24515().method_10263();
                        double dy = player.method_23318() - (double)this.method_24515().method_10264();
                        double dz = player.method_23321() - (double)this.method_24515().method_10260();
                        LootCrateEntity.fall((class_1937)level, this.method_24515(), lootCrate, dx * 0.0666, dy * 0.0666 + Math.sqrt(Math.sqrt(dx * dx + dy * dy + dz * dz)) * 0.082 + 0.27, dz * 0.0666, lootTable, lootParams);
                        if (this.fluid.method_15767(TideTags.Fluids.LAVA_FISHING) && this.fluid.method_39360((class_3611)class_3612.field_15908)) {
                            level.method_8501(this.method_24515(), class_2246.field_10164.method_9564());
                        }
                        if (this.fluid.method_15767(TideTags.Fluids.WATER_FISHING) && this.fluid.method_39360((class_3611)class_3612.field_15910)) {
                            level.method_8501(this.method_24515(), class_2246.field_10382.method_9564());
                        }
                        TideCriteriaTriggers.FISHED_CRATE.trigger((class_3222)player);
                        break;
                    }
                }
                i = 1;
            }
            if (this.method_24828()) {
                i = 2;
            }
            this.startRetrieving();
            if (this.getLine().method_31574(TideItems.FISHING_LINE)) {
                i -= new Random().nextFloat() > 0.7f ? 1 : 0;
            }
            return i;
        }
        return 0;
    }

    public void selectCatch(class_1657 player, class_1799 rod) {
        this.catchType = CatchType.NOTHING;
        this.hookedItem = null;
        boolean pullCrate = false;
        if (player.method_6079().method_31574(TideItems.MAGNETIC_BAIT)) {
            if (this.field_5974.method_43051(0, (int)Math.ceil((double)Tide.CONFIG.general.baseCrateRarity / 5.0)) == 0) {
                pullCrate = true;
            }
        } else if (this.field_5974.method_43051(0, Tide.CONFIG.general.baseCrateRarity) == 0) {
            pullCrate = true;
        }
        if (TideUtils.moddedDimension((class_5321<class_1937>)this.method_37908().method_27983())) {
            pullCrate = false;
        }
        if (pullCrate) {
            this.catchType = CatchType.CRATE;
        } else {
            class_8567.class_8568 lootParamsBuilder = new class_8567.class_8568((class_3218)this.method_37908()).method_51874(class_181.field_24424, (Object)this.method_19538()).method_51874(class_181.field_1229, (Object)rod).method_51874(class_181.field_1226, (Object)this);
            if (!Tide.PLATFORM.isFabric()) {
                lootParamsBuilder = lootParamsBuilder.method_51874(class_181.field_1230, (Object)Objects.requireNonNull(this.method_24921()));
            }
            class_8567 lootParams = lootParamsBuilder.method_51871((float)this.luck + player.method_7292()).method_51875(class_173.field_1176);
            class_5321<class_52> lootKey = class_39.field_353;
            class_52 table = this.method_37908().method_8503().method_58576().method_58295((class_5321)lootKey);
            class_3218 overworld = this.method_37908().method_8503().method_30002();
            Object list = table.method_51878(lootParams);
            if (list.isEmpty()) {
                list = ObjectArrayList.of((Object[])new class_1799[]{class_1802.field_8209.method_7854()});
            }
            if (TideUtils.shouldGrabTideLootTable((List<class_1799>)(list = TideUtils.checkForOverrides((List<class_1799>)list, this, overworld)), this.fluid)) {
                lootKey = TideUtils.getTideLootTable(this.method_23317(), this.method_23318(), this.method_23321(), this.fluid, this.method_37908(), this.field_5974);
                table = this.method_37908().method_8503().method_58576().method_58295(lootKey);
                list = table.method_51878(lootParams);
            }
            Tide.LOG.info("Loot table used: {}", (Object)lootKey.method_29177());
            this.hookedItem = list.size() == 1 ? (class_1799)list.getFirst() : (class_1799)list.get(new Random().nextInt(0, list.size()));
            CatchType catchType = this.catchType = this.hookedItem.method_31573(class_3489.field_15527) || TideUtils.isJournalFish(this.hookedItem) ? CatchType.FISH : CatchType.ITEM;
        }
        if (TideUtils.isHoldingBait(player)) {
            if (!player.method_7337()) {
                player.method_6079().method_7934(1);
            }
            Tide.LOG.info("Using bait");
        }
        this.method_5841().method_12778(DATA_CATCH_TYPE, (Object)this.catchType.ordinal());
    }

    public class_2680 getCrateBlock(class_3610 fluid) {
        class_1937 level = this.method_37908();
        if (fluid.method_15772() == class_3612.field_15908) {
            if (level.method_27983() == class_1937.field_25180) {
                return TideBlocks.OBSIDIAN_LOOT_CRATE.method_9564();
            }
            if (level.method_27983() == class_1937.field_25181) {
                return TideBlocks.END_LOOT_CRATE.method_9564();
            }
            return TideBlocks.OBSIDIAN_LOOT_CRATE.method_9564();
        }
        if (level.method_27983() == class_1937.field_25181) {
            return TideBlocks.END_LOOT_CRATE.method_9564();
        }
        return TideBlocks.SURFACE_LOOT_CRATE.method_9564();
    }

    public void method_5711(byte event) {
        if (event == 31 && this.method_37908().field_9236 && this.hookedIn instanceof class_1657 && ((class_1657)this.hookedIn).method_7340()) {
            this.pullEntity(this.hookedIn);
        }
        super.method_5711(event);
    }

    protected void pullEntity(class_1297 entity) {
        class_1297 owner = this.method_24921();
        if (owner != null) {
            class_243 vec3 = new class_243(owner.method_23317() - this.method_23317(), owner.method_23318() - this.method_23318(), owner.method_23321() - this.method_23321()).method_1021(0.1);
            entity.method_18799(entity.method_18798().method_1019(vec3));
        }
    }

    protected void startRetrieving() {
        this.catchType = CatchType.NOTHING;
        this.method_31472();
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28630;
    }

    public void method_5650(class_1297.class_5529 reason) {
        this.updateOwnerInfo(null);
        super.method_5650(reason);
    }

    public void method_36209() {
        this.updateOwnerInfo(null);
    }

    public void method_7432(class_1297 entity) {
        super.method_7432(entity);
        this.updateOwnerInfo(this);
    }

    private void updateOwnerInfo(TideFishingHook hook) {
        class_1657 player = this.getPlayerOwner();
        if (player != null) {
            if (hook == null && player.field_7513 != null) {
                ((HookAccessor)player.field_7513).clearHook(player);
            }
            if (player.field_7513 == null && hook != null) {
                player.field_7513 = new HookAccessor(hook, this.method_37908());
            }
        }
    }

    public class_1657 getPlayerOwner() {
        class_1297 entity = this.method_24921();
        return entity instanceof class_1657 ? (class_1657)entity : null;
    }

    public class_1297 getHookedIn() {
        return this.hookedIn;
    }

    public void method_31471(class_2604 p_150150_) {
        super.method_31471(p_150150_);
        if (this.getPlayerOwner() == null) {
            int i = p_150150_.method_11166();
            LOGGER.error("Failed to recreate fishing hook on client. {} (id: {}) is not a valid owner.", (Object)this.method_37908().method_8469(i), (Object)i);
            this.method_5768();
        }
    }

    public boolean method_5753() {
        if (this.canFishInLava()) {
            return true;
        }
        return super.method_5753();
    }

    public boolean method_5809() {
        if (this.canFishInLava()) {
            return false;
        }
        return super.method_5809();
    }

    public boolean canFishIn(class_3610 fluidState) {
        if (fluidState.method_15767(TideTags.Fluids.LAVA_FISHING)) {
            return this.canFishInLava();
        }
        return fluidState.method_15767(TideTags.Fluids.CAN_FISH_IN);
    }

    public boolean canFishInLava() {
        return this.getRodItem().isLavaproof(this.rod);
    }

    public TideFishingRodItem getRodItem() {
        return (TideFishingRodItem)this.rod.method_7909();
    }

    public class_1799 getBobber() {
        return CustomRodManager.getBobber(this.rod);
    }

    public class_1799 getHook() {
        return CustomRodManager.getHook(this.rod);
    }

    public class_1799 getLine() {
        return CustomRodManager.getLine(this.rod);
    }

    public boolean hasHookedItem() {
        return this.hookedItem != null && !this.hookedItem.method_31574(class_1802.field_8162);
    }

    public class_1792 getHookedItem() {
        return this.hookedItem.method_7909();
    }

    public void setMinigameActive(boolean state) {
        this.minigameActive = state;
        if (!this.minigameActive) {
            this.nibble = 0;
        }
        this.field_6011.method_12778(DATA_MINIGAME_ACTIVE, (Object)state);
    }

    public CatchType getCatchType() {
        return CatchType.values()[(Integer)this.method_5841().method_12789(DATA_CATCH_TYPE)];
    }

    static enum FishHookState {
        FLYING,
        HOOKED_IN_ENTITY,
        BOBBING;

    }

    public static enum CatchType {
        FISH,
        CRATE,
        ITEM,
        NOTHING;

    }

    static enum OpenFluidType {
        ABOVE_WATER,
        INSIDE_WATER,
        INVALID;

    }
}

