/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.registries.items;

import com.li64.tide.Tide;
import com.li64.tide.client.gui.overlays.CastBarOverlay;
import com.li64.tide.data.TideDataComponents;
import com.li64.tide.data.minigame.FishCatchMinigame;
import com.li64.tide.data.rods.CustomRodManager;
import com.li64.tide.data.rods.TideAccessoryData;
import com.li64.tide.registries.TideEntityTypes;
import com.li64.tide.registries.TideItems;
import com.li64.tide.registries.entities.misc.fishing.HookAccessor;
import com.li64.tide.registries.entities.misc.fishing.TideFishingHook;
import com.li64.tide.util.TideUtils;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1787;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_5250;
import net.minecraft.class_5712;
import net.minecraft.class_6880;

public class TideFishingRodItem
extends class_1787 {
    public static final class_2960 CAST_PROPERTY = Tide.resource("cast");

    public TideFishingRodItem(double baseDurability, class_1792.class_1793 properties) {
        super(properties.method_7895((int)(baseDurability * (Tide.CONFIG == null ? 1.0 : Tide.CONFIG.general.rodDurabilityMultiplier))));
    }

    public boolean isLavaproof(class_1799 stack) {
        return CustomRodManager.getHook(stack).method_31574(TideItems.LAVAPROOF_FISHING_HOOK);
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        if (this.isHookActive(player)) {
            TideFishingHook hook = this.getHook(player);
            if (!this.isMinigameActive(player) && Tide.CONFIG.general.doMinigame) {
                if (Tide.PLATFORM.isModLoaded("stardew_fishing")) {
                    if (hook.getCatchType() == TideFishingHook.CatchType.FISH || hook.getCatchType() == TideFishingHook.CatchType.ITEM) {
                        if (!level.method_8608()) {
                            Tide.LOG.info("Starting stardew fishing minigame");
                            level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15093, class_3419.field_15254, 1.2f, 0.4f / (level.method_8409().method_43057() * 0.4f + 0.8f));
                            if (!Tide.PLATFORM.stardewStart((class_3222)player, (HookAccessor)player.field_7513, player.method_5998(hand), List.of(hook.getHookedItem().method_7854()))) {
                                this.retrieveHook(player.method_5998(hand), player, level);
                            }
                        }
                    } else {
                        this.retrieveHook(player.method_5998(hand), player, level);
                    }
                } else if (hook.getCatchType() == TideFishingHook.CatchType.FISH) {
                    if (!level.method_8608() && !this.isMinigameActive(player)) {
                        Tide.LOG.info("Starting tide fishing minigame");
                        FishCatchMinigame.create(player);
                    }
                } else {
                    this.retrieveHook(player.method_5998(hand), player, level);
                }
            } else if (!level.method_8608()) {
                if (Tide.CONFIG.general.doMinigame) {
                    FishCatchMinigame minigame = FishCatchMinigame.getInstance(player);
                    if (minigame != null) {
                        minigame.interact();
                    }
                } else {
                    hook.retrieve();
                }
            }
            return class_1271.method_29237((Object)player.method_5998(hand), (boolean)level.method_8608());
        }
        if (Tide.CONFIG.general.holdToCast) {
            level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15093, class_3419.field_15254, 1.5f, 0.3f / (level.method_8409().method_43057() * 0.4f + 0.7f));
            player.method_6019(hand);
            return class_1271.method_22428((Object)player.method_5998(hand));
        }
        this.castHook(player.method_5998(hand), player, level, 1.0f);
        return class_1271.method_29237((Object)player.method_5998(hand), (boolean)level.method_8608());
    }

    private boolean isMinigameActive(class_1657 player) {
        return FishCatchMinigame.minigameActive(player);
    }

    public void method_7840(class_1799 rod, class_1937 level, class_1309 user, int charge) {
        if (user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            int chargeDifference = this.method_7881(rod, user) - charge;
            if (chargeDifference > this.getChargeDuration(rod)) {
                chargeDifference = this.getChargeDuration(rod);
            }
            float chargeMultiplier = (float)chargeDifference / (float)this.getChargeDuration(rod) + 0.5f;
            this.castHook(rod, player, level, chargeMultiplier);
        }
    }

    public boolean isHookActive(class_1657 player) {
        TideFishingHook hook = HookAccessor.getHook(player);
        return hook != null;
    }

    public TideFishingHook getHook(class_1657 player) {
        return HookAccessor.getHook(player);
    }

    public void castHook(class_1799 rod, class_1657 player, class_1937 level, float charge) {
        TideFishingHook activeHook = HookAccessor.getHook(player);
        if (activeHook == null) {
            level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14596, class_3419.field_15254, 0.5f, 0.4f / (level.method_8409().method_43057() * 0.4f + 0.8f));
            if (!level.field_9236) {
                int speed = (int)(class_1890.method_60158((class_3218)((class_3218)level), (class_1799)rod, (class_1297)player) / 5.0f);
                int luck = class_1890.method_8223((class_3218)((class_3218)level), (class_1799)rod, (class_1297)player);
                if (TideUtils.isHoldingBait(player)) {
                    speed += TideUtils.getBaitSpeed(TideUtils.getHeldBaitItem(player));
                    luck += TideUtils.getBaitLuck(TideUtils.getHeldBaitItem(player));
                }
                level.method_8649((class_1297)new TideFishingHook(TideEntityTypes.FISHING_BOBBER, player, level, luck, speed, charge, rod));
            }
            player.method_7259(class_3468.field_15372.method_14956((Object)this));
            player.method_32876((class_6880)class_5712.field_28145);
        }
    }

    public void retrieveHook(class_1799 rod, class_1657 player, class_1937 level) {
        TideFishingHook activeHook = HookAccessor.getHook(player);
        if (activeHook != null) {
            if (!level.field_9236) {
                int durabilityLoss = activeHook.retrieve(rod, (class_3218)level, player);
                rod.method_7970(durabilityLoss, (class_1309)player, class_1309.method_56079((class_1268)player.method_6058()));
            }
            level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15093, class_3419.field_15254, 1.2f, 0.4f / (level.method_8409().method_43057() * 0.4f + 0.8f));
            player.method_32876((class_6880)class_5712.field_28146);
        }
    }

    public void method_7852(class_1937 level, class_1309 user, class_1799 rod, int charge) {
        super.method_7852(level, user, rod, charge);
        if (level.method_8608() && user == class_310.method_1551().field_1724) {
            int chargeDifference = this.method_7881(rod, user) - charge;
            if (chargeDifference > this.getChargeDuration(rod)) {
                chargeDifference = this.getChargeDuration(rod);
            }
            CastBarOverlay.rodChargeTick((float)chargeDifference / (float)this.getChargeDuration(rod));
        }
    }

    public int method_7881(class_1799 stack, class_1309 entity) {
        return 60000;
    }

    public int getChargeDuration(class_1799 rod) {
        return CustomRodManager.getLine(rod).method_31574(TideItems.BRAIDED_LINE) ? 15 : 25;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 flag) {
        super.method_7851(stack, context, tooltip, flag);
        TideAccessoryData bobberData = (TideAccessoryData)CustomRodManager.getBobber(stack).method_57824(TideDataComponents.TIDE_ACCESSORY_DATA);
        TideAccessoryData hookData = (TideAccessoryData)CustomRodManager.getHook(stack).method_57824(TideDataComponents.TIDE_ACCESSORY_DATA);
        TideAccessoryData lineData = (TideAccessoryData)CustomRodManager.getLine(stack).method_57824(TideDataComponents.TIDE_ACCESSORY_DATA);
        if (bobberData == null || hookData == null || lineData == null) {
            return;
        }
        class_5250 bobberComponent = (class_5250)bobberData.translationKey();
        tooltip.add((class_2561)bobberComponent.method_27696(bobberComponent.method_10866().method_10978(Boolean.valueOf(true)).method_10977(class_124.field_1054)));
        class_5250 hookComponent = (class_5250)hookData.translationKey();
        tooltip.add((class_2561)hookComponent.method_27696(hookComponent.method_10866().method_10978(Boolean.valueOf(true)).method_10977(class_124.field_1054)));
        class_5250 lineComponent = (class_5250)lineData.translationKey();
        tooltip.add((class_2561)lineComponent.method_27696(lineComponent.method_10866().method_10978(Boolean.valueOf(true)).method_10977(class_124.field_1054)));
    }
}

