/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.util;

import com.li64.tide.Tide;
import com.li64.tide.client.gui.JournalPage;
import com.li64.tide.data.TideCriteriaTriggers;
import com.li64.tide.data.TideLootTables;
import com.li64.tide.data.TideTags;
import com.li64.tide.data.journal.JournalLayout;
import com.li64.tide.data.player.TidePlayerData;
import com.li64.tide.network.messages.ShowToastMsg;
import com.li64.tide.registries.TideItems;
import com.li64.tide.registries.entities.misc.fishing.TideFishingHook;
import com.li64.tide.registries.items.BaitItem;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_39;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class TideUtils {
    public static HashMap<String, class_1792> PROFILE_ITEMS;

    public static boolean moddedDimension(class_5321<class_1937> dimension) {
        return dimension != class_1937.field_25179 && dimension != class_1937.field_25180 && dimension != class_1937.field_25181;
    }

    public static LootLayer getLayerAt(double y) {
        if (y < 0.0) {
            return LootLayer.DEPTHS;
        }
        if (y < 50.0) {
            return LootLayer.UNDERGROUND;
        }
        return LootLayer.SURFACE;
    }

    public static List<class_1799> checkForOverrides(List<class_1799> list, TideFishingHook hook, class_3218 level) {
        class_1799 result = list.get(0);
        int luck = hook.getLuck();
        int moonPhase = level.method_30273();
        if (result.method_31574(TideItems.VOIDSEEKER) && moonPhase != 0 && moonPhase != 4) {
            result = new class_1799((class_1935)TideItems.ENDSTONE_PERCH, 1);
        }
        if (hook.getLuck() >= 5 && new Random().nextInt(0, 24) == 1) {
            result = new class_1799((class_1935)TideItems.MIDAS_FISH, 1);
        }
        if (moonPhase == 0 && hook.getBiome().method_40220(TideTags.Biomes.CAN_CATCH_STARFISH) && level.method_23886() && new Random().nextInt(0, 24 - luck) == 1) {
            result = new class_1799((class_1935)TideItems.SHOOTING_STARFISH, 1);
        }
        return List.of(result);
    }

    public static boolean shouldGrabTideLootTable(List<class_1799> items, class_3610 fluid) {
        if (items.getFirst().method_31573(TideTags.Items.VANILLA_FISH) || new Random().nextInt(0, 4) == 0) {
            return true;
        }
        return fluid.method_15767(TideTags.Fluids.LAVA_FISHING);
    }

    private static boolean isInDimension(String name, class_1937 level) {
        return level.method_27983().method_29177().toString().matches(name);
    }

    public static class_5321<class_52> getTideLootTable(double x, double y, double z, class_3610 fluid, class_1937 level, class_5819 random) {
        LootLayer layer = TideUtils.getLayerAt(y);
        class_6880 biomeHolder = level.method_23753(new class_2338((int)x, (int)y, (int)z));
        if (TideUtils.moddedDimension((class_5321<class_1937>)level.method_27983())) {
            if (fluid.method_15767(TideTags.Fluids.LAVA_FISHING)) {
                return TideLootTables.Fishing.LAVA_SURFACE;
            }
            return class_39.field_353;
        }
        if (level.method_27983() == class_1937.field_25180) {
            if (Tide.PLATFORM.isModLoaded("netherdepthsupgrade")) {
                Random random2 = new Random();
                if (random2.nextFloat() > 0.65f) {
                    return class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)class_2960.method_60655((String)"netherdepthsupgrade", (String)"gameplay/nether_fishing"));
                }
            }
            return TideLootTables.Fishing.NETHER;
        }
        if (level.method_27983() == class_1937.field_25181) {
            if (fluid.method_15767(TideTags.Fluids.LAVA_FISHING)) {
                return TideLootTables.Fishing.END_LAVA;
            }
            return TideLootTables.Fishing.END_WATER;
        }
        if (layer == LootLayer.UNDERGROUND && level.method_27983() == class_1937.field_25179) {
            if (fluid.method_15767(TideTags.Fluids.LAVA_FISHING)) {
                return TideLootTables.Fishing.LAVA_UNDERGROUND;
            }
            class_5321<class_52> biomeLoot = TideUtils.getBiomeLootTable((class_6880<class_1959>)biomeHolder);
            if (biomeLoot != null && random.method_43051(0, 21) == 1) {
                return biomeLoot;
            }
            return TideLootTables.Fishing.UNDERGROUND;
        }
        if (layer == LootLayer.DEPTHS && level.method_27983() == class_1937.field_25179) {
            if (fluid.method_15767(TideTags.Fluids.LAVA_FISHING)) {
                return TideLootTables.Fishing.LAVA_DEPTHS;
            }
            class_5321<class_52> biomeLoot = TideUtils.getBiomeLootTable((class_6880<class_1959>)biomeHolder);
            if (biomeLoot != null && random.method_43051(0, 21) == 1) {
                return biomeLoot;
            }
            return TideLootTables.Fishing.DEPTHS;
        }
        if (fluid.method_15767(TideTags.Fluids.LAVA_FISHING)) {
            return TideLootTables.Fishing.LAVA_SURFACE;
        }
        class_5321<class_52> biomeLoot = TideUtils.getBiomeLootTable((class_6880<class_1959>)biomeHolder);
        if (biomeLoot != null && random.method_43051(0, 21) == 1) {
            return biomeLoot;
        }
        if (biomeHolder.method_40220(TideTags.Climate.IS_COLD)) {
            if (biomeHolder.method_40220(TideTags.Climate.IS_SALTWATER)) {
                return TideLootTables.Fishing.SALTWATER_COLD;
            }
            return TideLootTables.Fishing.FRESHWATER_COLD;
        }
        if (biomeHolder.method_40220(TideTags.Climate.IS_WARM)) {
            if (biomeHolder.method_40220(TideTags.Climate.IS_SALTWATER)) {
                return TideLootTables.Fishing.SALTWATER_WARM;
            }
            return TideLootTables.Fishing.FRESHWATER_WARM;
        }
        if (biomeHolder.method_40220(TideTags.Climate.IS_SALTWATER)) {
            return TideLootTables.Fishing.SALTWATER_NORMAL;
        }
        return TideLootTables.Fishing.FRESHWATER_NORMAL;
    }

    public static class_5321<class_52> getBiomeLootTable(class_6880<class_1959> biomeHolder) {
        for (class_6862<class_1959> tag : TideTags.Biomes.fishingBiomes) {
            if (!biomeHolder.method_40220(tag)) continue;
            return TideLootTables.getByLocation(Tide.resource("gameplay/fishing/biomes/" + tag.comp_327().method_12832()));
        }
        return null;
    }

    public static class_5321<class_52> getCrateLoot(double x, double y, double z, class_3610 fluid, class_1937 level) {
        class_6880 biomeHolder = level.method_23753(new class_2338((int)x, (int)y, (int)z));
        LootLayer layer = TideUtils.getLayerAt(y);
        if (fluid.method_15772() == class_3612.field_15908) {
            if (level.method_27983() == class_1937.field_25180) {
                return TideLootTables.Crates.NETHER_LAVA;
            }
            if (level.method_27983() == class_1937.field_25181) {
                return TideLootTables.Crates.END_LAVA;
            }
            if (layer == LootLayer.SURFACE) {
                return TideLootTables.Crates.OVERWORLD_LAVA_SURFACE;
            }
            if (layer == LootLayer.UNDERGROUND) {
                return TideLootTables.Crates.OVERWORLD_LAVA_UNDERGROUND;
            }
            return TideLootTables.Crates.OVERWORLD_LAVA_DEEP;
        }
        if (level.method_27983() == class_1937.field_25181) {
            return TideLootTables.Crates.END_WATER;
        }
        if (layer == LootLayer.SURFACE) {
            if (biomeHolder.method_40220(TideTags.Climate.IS_SALTWATER)) {
                return TideLootTables.Crates.OVERWORLD_WATER_OCEAN;
            }
            return TideLootTables.Crates.OVERWORLD_WATER_RIVER;
        }
        if (layer == LootLayer.UNDERGROUND) {
            return TideLootTables.Crates.OVERWORLD_WATER_UNDERGROUND;
        }
        return TideLootTables.Crates.OVERWORLD_WATER_DEEP;
    }

    public static boolean isJournalFish(class_1799 stack) {
        if (PROFILE_ITEMS == null || PROFILE_ITEMS.size() != Tide.JOURNAL.getProfileConfigs().size()) {
            PROFILE_ITEMS = new HashMap();
            Tide.JOURNAL.getProfileConfigs().forEach(config -> PROFILE_ITEMS.put(config.fishItem(), TideUtils.getItemFromName(config.fishItem())));
        }
        return PROFILE_ITEMS.containsKey(TideUtils.getNameFromItem(stack.method_7909()));
    }

    public static String getNameFromItem(class_1792 item) {
        return class_7923.field_41178.method_10221((Object)item).toString();
    }

    public static class_1792 getItemFromName(String name) {
        return (class_1792)class_7923.field_41178.method_10223((class_2960)class_2960.method_29186((String)name).getOrThrow());
    }

    public static void checkPageCompletion(TidePlayerData data, JournalPage page, class_3222 player) {
        if (TideUtils.isCategoryCompleted(data, page) && !data.hasPageCompleted(page)) {
            data.pagesCompleted.add(page.id());
            if (data.pagesCompleted.size() <= 1) {
                TideCriteriaTriggers.FINISH_PAGE.trigger(player);
            }
            if (data.pagesCompleted.size() >= Tide.JOURNAL.getPageConfigs().size() - 1) {
                data.finishedJournal = true;
                TideCriteriaTriggers.FINISH_JOURNAL.trigger(player);
            }
            data.syncTo(player);
            Tide.LOG.debug("Player completed category: {}", (Object)page.idName());
            Tide.LOG.debug("Completed {}/{} categories", (Object)data.pagesCompleted.size(), (Object)Tide.JOURNAL.getPageConfigs().size());
        }
    }

    public static boolean isCategoryCompleted(TidePlayerData data, JournalPage page) {
        List<class_1792> fishes = TideUtils.getFishFromProfileList(page.getAllProfiles());
        if (fishes == null) {
            return false;
        }
        for (class_1792 fish : fishes) {
            class_1799 fishStack = new class_1799((class_1935)fish);
            if (data.hasFishUnlocked(fishStack)) continue;
            return false;
        }
        return true;
    }

    public static void unlockPage(class_3222 player, JournalPage page) {
        TidePlayerData data = TidePlayerData.getOrCreate(player);
        if (!data.hasPageUnlocked(page)) {
            data.unlockPage(page);
            Tide.NETWORK.sendToPlayer(new ShowToastMsg((class_2561)class_2561.method_43471((String)"newpage.toast.title"), TideUtils.getPageToastDesc(page), TideUtils.getPageToastIcon(page)), player);
            data.syncTo(player);
        }
    }

    public static void unlockFishForCategory(class_3222 player, String name) {
        TidePlayerData data = TidePlayerData.getOrCreate(player);
        JournalPage page = TideUtils.getPageByName(name);
        if (page == null) {
            return;
        }
        List<class_1792> fishes = TideUtils.getFishFromProfileList(page.getAllProfiles());
        for (class_1792 fish : fishes) {
            if (data.hasFishUnlocked(fish.method_7854())) continue;
            data.unlockFish(fish.method_7854());
        }
        TideUtils.checkPageCompletion(data, page, player);
        data.syncTo(player);
    }

    public static boolean isInPage(String pageName, class_1799 stack) {
        List<class_1792> fishes = TideUtils.getFishFromPageName(pageName);
        if (fishes == null) {
            return false;
        }
        return fishes.contains(stack.method_7909());
    }

    public static class_2561 removeRawTextInName(class_2561 initialName) {
        String[] splitName = class_2561.method_43471((String)initialName.getString()).getString().split("Raw ");
        StringBuilder nameBuilder = new StringBuilder();
        for (String string : splitName) {
            nameBuilder.append(string);
        }
        return class_2561.method_43470((String)nameBuilder.toString());
    }

    public static class_1799 getPageToastIcon(JournalPage page) {
        return page.icon();
    }

    public static class_2561 getPageToastDesc(JournalPage page) {
        return class_2561.method_43471((String)page.title());
    }

    public static List<class_1792> getFishFromProfileList(List<JournalLayout.Profile> profiles) {
        return profiles.stream().map(profile -> (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)profile.fishItem()))).toList();
    }

    public static List<class_1792> getFishFromPageName(String name) {
        JournalPage page = TideUtils.getPageByName(name);
        if (page == null) {
            return null;
        }
        return TideUtils.getFishFromProfileList(page.getAllProfiles());
    }

    public static JournalPage getPageByName(String name) {
        JournalLayout.Page pageConfig = Tide.JOURNAL.getPageConfigs().stream().filter(config -> config.id().matches(name)).findFirst().orElse(null);
        if (pageConfig == null) {
            return null;
        }
        return new JournalPage(pageConfig);
    }

    public static JournalPage getPageByNumber(int pageNumber) {
        if (pageNumber > Tide.JOURNAL.getPageConfigs().size() - 1) {
            return null;
        }
        return new JournalPage(Tide.JOURNAL.getPageConfigs().get(pageNumber));
    }

    public static JournalLayout.Profile getProfileFromItem(class_1799 item) {
        return Tide.JOURNAL.getProfileConfigs().stream().filter(config -> item.method_31574((class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)config.fishItem())))).findFirst().orElse(null);
    }

    public static boolean isHoldingBait(class_1657 player) {
        return TideUtils.isBait(player.method_6079()) || TideUtils.isBait(player.method_6047());
    }

    public static class_1799 getHeldBaitItem(class_1657 player) {
        if (!TideUtils.isHoldingBait(player)) {
            return class_1799.field_8037;
        }
        return TideUtils.isBait(player.method_6079()) ? player.method_6079() : player.method_6047();
    }

    public static boolean isBait(class_1799 stack) {
        if (stack.method_7922().equals("item.fishofthieves.earthworms")) {
            return true;
        }
        if (stack.method_7922().equals("item.fishofthieves.grubs")) {
            return true;
        }
        if (stack.method_7922().equals("item.fishofthieves.leeches")) {
            return true;
        }
        return stack.method_7909() instanceof BaitItem;
    }

    public static int getBaitSpeed(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof BaitItem) {
            BaitItem bait = (BaitItem)class_17922;
            return bait.getSpeedBonus();
        }
        if (stack.method_7922().equals("item.fishofthieves.earthworms")) {
            return 2;
        }
        if (stack.method_7922().equals("item.fishofthieves.grubs")) {
            return 2;
        }
        if (stack.method_7922().equals("item.fishofthieves.leeches")) {
            return 2;
        }
        return 0;
    }

    public static int getBaitLuck(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof BaitItem) {
            BaitItem bait = (BaitItem)class_17922;
            return bait.getLuckBonus();
        }
        return 0;
    }

    public static enum LootLayer {
        SURFACE,
        UNDERGROUND,
        DEPTHS;

    }
}

