/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.mixin.chunk;

import com.koteinik.chunksfadein.MathUtils;
import com.koteinik.chunksfadein.config.Config;
import com.koteinik.chunksfadein.core.AnimationType;
import com.koteinik.chunksfadein.extensions.RenderSectionExt;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSection;
import net.caffeinemc.mods.sodium.client.render.chunk.region.RenderRegion;
import net.minecraft.class_1297;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4076;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={RenderSection.class}, remap=false)
public class RenderSectionMixin
implements RenderSectionExt {
    private static final Vector3f UP = new Vector3f(0.0f, 1.0f, 0.0f);
    private static final float[] FULLY_ANIMATED_OFFSET = new float[]{0.0f, 0.0f, 0.0f};
    @Shadow
    @Final
    private RenderRegion region;
    @Shadow
    @Final
    private int chunkX;
    @Shadow
    @Final
    private int chunkY;
    @Shadow
    @Final
    private int chunkZ;
    private long lastFrameTime = 0L;
    private boolean hasRenderedBefore;
    private float fadeCoeff = 0.0f;
    private float animationProgress = 0.0f;
    private final float[] offset = new float[]{0.0f, 0.0f, 0.0f};

    @Override
    public boolean hasRenderedBefore() {
        return this.hasRenderedBefore;
    }

    @Override
    public void setRenderedBefore() {
        this.hasRenderedBefore = true;
    }

    @Override
    public float incrementFadeCoeff(long delta) {
        if (this.fadeCoeff == 1.0f) {
            return 1.0f;
        }
        this.fadeCoeff += (float)delta * Config.fadeChangePerNano;
        if (this.fadeCoeff > 1.0f) {
            this.fadeCoeff = 1.0f;
        }
        if (!this.hasRenderedBefore() && !Config.fadeNearPlayer && this.isNearPlayer()) {
            this.fadeCoeff = 1.0f;
        }
        return this.fadeCoeff;
    }

    @Override
    public float[] incrementAnimationOffset(long delta) {
        if (this.animationProgress == 1.0f) {
            return FULLY_ANIMATED_OFFSET;
        }
        this.animationProgress += (float)delta * Config.animationChangePerNano;
        if (this.animationProgress > 1.0f) {
            this.animationProgress = 1.0f;
        }
        if (!this.hasRenderedBefore() && !Config.animateNearPlayer && this.isNearPlayer()) {
            this.animationProgress = 1.0f;
        }
        float progress = Config.animationCurve.calculate(Float.valueOf(this.animationProgress)).floatValue();
        if (Config.animationType == AnimationType.JAGGED) {
            this.offset[1] = MathUtils.lerp(-Config.animationFactor * 16.0f, 0.0f, progress);
        } else if (Config.animationType == AnimationType.DISPLACEMENT || Config.animationType == AnimationType.SCALE) {
            this.offset[1] = MathUtils.lerp(Config.animationFactor, 0.0f, progress);
        } else if (Config.animationAngle == 0.0f) {
            this.offset[1] = MathUtils.lerp(Config.animationOffset, 0.0f, progress);
        } else {
            class_243 thisPos = new class_243((double)(this.chunkX * 16 + 8), 0.0, (double)(this.chunkZ * 16 + 8));
            class_243 camPos = RenderSectionMixin.getCameraPosition();
            camPos = new class_243(camPos.field_1352, 0.0, camPos.field_1350);
            Vector3f direction = camPos.method_46409().sub((Vector3fc)thisPos.method_46409()).normalize();
            Vector3f axis = new Vector3f((Vector3fc)direction).cross((Vector3fc)UP);
            direction.rotateAxis((float)Math.toRadians(90.0f - Config.animationAngle), axis.x, axis.y, axis.z).mul(Config.animationOffset).lerp((Vector3fc)new Vector3f(), progress);
            if (Config.animationOffset > 0.0f) {
                direction.rotateY((float)Math.PI);
            }
            this.offset[0] = direction.x;
            this.offset[1] = direction.y;
            this.offset[2] = direction.z;
        }
        return this.offset;
    }

    @Override
    public long calculateAndGetDelta() {
        long currentFrameTime = System.currentTimeMillis();
        long delta = this.lastFrameTime == 0L ? 0L : currentFrameTime - this.lastFrameTime;
        this.lastFrameTime = currentFrameTime;
        return delta * 1000000L;
    }

    @Override
    public float[] getAnimationOffset() {
        return this.offset;
    }

    @Override
    public float getFadeCoeff() {
        return this.fadeCoeff;
    }

    private boolean isNearPlayer() {
        class_4076 chunkPos = class_4076.method_18680((class_2374)RenderSectionMixin.getCameraPosition());
        int camChunkX = chunkPos.method_10263();
        int camChunkZ = chunkPos.method_10260();
        return MathUtils.chunkInRange(this.chunkX, this.chunkZ, camChunkX, camChunkZ, 1);
    }

    private static class_243 getCameraPosition() {
        class_310 client = class_310.method_1551();
        class_1297 camera = client.field_1719;
        if (camera == null) {
            return new class_243(0.0, 0.0, 0.0);
        }
        return camera.method_19538();
    }
}

