/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.mixin.shader;

import com.koteinik.chunksfadein.core.FadeShader;
import com.koteinik.chunksfadein.core.ShaderInjector;
import com.koteinik.chunksfadein.hooks.CompatibilityHook;
import net.caffeinemc.mods.sodium.client.gl.shader.ShaderLoader;
import net.minecraft.class_2960;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ShaderLoader.class}, remap=false)
public abstract class ShaderLoaderMixin {
    @Inject(method={"getShaderSource"}, at={@At(value="RETURN")}, cancellable=true)
    private static void modifyConstructor(class_2960 name, CallbackInfoReturnable<String> cir) {
        if (CompatibilityHook.isIrisShaderPackInUse()) {
            return;
        }
        String path = name.method_12832();
        String[] splittedPath = path.split("/");
        String shaderFileName = splittedPath[splittedPath.length - 1];
        String source = (String)cir.getReturnValue();
        switch (shaderFileName) {
            case "block_layer_opaque.fsh": {
                source = ShaderLoaderMixin.prepareFragmentInjector().get(source);
                break;
            }
            case "block_layer_opaque.vsh": {
                source = ShaderLoaderMixin.prepareVertexInjector().get(source);
                break;
            }
        }
        cir.setReturnValue((Object)source);
    }

    private static ShaderInjector prepareFragmentInjector() {
        ShaderInjector injector = new ShaderInjector();
        FadeShader shader = new FadeShader();
        injector.insertAfterInVars(shader.fragInVars().dumpMultiline());
        injector.appendToFunction("void main()", shader.fragColorMod("{frag_color}", "u_FogColor").dumpMultiline());
        return injector;
    }

    private static ShaderInjector prepareVertexInjector() {
        ShaderInjector injector = new ShaderInjector();
        FadeShader shader = new FadeShader();
        injector.insertAfterOutVars(shader.vertOutUniforms().dumpMultiline());
        injector.insertAfterVariable("vec3 position", shader.vertMod("_vert_position", "position", false, "{mesh_id}").dumpMultiline());
        return injector;
    }
}

