/*
 * Decompiled with CFR 0.152.
 */
package net.superkat.explosiveenhancement;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_310;
import net.minecraft.class_3486;
import net.minecraft.class_4066;
import net.superkat.explosiveenhancement.ExplosiveEnhancement;
import net.superkat.explosiveenhancement.ExplosiveEnhancementClient;
import net.superkat.explosiveenhancement.api.ExplosionParticleType;

public class ExplosiveHandler {
    public static void spawnParticles(class_1937 world, double x, double y, double z, float power, ExplosionParticleType explosionParticleType, boolean didDestroyBlocks, boolean isImportant) {
        if (ExplosiveEnhancementClient.config.modEnabled) {
            if (ExplosiveEnhancementClient.config.debugLogs) {
                ExplosiveEnhancement.LOGGER.info("ExplosiveHandler has been called!");
                ExplosiveEnhancement.LOGGER.info("Explosive Enhancement Enabled: " + ExplosiveEnhancementClient.config.modEnabled);
                class_4066 particlesMode = (class_4066)class_310.method_1551().field_1690.method_42475().method_41753();
                ExplosiveEnhancement.LOGGER.info("Minecraft particle settings: " + String.valueOf(particlesMode));
                if (particlesMode == class_4066.field_18199) {
                    ExplosiveEnhancement.LOGGER.warn("[Explosive Enhancement]: Minecraft's particle settings is set to Minimal! This means that no explosion particles will be shown.");
                } else if (particlesMode == class_4066.field_18198) {
                    ExplosiveEnhancement.LOGGER.warn("[Explosive Enhancement]: Minecraft's particle settings is set to Decreased! This means that some explosions particles may not always be shown.");
                }
            }
            switch (explosionParticleType) {
                case NORMAL: {
                    ExplosiveHandler.spawnExplosionParticles(world, x, y, z, power, didDestroyBlocks, isImportant);
                    break;
                }
                case WATER: {
                    ExplosiveHandler.spawnUnderwaterExplosionParticles(world, x, y, z, power, didDestroyBlocks, isImportant);
                    break;
                }
                case WIND: {
                    ExplosiveHandler.spawnWindExplosionParticles(world, x, y, z, power, didDestroyBlocks, isImportant);
                }
            }
            if (ExplosiveEnhancementClient.config.debugLogs) {
                ExplosiveEnhancement.LOGGER.info("ExplosiveHandler finished!");
            }
        }
    }

    public static ExplosionParticleType determineParticleType(class_1937 world, double x, double y, double z, class_2394 particle, class_2394 emitterParticle) {
        if (ExplosiveHandler.particlesAreWindGust(particle, emitterParticle)) {
            return ExplosionParticleType.WIND;
        }
        if (ExplosiveEnhancementClient.config.underwaterExplosions && ExplosiveHandler.blockIsInWater(world, x, y, z)) {
            return ExplosionParticleType.WATER;
        }
        return ExplosionParticleType.NORMAL;
    }

    public static boolean blockIsInWater(class_1937 world, double x, double y, double z) {
        class_2338 pos = class_2338.method_49637((double)x, (double)y, (double)z);
        return ExplosiveEnhancementClient.config.underwaterExplosions && world.method_8316(pos).method_15767(class_3486.field_15517);
    }

    public static boolean particlesAreWindGust(class_2394 particle, class_2394 emitterParticle) {
        return particle == class_2398.field_49139 && emitterParticle == class_2398.field_49140;
    }

    public static void spawnExplosionParticles(class_1937 world, double x, double y, double z, float power, boolean didDestroyBlocks, boolean isImportant) {
        power = ExplosiveEnhancementClient.config.dynamicSize ? power : 4.0f;
        y = ExplosiveEnhancementClient.config.attemptBetterSmallExplosions && power == 1.0f ? y + ExplosiveEnhancementClient.config.smallExplosionYOffset : y;
        isImportant = isImportant || ExplosiveEnhancementClient.config.alwaysShow;
        float blastwavePower = power * 1.75f;
        float fireballPower = power * 1.25f;
        float smokePower = power * 0.4f;
        if (ExplosiveEnhancementClient.config.showBlastWave) {
            world.method_8466((class_2394)ExplosiveEnhancement.BLASTWAVE, isImportant, x, y, z, (double)blastwavePower, 0.0, 0.0);
        }
        if (ExplosiveEnhancementClient.config.showFireball) {
            world.method_8466((class_2394)ExplosiveEnhancement.FIREBALL, isImportant, x, y + 0.5, z, (double)fireballPower, isImportant ? 1.0 : 0.0, 0.0);
        } else if (ExplosiveEnhancementClient.config.showSparks) {
            world.method_8466((class_2394)ExplosiveEnhancement.BLANK_FIREBALL, isImportant, x, y + 0.5, z, (double)fireballPower, isImportant ? 1.0 : 0.0, 0.0);
        }
        if (ExplosiveEnhancementClient.config.showMushroomCloud) {
            world.method_8466((class_2394)ExplosiveEnhancement.SMOKE, isImportant, x, y, z, (double)power, (double)power * 0.25, 0.0);
            world.method_8466((class_2394)ExplosiveEnhancement.SMOKE, isImportant, x, y, z, (double)power, (double)smokePower, 0.0);
            world.method_8466((class_2394)ExplosiveEnhancement.SMOKE, isImportant, x, y, z, 0.15, (double)smokePower, (double)power);
            world.method_8466((class_2394)ExplosiveEnhancement.SMOKE, isImportant, x, y, z, -0.15, (double)smokePower, (double)power);
            world.method_8466((class_2394)ExplosiveEnhancement.SMOKE, isImportant, x, y, z, (double)power, (double)smokePower, 0.15);
            world.method_8466((class_2394)ExplosiveEnhancement.SMOKE, isImportant, x, y, z, (double)power, (double)smokePower, -0.15);
        }
        if (ExplosiveEnhancementClient.config.showDefaultExplosion) {
            ExplosiveHandler.spawnVanillaParticles(world, x, y, z, power, didDestroyBlocks, isImportant, false);
        }
    }

    public static void spawnUnderwaterExplosionParticles(class_1937 world, double x, double y, double z, float power, boolean didDestroyBlocks, boolean isImportant) {
        power = ExplosiveEnhancementClient.config.dynamicUnderwater ? power : 4.0f;
        y = ExplosiveEnhancementClient.config.attemptBetterSmallExplosions && power == 1.0f ? y + ExplosiveEnhancementClient.config.smallExplosionYOffset : y;
        isImportant = isImportant || ExplosiveEnhancementClient.config.alwaysShow;
        float blastwavePower = power * 1.75f;
        float fireballPower = power * 1.25f;
        if (ExplosiveEnhancementClient.config.showUnderwaterBlastWave) {
            world.method_8466((class_2394)ExplosiveEnhancement.UNDERWATERBLASTWAVE, isImportant, x, y + 0.5, z, (double)blastwavePower, 0.0, 0.0);
        }
        if (ExplosiveEnhancementClient.config.showShockwave) {
            world.method_8466((class_2394)ExplosiveEnhancement.SHOCKWAVE, isImportant, x, y + 0.5, z, (double)fireballPower, isImportant ? 1.0 : 0.0, 0.0);
        } else if (ExplosiveEnhancementClient.config.showUnderwaterSparks) {
            world.method_8466((class_2394)ExplosiveEnhancement.BLANK_SHOCKWAVE, isImportant, x, y + 0.5, z, (double)fireballPower, isImportant ? 1.0 : 0.0, 0.0);
        }
        for (int total = ExplosiveEnhancementClient.config.bubbleAmount; total >= 1; --total) {
            ExplosiveHandler.spawnBubble(world, x, y, z, isImportant);
        }
        if (ExplosiveEnhancementClient.config.showDefaultExplosionUnderwater) {
            ExplosiveHandler.spawnVanillaParticles(world, x, y, z, power, didDestroyBlocks, isImportant, false);
        }
    }

    private static void spawnBubble(class_1937 world, double x, double y, double z, boolean isImportant) {
        double velX = (double)world.field_9229.method_39332(1, 7) * 0.3 * (double)world.field_9229.method_39332(-1, 1);
        double velY = (double)world.field_9229.method_39332(1, 10) * 0.1;
        double velZ = (double)world.field_9229.method_39332(1, 7) * 0.3 * (double)world.field_9229.method_39332(-1, 1);
        world.method_8466((class_2394)ExplosiveEnhancement.BUBBLE, isImportant, x, y, z, velX, velY, velZ);
    }

    public static void spawnWindExplosionParticles(class_1937 world, double x, double y, double z, float power, boolean didDestroyBlocks, boolean isImportant) {
        ExplosiveHandler.spawnVanillaParticles(world, x, y, z, power, didDestroyBlocks, isImportant, true);
    }

    private static void spawnVanillaParticles(class_1937 world, double x, double y, double z, float power, boolean didDestroyBlocks, boolean isImportant, boolean wind) {
        class_2400 emitter;
        class_2400 particle = wind ? class_2398.field_49139 : class_2398.field_11236;
        class_2400 class_24002 = emitter = wind ? class_2398.field_49140 : class_2398.field_11221;
        if (!(power < 2.0f) && didDestroyBlocks) {
            world.method_8466((class_2394)emitter, isImportant, x, y, z, 1.0, 0.0, 0.0);
        } else {
            world.method_8466((class_2394)particle, isImportant, x, y, z, 1.0, 0.0, 0.0);
        }
    }
}

