/*
 * Decompiled with CFR 0.152.
 */
package mod.lwhrvw.astrocraft;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Scanner;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import mod.lwhrvw.astrocraft.FixedStar;
import mod.lwhrvw.astrocraft.GlobeObserver;
import mod.lwhrvw.astrocraft.MathFuncs;
import mod.lwhrvw.astrocraft.Planet;
import mod.lwhrvw.astrocraft.Star;
import mod.lwhrvw.astrocraft.VersionUtils;
import mod.lwhrvw.astrocraft.config.AstrocraftConfig;
import mod.lwhrvw.astrocraft.meteors.MeteorGenerator;
import mod.lwhrvw.astrocraft.mixin.MixinBiomeAccess;
import mod.lwhrvw.astrocraft.overlays.ConstellationRenderer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1269;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class Astrocraft
implements ModInitializer {
    public static final String MOD_ID = "astrocraft";
    public static final String MOD_NAME = "Astrocraft";
    public static final AstrocraftConfig CONFIG = (AstrocraftConfig)AutoConfig.register(AstrocraftConfig.class, GsonConfigSerializer::new).getConfig();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"astrocraft");
    private static boolean reloadStars = false;
    private static double tropicalAngle = 0.0;
    private static double solarDeclination = 0.0;
    private static double lunarDeclination = 0.0;
    private static double lunarScale = 1.0;
    private static double spyglassZoom = 1.0;
    private static double spyglassBonus = 0.0;
    private static int lastTS = 0;
    private static boolean usingSpyglass = false;
    private static ArrayList<Planet> planets = new ArrayList();
    private static ArrayList<Planet> asteroids = new ArrayList();
    private static Planet observerPlanet;
    private static Planet observer;

    public static void log(Level level, String message) {
        LOGGER.atLevel(level).log("[Astrocraft] {}", (Object)message);
    }

    public static void log(String message) {
        Astrocraft.log(Level.INFO, message);
    }

    public static Planet searchPlanets(String name) {
        if (name.equals("")) {
            return Astrocraft.searchPlanets("Earth");
        }
        for (Planet planet : planets) {
            Planet result = planet.search(name);
            if (result == null) continue;
            return result;
        }
        return Astrocraft.searchPlanets("Earth");
    }

    public static void loadAsteroids(InputStream stream) {
        asteroids.clear();
        try (Scanner scanner = new Scanner(stream);){
            while (scanner.hasNextLine()) {
                String str = scanner.nextLine();
                String[] data = str.split(" ");
                String name = data[0];
                double magn = Double.parseDouble(data[1]) - 1.2;
                double slope = Double.parseDouble(data[2]);
                double diam = Double.parseDouble(data[3]);
                double sma = Double.parseDouble(data[4]);
                double per = Double.parseDouble(data[5]);
                double ecc = Double.parseDouble(data[6]);
                double inc = Double.parseDouble(data[7]);
                Planet asteroid = new Planet(name, magn, diam, Planet.lookupTextureIndex(Planet.Texture.TERRESTIAL), false, new AstrocraftConfig.Color(127, 127, 127, 1.0f), sma, per, inc, ecc, 0.0, false);
                asteroid.setSlope(slope);
                asteroid.setSeed(name.hashCode());
                asteroids.add(asteroid);
            }
            scanner.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            asteroids.clear();
        }
    }

    public static void loadPlanets() {
        planets.clear();
        AstrocraftConfig.ConfigurablePlanet.Appearance app = Astrocraft.CONFIG.sunAppearance;
        Planet sun = new Planet(new AstrocraftConfig.ConfigurablePlanet("Sun", app.magnitude, app.diameter, 1.0E-6, 0.06699520876112251, 0.0, 0.0, 0.0, false, app.color, app.texture, app.rings, app.atmosphere));
        for (AstrocraftConfig.ConfigurablePlanet planet : Astrocraft.CONFIG.planets) {
            sun.addSatellite(new Planet(planet));
        }
        sun.addSatellite(new Planet(new AstrocraftConfig.ConfigurablePlanet("", 4.4, 5.151, 3.09, 5.44, 1.75, 0.33, 0.0, false, new AstrocraftConfig.Color(221, 238, 255, 1.0f), Planet.Texture.COMET, false, null)));
        sun.addSatellite(new Planet(new AstrocraftConfig.ConfigurablePlanet("", 9.7, 5.251, 2.45, 3.84, 11.0, 0.26, 0.0, false, new AstrocraftConfig.Color(221, 238, 255, 1.0f), Planet.Texture.COMET, false, null)));
        sun.addSatellite(new Planet(new AstrocraftConfig.ConfigurablePlanet("", 6.8, 5.351, 2.41, 3.73, 5.96, 0.44, 0.0, false, new AstrocraftConfig.Color(221, 238, 255, 1.0f), Planet.Texture.COMET, false, null)));
        sun.addSatellite(new Planet("Earth", 0.0, 0.0, 0, false, null, 1.0, 1.0, 0.0, 0.0, 23.45, false));
        if (Astrocraft.CONFIG.enableAsteroids) {
            for (Planet asteroid : asteroids) {
                sun.addSatellite(asteroid);
            }
        }
        planets.add(sun);
        FixedStar prox = new FixedStar("Proxima Centauri", 15.6, 686560.0, 217.42893, -61.32051, 268550.5897872974, new AstrocraftConfig.Color(255, 123, 47, 1.0f));
        prox.addSatellite(new Planet(new AstrocraftConfig.ConfigurablePlanet("Proxima Centauri d", -2.5, 10321.02, 0.02885, 0.014023271731690623, 1.21, 0.04, 4.6, false, new AstrocraftConfig.Color(255, 255, 255, 1.0f), Planet.Texture.TERRESTIAL, false, Planet.Atmosphere.NONE)));
        prox.addSatellite(new Planet(new AstrocraftConfig.ConfigurablePlanet("Proxima Centauri b", -3.3, 16564.62, 0.04857, 0.030620616016427103, 0.29, 0.109, 18.3, false, new AstrocraftConfig.Color(215, 207, 255, 1.0f), Planet.Texture.TERRESTIAL, false, Planet.Atmosphere.NORMAL)));
        prox.addSatellite(new Planet(new AstrocraftConfig.ConfigurablePlanet("Proxima Centauri c", -6.0, 18972.84, 1.489, -5.278576317590692, 47.0, 0.04, 69.0, false, new AstrocraftConfig.Color(159, 207, 255, 1.0f), Planet.Texture.BANDED, true, Planet.Atmosphere.THICK)));
        planets.add(prox);
        Astrocraft.loadObserver();
    }

    public static boolean shouldReloadStars() {
        class_310 client = class_310.method_1551();
        class_638 world = client.field_1687;
        long time = 0L;
        if (world != null) {
            time = Astrocraft.getWorldTime();
        }
        int ts = ((int)time + Astrocraft.CONFIG.updateOffset) / Astrocraft.CONFIG.updateTime;
        if (reloadStars) {
            reloadStars = false;
            return true;
        }
        if (Astrocraft.isUsingSpyglass() != usingSpyglass) {
            usingSpyglass = Astrocraft.isUsingSpyglass();
            return true;
        }
        if (ts != lastTS) {
            lastTS = ts;
            return true;
        }
        return Star.cameraShouldReload();
    }

    public static void loadObserver() {
        observer = observerPlanet = Astrocraft.searchPlanets(Astrocraft.CONFIG.observerPlanet);
        if (Astrocraft.CONFIG.globeMode) {
            observer = new GlobeObserver(Astrocraft.getGlobeAltitude(), Astrocraft.getGlobeLongitude(), Astrocraft.getGlobeLatitude());
            observerPlanet.addSatellite(observer);
        }
    }

    public static void loadRenderData() {
        Astrocraft.loadObserver();
        Astrocraft.calcTropicalAngle();
        Astrocraft.calcSpyglassZoom();
        Astrocraft.calcSpyglassMagnitudeBonus();
        Astrocraft.getSolarDeclination();
        Astrocraft.getLunarDeclination();
        Astrocraft.getLunarScale();
        Star.setCameraPoint();
        Star.initRenderer();
        if (Astrocraft.CONFIG.enableMeteors && MeteorGenerator.shouldGenForNight()) {
            MeteorGenerator.genForNight();
        }
    }

    public void loadConfigData() {
        Star.loadCustomStars();
        Astrocraft.loadPlanets();
        if (Astrocraft.CONFIG.enableMeteors) {
            MeteorGenerator.genForNight();
        }
    }

    public void onInitialize() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                return class_2960.method_60655((String)Astrocraft.MOD_ID, (String)"stardataloader");
            }

            public void method_14491(class_3300 manager) {
                InputStream stream2;
                try {
                    stream2 = manager.open(class_2960.method_60655((String)Astrocraft.MOD_ID, (String)"stars"));
                    try {
                        Star.loadFixedStars(stream2);
                    }
                    finally {
                        if (stream2 != null) {
                            stream2.close();
                        }
                    }
                }
                catch (Exception stream2) {
                    // empty catch block
                }
                try {
                    stream2 = manager.open(class_2960.method_60655((String)Astrocraft.MOD_ID, (String)"constellations.txt"));
                    try {
                        ConstellationRenderer.loadConstellations(stream2);
                    }
                    finally {
                        if (stream2 != null) {
                            stream2.close();
                        }
                    }
                }
                catch (Exception stream3) {
                    // empty catch block
                }
                try {
                    stream2 = manager.open(class_2960.method_60655((String)Astrocraft.MOD_ID, (String)"asteroids.txt"));
                    try {
                        Astrocraft.loadAsteroids(stream2);
                    }
                    finally {
                        if (stream2 != null) {
                            stream2.close();
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        AutoConfig.getConfigHolder(AstrocraftConfig.class).registerSaveListener((manager, data) -> {
            this.loadConfigData();
            reloadStars = true;
            return class_1269.field_5812;
        });
        this.loadConfigData();
        Astrocraft.loadRenderData();
    }

    public static class_638 getWorld() {
        class_310 client = class_310.method_1551();
        return client.field_1687;
    }

    public static long getWorldTime() {
        class_638 world = Astrocraft.getWorld();
        if (world == null) {
            return 0L;
        }
        return world.method_8532();
    }

    public static float getClearness() {
        return 1.0f - Astrocraft.getWorld().method_8430(0.0f);
    }

    public static float getVisibility() {
        double starBrightness = VersionUtils.getStarBrightness();
        return (float)((double)Astrocraft.getClearness() * MathFuncs.clamp(starBrightness * 2.0, 0.5, 1.0));
    }

    public static float getDeepskyVisibility() {
        double v = 2.0f * Math.max(0.0f, Astrocraft.getVisibility() - 0.5f * (1.0f - 0.0f * Astrocraft.getSpaceMultiplier()));
        double b = MathFuncs.pow(v, 6.0);
        if (Astrocraft.isUsingSpyglass()) {
            b /= 1.61;
        }
        return (float)MathFuncs.clamp(b / 2.0 - 0.08, 0.0, 1.0);
    }

    public static double getLatitude() {
        if (!Astrocraft.CONFIG.angledSky) {
            return 0.0;
        }
        if (Astrocraft.CONFIG.globeMode) {
            return Astrocraft.getGlobeLatitude();
        }
        double latitude = Astrocraft.CONFIG.latitude;
        if (latitude > 90.0 || latitude < -90.0) {
            class_310 client = class_310.method_1551();
            if (client.field_1724 != null) {
                latitude = 90.0 * client.field_1724.method_23321() / latitude;
            }
        }
        return latitude;
    }

    public static double calcTropicalAngle() {
        tropicalAngle = MathFuncs.mod(-Astrocraft.getObserver().getSolarAngle(), 360.0);
        return tropicalAngle;
    }

    public static double getTropicalAngle() {
        return tropicalAngle;
    }

    public static double getObliquity() {
        return Astrocraft.getObserver().getObliquity();
    }

    public static double getEclipticDeclination(double sunOffset) {
        if (!Astrocraft.CONFIG.angledSky) {
            return 0.0;
        }
        return -Astrocraft.getObliquity() * Math.sin(Math.toRadians(Astrocraft.getTropicalAngle() - sunOffset));
    }

    public static double getSolarDeclination() {
        solarDeclination = Astrocraft.getEclipticDeclination(0.0);
        return solarDeclination;
    }

    public static double getSolarDeclinationCached() {
        return solarDeclination;
    }

    public static double getSolarHourAngle(class_638 world, float tickDelta) {
        return (double)world.method_30274(tickDelta) * 360.0;
    }

    public static double getSolarHourAngle() {
        class_638 world = Astrocraft.getWorld();
        if (world != null) {
            return Astrocraft.getSolarHourAngle(world, 0.0f);
        }
        return 0.0;
    }

    public static float getSolarAltitude(class_638 world, float tickDelta) {
        double ha = (double)world.method_30274(tickDelta) * Math.PI * 2.0;
        double dec = Math.toRadians(Astrocraft.getSolarDeclination());
        double lat = Math.toRadians(Astrocraft.getLatitude());
        double alt = Math.asin(Math.sin(lat) * Math.sin(dec) + Math.cos(lat) * Math.cos(dec) * Math.cos(ha)) / Math.PI / 2.0;
        return (float)alt - 0.25f;
    }

    public static float getLunarAltitude(class_638 world, float tickDelta) {
        double ha = (double)world.method_30274(tickDelta) * Math.PI * 2.0 + Math.toRadians(Astrocraft.getPhaseAngle() + 180.0);
        double dec = Math.toRadians(Astrocraft.getLunarDeclination());
        double lat = Math.toRadians(Astrocraft.getLatitude());
        double alt = Math.asin(Math.sin(lat) * Math.sin(dec) + Math.cos(lat) * Math.cos(dec) * Math.cos(ha)) / Math.PI / 2.0;
        return (float)alt - 0.25f;
    }

    public static float getSolarUneclipsed() {
        if (!(Astrocraft.CONFIG.legacyMoonOptions.enableEclipses && Astrocraft.CONFIG.legacyMoonOptions.enableMovement && Astrocraft.CONFIG.angledSky)) {
            return 1.0f;
        }
        double phaseAngle = (360.0 - Astrocraft.getPhaseAngle()) % 360.0;
        double relAngle = Astrocraft.getLunarRelative();
        float disp = (float)Math.abs(phaseAngle - 180.0) + (float)Math.abs(relAngle);
        float eclipseAngle = (float)((double)1.38f * Astrocraft.getLunarScale());
        return class_3532.method_15363((float)(disp / eclipseAngle), (float)0.0f, (float)1.0f);
    }

    public static float getLunarUneclipsed() {
        if (!(Astrocraft.CONFIG.legacyMoonOptions.enableEclipses && Astrocraft.CONFIG.legacyMoonOptions.enableMovement && Astrocraft.CONFIG.angledSky)) {
            return 1.0f;
        }
        double phaseAngle = (360.0 - Astrocraft.getPhaseAngle()) % 360.0;
        double relAngle = Astrocraft.getLunarRelative();
        float disp = (float)Math.min(phaseAngle, 360.0 - phaseAngle) + (float)Math.abs(relAngle);
        float eclipseAngle = (float)((double)4.7f / Astrocraft.getLunarScale());
        return class_3532.method_15363((float)(disp / eclipseAngle), (float)0.0f, (float)1.0f);
    }

    public static long getLunarTime() {
        class_310 client = class_310.method_1551();
        long lunarTime = 0L;
        if (client.field_1687 != null) {
            lunarTime = client.field_1687.method_30271();
        }
        return lunarTime;
    }

    public static double getTimeAngle(double years) {
        return 360.0 * (double)Astrocraft.getWorldTime() / 24000.0 / years / Astrocraft.CONFIG.yearLength;
    }

    public static double getTimeAngle(double years, double startAngle) {
        return Astrocraft.getTimeAngle(years) + startAngle;
    }

    public static double getLunarAngle(double mult) {
        double monthLength = Astrocraft.CONFIG.legacyMoonOptions.monthLength;
        if (monthLength < 1.0E-6) {
            monthLength = 9999999.0;
        }
        return -360.0 * (double)(Astrocraft.getLunarTime() - 18000L) / 24000.0 * mult / Astrocraft.CONFIG.legacyMoonOptions.monthLength;
    }

    public static double getPhaseAngle() {
        if (!Astrocraft.CONFIG.legacyMoonOptions.enableMovement) {
            return 0.0;
        }
        double SYNODIC_MULT = 1.0;
        return Astrocraft.getLunarAngle(1.0);
    }

    public static double getLightPhaseAngle() {
        double SYNODIC_MULT = 1.0;
        return Astrocraft.getLunarAngle(1.0);
    }

    public static double getLunarDeclination() {
        lunarDeclination = Astrocraft.getEclipticDeclination(Astrocraft.getPhaseAngle()) + Astrocraft.getLunarRelative();
        return lunarDeclination;
    }

    public static double getLunarDeclinationCached() {
        return lunarDeclination;
    }

    public static double getDraconicAngle() {
        double DRACONIC_MULT = 1.0852019153813806;
        return Astrocraft.getLunarAngle(1.0852019153813806) + Astrocraft.getRandomAngle(1.0852019153813806);
    }

    public static double getLunarRelative() {
        return Astrocraft.CONFIG.legacyMoonOptions.moonInclination * Math.sin(Math.toRadians(Astrocraft.getDraconicAngle()));
    }

    public static double getApsisAngle() {
        double ANOMALISTIC_MULT = 1.0717136089730723;
        return Astrocraft.getLunarAngle(1.0717136089730723) + Astrocraft.getRandomAngle(1.0717136089730723);
    }

    public static double getLunarScale() {
        lunarScale = 1.0 + 0.07 * Math.sin(Math.toRadians(Astrocraft.getApsisAngle()));
        return lunarScale;
    }

    public static double getLunarScaleCached() {
        return lunarScale;
    }

    public static boolean isUsingSpyglass() {
        class_310 client = class_310.method_1551();
        return client.field_1724 != null && client.field_1690.method_31044().method_31034() && client.field_1724.method_31550();
    }

    public static double getSpyglassZoom() {
        return spyglassZoom;
    }

    public static double calcSpyglassZoom() {
        if (!Astrocraft.isUsingSpyglass()) {
            spyglassZoom = 1.0;
            return 1.0;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            spyglassZoom = 1.0;
            return 1.0;
        }
        spyglassZoom = 1.0 / (double)client.field_1724.method_3118();
        return spyglassZoom;
    }

    public static double getCameraPitch() {
        class_310 client = class_310.method_1551();
        return client.method_1560().method_36455();
    }

    public static double getMood() {
        class_310 client = class_310.method_1551();
        return client.field_1724.method_26269() / 100.0f;
    }

    public static double getSpyglassMagnitudeBonus() {
        if (Astrocraft.CONFIG.disableSpyglassMagnitudeBonus || !Astrocraft.isUsingSpyglass()) {
            return 0.0;
        }
        return spyglassBonus;
    }

    public static double calcSpyglassMagnitudeBonus() {
        if (Astrocraft.CONFIG.disableSpyglassMagnitudeBonus || !Astrocraft.isUsingSpyglass()) {
            return 0.0;
        }
        double bonus = 2.0;
        bonus += 2.0 * Astrocraft.getSubSpaceMultiplier();
        spyglassBonus = Math.max(0.0, bonus -= 2.0 * MathFuncs.sin(Astrocraft.getCameraPitch()));
        return spyglassBonus;
    }

    public static double getMagnitudeLimit() {
        return (double)Astrocraft.CONFIG.magnitudeLimit + 0.2;
    }

    public static List<Planet> getPlanets() {
        return planets;
    }

    public static Planet getObserverPlanet() {
        return observerPlanet;
    }

    public static Planet getObserver() {
        return observer;
    }

    public static long getSeed() {
        class_310 client = class_310.method_1551();
        class_638 world = client.field_1687;
        if (world == null) {
            return 0L;
        }
        if (Astrocraft.CONFIG.useWorldSeed) {
            return ((MixinBiomeAccess)world.method_22385()).getSeed();
        }
        return "    ".hashCode();
    }

    public static double getRandomAngle(long seed) {
        Random rand = new Random(Astrocraft.getSeed() + seed);
        return rand.nextDouble() * 360.0;
    }

    public static double getRandomAngle(double seed) {
        return Astrocraft.getRandomAngle((long)(seed * 741611.9));
    }

    public static double getGlobeLongitude() {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return 0.0;
        }
        double angle = 90.0 * (client.field_1724.method_23317() - Astrocraft.CONFIG.earthGlobe.meridianX) / Astrocraft.CONFIG.earthGlobe.blocks90 * Astrocraft.getObserverPlanet().getGlobeMultiplier();
        if (Astrocraft.getFromNorth() > 180.0) {
            return MathFuncs.mod(angle + 180.0, 360.0);
        }
        return MathFuncs.mod(angle, 360.0);
    }

    public static double getFromNorth() {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return 0.0;
        }
        double angle = 90.0 * (client.field_1724.method_23321() - Astrocraft.CONFIG.earthGlobe.equatorZ) / Astrocraft.CONFIG.earthGlobe.blocks90 * Astrocraft.getObserverPlanet().getGlobeMultiplier();
        return MathFuncs.mod(angle + 90.0, 360.0);
    }

    public static double getGlobeLatitude() {
        double fromNorth = Astrocraft.getFromNorth();
        if (fromNorth > 180.0) {
            return 270.0 - fromNorth;
        }
        return fromNorth - 90.0;
    }

    public static double getGlobeAltitude() {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return 0.0;
        }
        double altKm = Astrocraft.getObserverPlanet().getDiameter() + (client.field_1724.method_23318() - 64.0) / Astrocraft.CONFIG.earthGlobe.blocks90 / 4.0 * Math.PI * 12742.0;
        return altKm * 6.6846E-9;
    }

    public static boolean isInDome() {
        double dz;
        double dy;
        class_310 client = class_310.method_1551();
        double y = client.field_1724.method_23318();
        if (y < 73.0 || y > 84.0) {
            return false;
        }
        double x = client.field_1724.method_23317();
        double z = client.field_1724.method_23321();
        double dx = Math.abs(x - 20531.5);
        double dist = dx * dx + (dy = Math.abs(y - 74.5)) * dy + (dz = Math.abs(z - 403.5)) * dz;
        return dist < 52.5625;
    }

    public static double getSubSpaceMultiplier() {
        class_310 client = class_310.method_1551();
        class_638 world = client.field_1687;
        double y = client.field_1724.method_23318();
        double top = world.method_31600();
        double bottom = world.method_31607();
        double height = top - bottom;
        return MathFuncs.clamp((y - bottom) / height, 0.0, 1.0);
    }

    public static float getSpaceMultiplier() {
        class_310 client = class_310.method_1551();
        if (Astrocraft.isInDome()) {
            return 1.0f;
        }
        int start = Astrocraft.CONFIG.spaceStart;
        double y = client.field_1724.method_23318();
        double h = MathFuncs.max(0.0, (y - (double)start) / (double)Astrocraft.CONFIG.spaceHeight);
        return (float)MathFuncs.clamp(MathFuncs.sqrt(h), 0.0, 1.0);
    }
}

