/*
 * Decompiled with CFR 0.152.
 */
package mod.lwhrvw.astrocraft;

import mod.lwhrvw.astrocraft.Planet;
import mod.lwhrvw.astrocraft.config.AstrocraftConfig;

public class FixedStar
extends Planet {
    public double ra;
    public double de;
    public double dist;

    public FixedStar(String name, double absMagn, double diam, double ra, double de, double dist, AstrocraftConfig.Color color) {
        super(name, absMagn, diam, 6, false, color, dist, 24.0, 0.0, 0.0, 0.0, false);
        double OB = -23.43928;
        ra = 180.0 - ra;
        this.ra = FixedStar.atan2(FixedStar.sin(ra) * FixedStar.cos(-23.43928) + FixedStar.tan(de) * FixedStar.sin(-23.43928), FixedStar.cos(ra));
        this.de = FixedStar.asin(FixedStar.sin(de) * FixedStar.cos(-23.43928) + FixedStar.cos(de) * FixedStar.sin(-23.43928) * FixedStar.sin(ra));
        this.dist = dist;
    }

    @Override
    public boolean isStar() {
        return true;
    }

    @Override
    public double getOrbitalAngle() {
        return this.ra;
    }

    @Override
    public double getEffectiveInclination() {
        return this.de;
    }

    @Override
    public double getOrbitalDistance() {
        return this.dist;
    }
}

