/*
 * Decompiled with CFR 0.152.
 */
package mod.lwhrvw.astrocraft;

import java.util.Random;

public class MathFuncs {
    public static double toRadians(double angle) {
        return Math.toRadians(angle);
    }

    public static double toDegrees(double angle) {
        return Math.toDegrees(angle);
    }

    public static float toRadians(float angle) {
        return angle / 360.0f * 2.0f * (float)Math.PI;
    }

    public static double sin(double angle) {
        return Math.sin(Math.toRadians(angle));
    }

    public static double cos(double angle) {
        return Math.cos(Math.toRadians(angle));
    }

    public static double tan(double angle) {
        return Math.tan(Math.toRadians(angle));
    }

    public static double asin(double value) {
        return Math.toDegrees(Math.asin(value));
    }

    public static double acos(double value) {
        return Math.toDegrees(Math.acos(value));
    }

    public static double atan(double value) {
        return Math.toDegrees(Math.atan(value));
    }

    public static double atan2(double y, double x) {
        return Math.toDegrees(Math.atan2(y, x));
    }

    public static double log10(double value) {
        return Math.log10(value);
    }

    public static double pow(double value, double power) {
        return Math.pow(value, power);
    }

    public static double square(double value) {
        return value * value;
    }

    public static double sqrt(double value) {
        return Math.sqrt(value);
    }

    public static double cbrt(double value) {
        return Math.cbrt(value);
    }

    public static double abs(double value) {
        return Math.abs(value);
    }

    public static double sign(double value) {
        return value > 0.0 ? 1.0 : (value < 1.0 ? -1.0 : 0.0);
    }

    public static double mod(double value, double div) {
        return (value % div + div) % div;
    }

    public static double max(double a, double b) {
        return Math.max(a, b);
    }

    public static double min(double a, double b) {
        return Math.min(a, b);
    }

    public static float max(float a, float b) {
        return Math.max(a, b);
    }

    public static float min(float a, float b) {
        return Math.min(a, b);
    }

    public static double clamp(double value, double min, double max) {
        if (value > max) {
            return max;
        }
        if (value < min) {
            return min;
        }
        return value;
    }

    public static int clamp(int value, int min, int max) {
        if (value > max) {
            return max;
        }
        if (value < min) {
            return min;
        }
        return value;
    }

    public static double randCoord(Random rand) {
        return rand.nextDouble() * 2.0 - 1.0;
    }

    public static double cra(double h, double m, double s) {
        return MathFuncs.cra(h, m) + s / 240.0;
    }

    public static double cra(double h, double m) {
        return MathFuncs.cra(h) + m / 4.0;
    }

    public static double cra(double h) {
        return h * 15.0;
    }

    public static double cdeg(double deg, double arcmin, double arcsec, double mas) {
        return MathFuncs.cdeg(deg, arcmin, arcsec) + mas / 3600000.0;
    }

    public static double cdeg(double deg, double arcmin, double arcsec) {
        return MathFuncs.cdeg(deg, arcmin) + arcsec / 3600.0;
    }

    public static double cdeg(double deg, double arcmin) {
        return MathFuncs.cdeg(deg) + arcmin / 60.0;
    }

    public static double cdeg(double deg) {
        return deg;
    }
}

