/*
 * Decompiled with CFR 0.152.
 */
package mod.lwhrvw.astrocraft;

import java.util.ArrayList;
import java.util.List;
import mod.lwhrvw.astrocraft.Astrocraft;
import mod.lwhrvw.astrocraft.MathFuncs;
import mod.lwhrvw.astrocraft.Star;
import mod.lwhrvw.astrocraft.config.AstrocraftConfig;

public class Planet
extends MathFuncs {
    private static final AstrocraftConfig CONFIG = Astrocraft.CONFIG;
    private String name = "";
    private double absMagnitude;
    private double diameter;
    private double semiMajorAxis;
    protected double orbitalPeriod;
    private double inclination;
    private double eccentricity;
    private double obliquity;
    private boolean equatorial = false;
    private int textureIndex;
    private double slope;
    private boolean rings;
    private AstrocraftConfig.Color color;
    private ArrayList<Planet> satellites = new ArrayList();
    private Planet primary = null;
    private int seed = 1;
    private boolean isComet = false;
    private boolean isStar = false;
    private Atmosphere atmosphere;

    public Planet(String pname, double magn, double diam, int ti, boolean r, AstrocraftConfig.Color clr, double sma, double period, double inc, double ecc, double obl, boolean equ) {
        this.name = pname;
        this.absMagnitude = magn;
        this.diameter = diam;
        this.textureIndex = ti;
        this.slope = 0.0;
        this.rings = r;
        this.semiMajorAxis = sma;
        this.orbitalPeriod = period;
        this.inclination = inc;
        this.eccentricity = ecc;
        this.obliquity = obl;
        this.equatorial = equ;
        this.color = clr;
        if (this.diameter < 1.0E-6) {
            this.diameter = this.getDiameterEstimate();
        }
    }

    public void addSatellite(Planet planet) {
        this.satellites.add(planet);
        planet.setPrimary(this);
    }

    public void setPrimary(Planet planet) {
        this.primary = planet;
    }

    public Planet getPrimary() {
        return this.primary;
    }

    public void setSlope(double slope) {
        this.slope = slope;
    }

    public static int lookupTextureIndex(Texture text) {
        switch (text.ordinal()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 0;
            }
            case 6: {
                return 5;
            }
            case 7: {
                return 6;
            }
            case 8: {
                return 7;
            }
        }
        return 0;
    }

    public Planet(AstrocraftConfig.ConfigurablePlanet planet) {
        this(planet.name, planet.appearance.magnitude, planet.appearance.diameter, 0, planet.appearance.rings, planet.appearance.color, planet.orbit.semiMajorAxis, planet.orbit.period, planet.orbit.inclination, planet.orbit.eccentricity, planet.orbit.obliquity, planet.orbit.equatorial);
        this.textureIndex = Planet.lookupTextureIndex(planet.appearance.texture);
        if (planet.appearance.texture == Texture.COMET) {
            this.isComet = true;
        }
        if (planet.appearance.texture == Texture.SUN || planet.appearance.texture == Texture.STAR) {
            this.isStar = true;
        }
        if (planet.appearance.atmosphere == null) {
            switch (planet.appearance.texture.ordinal()) {
                case 4: {
                    this.atmosphere = Atmosphere.NORMAL;
                    break;
                }
                case 3: {
                    this.atmosphere = Atmosphere.THICK;
                    break;
                }
                default: {
                    this.atmosphere = Atmosphere.NONE;
                    break;
                }
            }
        } else {
            this.atmosphere = planet.appearance.atmosphere;
        }
        for (AstrocraftConfig.ConfigurablePlanet satellite : planet.moons) {
            Planet newSat = new Planet(satellite);
            if (Planet.CONFIG.bigPlanets && satellite.appearance.texture != Texture.MOON) {
                newSat.semiMajorAxis *= 25.0;
            }
            this.addSatellite(newSat);
        }
        this.seed = planet.seed;
    }

    public Planet search(String pname) {
        if (this.name.equals(pname)) {
            return this;
        }
        for (Planet satellite : this.satellites) {
            Planet result = satellite.search(pname);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public double getSemiMajorAxis() {
        return this.semiMajorAxis;
    }

    public double getOrbitalPeriod() {
        return this.orbitalPeriod;
    }

    public AstrocraftConfig.Color getColor() {
        return this.color;
    }

    public List<Planet> getSatellites() {
        return this.satellites;
    }

    public void setSeed(int seed) {
        this.seed = seed;
    }

    public double getStartAngle() {
        if (this.name.equals("Earth") || this.name.equals("Moon")) {
            return 0.0;
        }
        return Astrocraft.getRandomAngle(this.seed);
    }

    public double getStartAngle(double mult) {
        if (this.name.equals("Earth") || this.name.equals("Moon")) {
            return Planet.CONFIG.seasonOffset;
        }
        return Astrocraft.getRandomAngle(Double.hashCode(mult) + this.seed);
    }

    private double getAngle(double mult) {
        return Planet.mod(Astrocraft.getTimeAngle(this.orbitalPeriod) * mult + this.getStartAngle(mult), 360.0);
    }

    private double getMeanAnomaly() {
        if (this.name.equals("Earth")) {
            return this.getAngle(1.0);
        }
        return this.getAngle(0.9915480988452536);
    }

    private double getLongPeriapsis() {
        if (this.name.equals("Earth")) {
            return 0.0;
        }
        return -this.getAngle(0.008451901154746366);
    }

    private double getEccentricity() {
        return this.eccentricity > 1.0E-6 ? this.eccentricity : 1.0E-6;
    }

    private double getEccentricAnomaly(double meanAnomaly) {
        double M = Planet.toRadians(Planet.mod(Planet.mod(meanAnomaly, 360.0) + 180.0, 360.0) - 180.0);
        double E = Planet.abs(M);
        for (int i = 0; i < 32; ++i) {
            double change = (E - this.getEccentricity() * Math.sin(E) - Planet.abs(M)) / (1.0 - this.getEccentricity() * Math.cos(E));
            E -= change;
            if (Planet.abs(change) < 1.0E-8) break;
        }
        if (M >= 0.0) {
            return Planet.toDegrees(E);
        }
        return 360.0 - Planet.toDegrees(E);
    }

    private double getEccentricAnomaly() {
        return this.getEccentricAnomaly(this.getMeanAnomaly());
    }

    private double getTrueAnomaly(double eccAnomaly) {
        double b = this.getEccentricity() / (1.0 + Planet.sqrt(1.0 - this.getEccentricity() * this.getEccentricity()));
        return eccAnomaly + 2.0 * (360.0 + Planet.atan2(b * Planet.sin(eccAnomaly), 1.0 - b * Planet.cos(eccAnomaly))) % 360.0;
    }

    private double getTrueAnomaly() {
        return this.getTrueAnomaly(this.getEccentricAnomaly());
    }

    public double getOrbitalAngle() {
        return Planet.mod(this.getLongPeriapsis() - this.getTrueAnomaly(), 360.0);
    }

    public double getOrbitalDistance() {
        return this.getSemiMajorAxis() * (1.0 - this.getEccentricity() * Planet.cos(this.getEccentricAnomaly()));
    }

    public double getOrbitalRadius() {
        return this.getOrbitalDistance() * Planet.cos(this.getEffectiveInclination());
    }

    public double getEffectiveInclination() {
        Planet primary = this.getPrimary();
        double equatorial = primary != null && this.isEquatorial() ? -primary.getObliquity() * Planet.sin(this.getOrbitalAngle()) : 0.0;
        return equatorial - this.inclination * Planet.sin(this.getAngle(1.004021749630213));
    }

    public double getOrbitalHeight() {
        return this.getOrbitalDistance() * Planet.sin(this.getEffectiveInclination());
    }

    double getAngleDifference(double angle, double primaryAngle) {
        return 360.0 - Planet.mod(angle - primaryAngle + 180.0, 360.0);
    }

    public double getAngleBetween(double angle, double radius, double primaryAngle, double primaryRadius) {
        double threshold;
        double angleDif = this.getAngleDifference(angle, primaryAngle);
        double relAngle = Planet.asin(Planet.sin(angleDif) * radius / this.getDistanceBetween(angle, radius, primaryAngle, primaryRadius));
        if (radius > primaryRadius && (angleDif < (threshold = Planet.acos(primaryRadius / radius)) || angleDif > 360.0 - threshold)) {
            return primaryAngle + 180.0 - relAngle;
        }
        return primaryAngle + relAngle;
    }

    public double getDistanceBetween(double angle, double radius, double primaryAngle, double primaryRadius) {
        double angleDif = this.getAngleDifference(angle, primaryAngle);
        return Planet.sqrt(radius * radius + primaryRadius * primaryRadius - 2.0 * radius * primaryRadius * Planet.cos(angleDif));
    }

    public double getSolarAngle(double primaryAngle, double primaryRadius) {
        return this.getAngleBetween(this.getOrbitalAngle(), this.getOrbitalRadius(), primaryAngle, primaryRadius);
    }

    public double getSolarRadius(double primaryAngle, double primaryRadius) {
        return this.getDistanceBetween(this.getOrbitalAngle(), this.getOrbitalRadius(), primaryAngle, primaryRadius);
    }

    public double getSolarAngle() {
        if (this.primary == null) {
            return this.getOrbitalAngle();
        }
        return this.getSolarAngle(this.primary.getSolarAngle(), this.primary.getSolarRadius());
    }

    public double getSolarRadius() {
        if (this.primary == null) {
            return this.getOrbitalRadius();
        }
        return this.getSolarRadius(this.primary.getSolarAngle(), this.primary.getSolarRadius());
    }

    public double getSolarHeight() {
        if (this.primary == null) {
            return this.getOrbitalHeight();
        }
        return this.getOrbitalHeight() + this.primary.getSolarHeight();
    }

    public double getSolarDistance() {
        double radius = this.getSolarRadius();
        double height = this.getSolarHeight();
        return Planet.sqrt(radius * radius + height * height);
    }

    public double getRightAscension(double obsSolarAngle, double obsSolarRadius) {
        return 360.0 - Planet.mod(this.getAngleBetween(this.getSolarAngle(), this.getSolarRadius(), obsSolarAngle + 180.0, obsSolarRadius) - obsSolarAngle - 180.0, 360.0);
    }

    public double getDistance(double obsSolarAngle, double obsSolarRadius) {
        return this.getDistanceBetween(this.getSolarAngle(), this.getSolarRadius(), obsSolarAngle + 180.0, obsSolarRadius);
    }

    public double getDistance(double obsSolarAngle, double obsSolarRadius, double obsSolarHeight) {
        double radius = this.getDistance(obsSolarAngle, obsSolarRadius);
        double relHeight = this.getSolarHeight() - obsSolarHeight;
        return Planet.sqrt(radius * radius + relHeight * relHeight);
    }

    public double getInclination(double obsSolarHeight, double obsDistance) {
        double relHeight = this.getSolarHeight() - obsSolarHeight;
        return Planet.atan2(relHeight, obsDistance);
    }

    public double getPhase(double obsSolarAngle, double obsSolarRadius) {
        double solarRadius = this.getSolarRadius();
        double distance = this.getDistance(obsSolarAngle, obsSolarRadius);
        return Planet.acos((distance * distance + solarRadius * solarRadius - obsSolarRadius * obsSolarRadius) / (2.0 * distance * solarRadius));
    }

    public double getVenusPhaseIntegral(double phase) {
        if (phase > 163.7) {
            return 240.44228 - 2.81914 * phase + 8.39034 * (phase * phase / 1000.0);
        }
        return -1.044 * phase / 1000.0 + 3.687 * phase * phase / 10000.0 - 2.814 * phase * phase * phase / 1000000.0 + 8.938 * phase * phase * phase * phase / 1.0E9;
    }

    public double getDiffusePhaseIntegral(double phase) {
        return -2.5 * Planet.log10(0.6666666666666666 * ((1.0 - phase / 180.0) * Planet.cos(phase) + Planet.sin(phase) / Math.PI));
    }

    public double getMercuryPhaseIntegral(double phase) {
        return 0.06328 * phase - 0.0016336 * phase * phase + 3.3644E-5 * phase * phase * phase - 3.4265E-7 * phase * phase * phase * phase + 1.6893E-9 * phase * phase * phase * phase * phase - 3.0334E-12 * phase * phase * phase * phase * phase * phase;
    }

    public double getAsteroidPhaseIntegral(double phase) {
        double p1 = Math.exp(-3.332 * Planet.pow(Planet.tan(phase / 2.0), 0.631));
        double p2 = Math.exp(-1.862 * Planet.pow(Planet.tan(phase / 2.0), 1.218));
        double q = (1.0 - this.slope) * p1 + this.slope * p2;
        return -2.5 * Planet.log10(q);
    }

    public double getPhaseIntegral(double phase) {
        if (this.slope > 1.0E-6) {
            return this.getAsteroidPhaseIntegral(phase);
        }
        if (this.textureIndex == 1) {
            return this.getMercuryPhaseIntegral(phase);
        }
        if (this.textureIndex == 2) {
            return this.getMercuryPhaseIntegral(phase);
        }
        return this.getVenusPhaseIntegral(phase);
    }

    public double getCometMagnitude(double obsSolarAngle, double obsSolarRadius, double obsSolarHeight) {
        return this.absMagnitude - 10.0 + 10.0 * Planet.log10(this.getSolarDistance()) + 5.0 * Planet.log10(this.getDistance(obsSolarAngle, obsSolarRadius, obsSolarHeight));
    }

    public double getApparentMagnitude(double obsSolarAngle, double obsSolarRadius, double obsSolarHeight) {
        if (this.isStar()) {
            return this.absMagnitude - 5.0 + 5.0 * Planet.log10(this.getDistance(obsSolarAngle, obsSolarRadius, obsSolarHeight) / 206300.0);
        }
        double apparentMagn = this.absMagnitude;
        if (this.textureIndex != 1 && this.textureIndex != 5 && Planet.CONFIG.bigPlanets) {
            apparentMagn -= 3.4;
        }
        Planet sun = this.getSun();
        double sunDist = this.getDistance(sun.getSolarAngle(), sun.getSolarRadius(), sun.getSolarHeight());
        double obsDist = this.getDistance(obsSolarAngle, obsSolarRadius, obsSolarHeight);
        apparentMagn += 5.0 * Planet.log10(sunDist * obsDist);
        double phaseAngle = this.getPhase(obsSolarAngle, obsSolarRadius);
        apparentMagn += this.getPhaseIntegral(phaseAngle);
        if (this.isComet) {
            apparentMagn += this.getCometMagnitude(obsSolarAngle, obsSolarRadius, obsSolarHeight);
        }
        return apparentMagn += sun.absMagnitude - 4.83;
    }

    public double getDiameterEstimate() {
        double ALBEDO = 0.4;
        if (this.textureIndex == 1 || this.textureIndex == 2) {
            ALBEDO = 0.15;
        }
        if (this.isStar()) {
            ALBEDO = 0.05;
        }
        return 1329.0 / Planet.sqrt(ALBEDO) * Planet.pow(10.0, -0.2 * this.absMagnitude);
    }

    public double getDiameter() {
        return this.diameter;
    }

    public double getGlobeMultiplier() {
        return 12742.0 / this.diameter;
    }

    public double getAngularDiameter(double obsSolarAngle, double obsSolarRadius, double obsSolarHeight) {
        double diam = this.diameter;
        double distance = this.getDistance(obsSolarAngle, obsSolarRadius, obsSolarHeight) * 1.49597870691E8;
        double angDiam = 2.0 * Planet.atan(diam * (double)Planet.CONFIG.diameterScale / distance / 2.0) / (double)Planet.CONFIG.baseSize;
        if (this.textureIndex != 1 && this.textureIndex != 5 && Planet.CONFIG.bigPlanets) {
            angDiam = Planet.sqrt(angDiam) * 25.0;
        }
        return angDiam;
    }

    public boolean isRenderable() {
        Planet observer = Astrocraft.getObserver();
        if (this == observer && !this.isStar()) {
            return false;
        }
        if (this == Astrocraft.getObserverPlanet() && !this.isStar()) {
            return false;
        }
        if (Astrocraft.CONFIG.legacyMoon && observer.getName().equals("Earth") && this.getName().equals("Moon")) {
            return false;
        }
        if (observer.getName().equals("Earth") && this.getName().equals("Earth")) {
            return false;
        }
        if (this.getName().equals("Backup Earth")) {
            return false;
        }
        return this.getColor() != null;
    }

    public Star addStar() {
        for (Planet moon : this.getSatellites()) {
            moon.addStar();
        }
        if (!Planet.CONFIG.enablePlanets && !this.isStar() && this.getName() != "Moon") {
            return null;
        }
        if (!this.isRenderable()) {
            return null;
        }
        Planet observer = Astrocraft.getObserver();
        double obsSolarAngle = observer.getSolarAngle();
        double obsSolarRadius = observer.getSolarRadius();
        double obsSolarHeight = observer.getSolarHeight();
        double red = this.getColor().getRed();
        double green = this.getColor().getGreen();
        double blue = this.getColor().getBlue();
        double ra = this.getRightAscension(obsSolarAngle, obsSolarRadius);
        double tradius = this.getDistance(obsSolarAngle, obsSolarRadius);
        double tdist = this.getDistance(obsSolarAngle, obsSolarRadius, obsSolarHeight);
        double obsInc = observer.getEffectiveInclination();
        double eclde = this.getInclination(obsSolarHeight, tradius) + obsInc * Math.cos(Math.toRadians(ra));
        double de = -Astrocraft.getEclipticDeclination(-ra) + eclde;
        double magn = this.getApparentMagnitude(obsSolarAngle, obsSolarRadius, obsSolarHeight);
        double diameter = this.getAngularDiameter(obsSolarAngle, obsSolarRadius, obsSolarHeight);
        Star star = new Star(magn, ra - obsSolarAngle + 180.0, de, red, green, blue);
        star.setAppearance(diameter, tdist, this.textureIndex, this.rings, this.getPhase(obsSolarAngle, obsSolarRadius));
        Star.addPlanet(star);
        return star;
    }

    public boolean hasThinAtmosphere() {
        if (this.isStar()) {
            return false;
        }
        if (!Planet.CONFIG.simulateAtmosphere) {
            return true;
        }
        return this.atmosphere != Atmosphere.NONE;
    }

    public boolean hasNormalAtmosphere() {
        if (!Planet.CONFIG.simulateAtmosphere) {
            return true;
        }
        return this.hasThinAtmosphere() && this.atmosphere != Atmosphere.THIN;
    }

    public boolean hasThickAtmosphere() {
        if (!Planet.CONFIG.simulateAtmosphere) {
            return false;
        }
        return this.atmosphere == Atmosphere.THICK;
    }

    public double getObliquity() {
        return this.obliquity;
    }

    public boolean isStar() {
        return this.isStar;
    }

    public boolean isEquatorial() {
        return this.equatorial;
    }

    public Planet getSun() {
        for (Planet primary = this.getPrimary(); primary != null; primary = primary.getPrimary()) {
            if (!primary.isStar()) continue;
            return primary;
        }
        return Astrocraft.searchPlanets("Sun");
    }

    public static enum Texture {
        NONE,
        MOON,
        TERRESTIAL,
        BANDED,
        SMOOTH,
        COMET,
        SUN,
        STAR,
        CUSTOM;

    }

    public static enum Atmosphere {
        NONE,
        THIN,
        NORMAL,
        THICK;

    }
}

