/*
 * Decompiled with CFR 0.152.
 */
package mod.lwhrvw.astrocraft;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Random;
import java.util.Scanner;
import mod.lwhrvw.astrocraft.Astrocraft;
import mod.lwhrvw.astrocraft.MathFuncs;
import mod.lwhrvw.astrocraft.Planet;
import mod.lwhrvw.astrocraft.VersionUtils;
import mod.lwhrvw.astrocraft.config.AstrocraftConfig;
import mod.lwhrvw.astrocraft.deepsky.DSRenderer;
import mod.lwhrvw.astrocraft.deepsky.SkyboxRenderer;
import mod.lwhrvw.astrocraft.meteors.Meteor;
import mod.lwhrvw.astrocraft.meteors.MeteorGenerator;
import mod.lwhrvw.astrocraft.overlays.ConstellationRenderer;
import mod.lwhrvw.astrocraft.overlays.GridRenderer;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL11;

public class Star
extends MathFuncs {
    private static final AstrocraftConfig CONFIG = Astrocraft.CONFIG;
    private static ArrayList<Star> fixedStars = new ArrayList();
    private static ArrayList<Star> customStars = new ArrayList();
    private static ArrayList<Star> planets = new ArrayList();
    private static ArrayList<Claim> claims = new ArrayList();
    private static ArrayList<Star> textured = new ArrayList();
    private static Star sun = new Star(20.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static class_2960 TEXTURES = class_2960.method_60655((String)"astrocraft", (String)"textures/planets.png");
    private static class_2960 RINGS = class_2960.method_60655((String)"astrocraft", (String)"textures/rings.png");
    private static class_2960 GLARE = class_2960.method_60655((String)"astrocraft", (String)"textures/glare.png");
    private static double cameraDE = 0.0;
    private static double cameraDEmin = 0.0;
    private static double cameraDEmax = 0.0;
    private static double cameraRA = 0.0;
    private static double cameraRAmin = 0.0;
    private static double cameraRAmax = 0.0;
    private double magnitude;
    private double rightAscension;
    private double declination;
    private double red;
    private double green;
    private double blue;
    private double diameter = 0.0;
    private double distance;
    private double phaseAngle;
    private int textureIndex;
    private boolean rings = false;
    private ArrayList<Sunspot> sunspots = null;
    private double effectiveBrightness = 0.0;
    private double effectiveDiameter = 0.0;
    private double eclipsed = 0.0;

    public static void renderMeteorsTris(class_287 bufferBuilder, Matrix4f matrix4f2) {
        class_287 triBuffer = VersionUtils.setupBuffer(bufferBuilder, class_293.class_5596.field_27379, class_290.field_1576);
        double time = Star.getTime();
        for (Meteor meteor : MeteorGenerator.getActive(time)) {
            meteor.renderTriangle(triBuffer, matrix4f2, time);
        }
        for (int i = 0; i < 3; ++i) {
            triBuffer.method_22918(matrix4f2, 0.0f, 0.0f, 0.0f).method_22915(0.0f, 0.0f, 0.0f, 0.0f);
            VersionUtils.nextVertex(triBuffer);
        }
        class_286.method_43433((class_9801)triBuffer.method_60800());
    }

    public static void renderMeteorsLines(class_287 lineBuffer, Matrix4f matrix4f2) {
        double time = Star.getTime();
        for (Meteor meteor : MeteorGenerator.getActive(time)) {
            meteor.renderLine(lineBuffer, matrix4f2, time);
        }
    }

    public static void renderLines(class_287 bufferBuilder, Matrix4f matrix4f2) {
        if (Astrocraft.CONFIG.enableMeteors) {
            Star.renderMeteorsTris(bufferBuilder, matrix4f2);
        }
        class_287 bb = VersionUtils.setupBuffer(bufferBuilder, class_293.class_5596.field_29344, class_290.field_1576);
        if (Astrocraft.CONFIG.enableMeteors) {
            Star.renderMeteorsLines(bb, matrix4f2);
        }
        if (Astrocraft.CONFIG.showConstellations) {
            ConstellationRenderer.render(bb, matrix4f2);
        }
        if (Astrocraft.CONFIG.showEquator) {
            GridRenderer.renderEquator(bb, matrix4f2);
        }
        if (Astrocraft.CONFIG.showEquatorialGrid) {
            GridRenderer.renderEquatorialGrid(bb, matrix4f2);
        }
        if (Astrocraft.CONFIG.showEcliptic) {
            GridRenderer.renderEcliptic(bb, matrix4f2);
        }
        if (Astrocraft.CONFIG.showZodiac) {
            GridRenderer.renderZodiac(bb, matrix4f2);
        }
        bb.method_22918(matrix4f2, 0.0f, 0.0f, 0.0f).method_1336(0, 0, 0, 0);
        VersionUtils.nextVertex(bb);
        bb.method_22918(matrix4f2, 0.0f, 0.0f, 0.0f).method_1336(0, 0, 0, 0);
        VersionUtils.nextVertex(bb);
        class_286.method_43433((class_9801)bb.method_60800());
    }

    public static double getTime() {
        return (double)Astrocraft.getWorldTime() + Star.mod(Astrocraft.getSolarHourAngle() / 360.0 * 24000.0, 1.0);
    }

    public static Vector3f getTempColor(double tempK) {
        float red = 1.0f;
        float green = 1.0f;
        float blue = 1.0f;
        double t = tempK / 100.0;
        if (t > 66.0) {
            red = (float)Star.clamp(329.698727446 * Star.pow(t - 60.0, -0.13320247592) / 256.0, 0.0, 1.0);
            green = (float)Star.clamp(288.1221695283 * Star.pow(t - 60.0, -0.0755148492) / 256.0, 0.0, 1.0);
        } else {
            green = (float)Star.clamp((99.4708025861 * Math.log(t) - 161.1195681661) / 256.0, 0.0, 1.0);
            blue = t < 19.0 ? 0.0f : (float)Star.clamp((138.5177312231 * Math.log(t - 10.0) - 305.0447927307) / 256.0, 0.0, 360.0);
        }
        return new Vector3f(red, green, blue);
    }

    public static void loadFixedStars(InputStream stream) {
        fixedStars.clear();
        try (DataInputStream input = new DataInputStream(stream);){
            while (true) {
                double magn = (double)input.readUnsignedByte() / 16.0 - 4.0;
                double ra = ((double)input.readUnsignedByte() + (double)input.readUnsignedByte() / 256.0) / 256.0 * 360.0;
                double de = ((double)input.readByte() + (double)input.readUnsignedByte() / 256.0) / 256.0 * 360.0;
                double temp = (double)input.readUnsignedByte() * 100.0;
                if (magn > (double)Star.CONFIG.spyglassMagnitudeLimit) break;
                Vector3f color = Star.getTempColor(temp);
                Star star = new Star(magn, Star.mod(ra + 180.0, 360.0), de, color.x, color.y, color.z);
                star.genCache();
                fixedStars.add(star);
            }
            input.close();
        }
        catch (EOFException e) {
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            fixedStars.clear();
        }
    }

    public static void loadFixedStarsOld(InputStream stream) {
        fixedStars.clear();
        try (Scanner scanner = new Scanner(stream);){
            while (scanner.hasNextLine()) {
                String str = scanner.nextLine();
                String[] data = str.split(" ");
                double magn = Double.parseDouble(data[0]);
                if (magn > (double)Star.CONFIG.spyglassMagnitudeLimit) continue;
                double ra = (Double.parseDouble(data[1]) + 180.0) % 360.0;
                double de = Double.parseDouble(data[2]);
                double red = Double.parseDouble(data[3]);
                double green = Double.parseDouble(data[4]);
                double blue = Double.parseDouble(data[5]);
                Star star = new Star(magn, ra, de, red, green, blue);
                star.genCache();
                fixedStars.add(star);
            }
            scanner.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            fixedStars.clear();
        }
    }

    public static void loadCustomStars() {
        customStars.clear();
        for (AstrocraftConfig.Star star : Star.CONFIG.customStars) {
            if (star.magn > Astrocraft.getMagnitudeLimit()) continue;
            Star s = new Star(star.magn, (star.ra + 180.0) % 360.0, star.de, star.color.getRed(), star.color.getGreen(), star.color.getBlue());
            s.genCache();
            customStars.add(s);
        }
    }

    public static void initRenderer() {
        planets.clear();
        claims.clear();
        textured.clear();
        Planet sunPlanet = Astrocraft.getObserverPlanet().getSun();
        for (Planet planet : Astrocraft.getPlanets()) {
            Star star = planet.addStar();
            if (planet != sunPlanet) continue;
            sun = star;
        }
        Star.processPlanets();
    }

    public static void addPlanet(Star star) {
        planets.add(star);
    }

    public static void processPlanets() {
        planets.sort(new Comparator<Star>(){

            @Override
            public int compare(Star ls, Star rs) {
                return ls.getDistance() > rs.getDistance() ? 1 : (ls.getDistance() < rs.getDistance() ? -1 : 0);
            }
        });
    }

    public static float getStarBrightness() {
        float min = 0.0f;
        if (!Astrocraft.getObserver().hasNormalAtmosphere() || Star.CONFIG.daytimeStars) {
            min = 0.3f;
        }
        float h = 1.0f - (float)Star.getSkyBrightness();
        h = class_3532.method_15363((float)h, (float)0.0f, (float)1.0f);
        if (Astrocraft.getObserver().hasThickAtmosphere()) {
            h = (float)((double)h * 0.85);
        }
        h = 1.0f - (1.0f - h * h * 0.5f) * (1.0f - Astrocraft.getSpaceMultiplier());
        if (Astrocraft.isUsingSpyglass()) {
            h = (float)((double)h * 1.4);
        }
        float opacity = 0.1f + (float)Star.CONFIG.starOpacity / 100.0f * 0.9f;
        if (h < 0.1f) {
            h = 0.0f;
        }
        return class_3532.method_15363((float)h, (float)min, (float)(Astrocraft.isUsingSpyglass() ? opacity : opacity * 0.5f));
    }

    public static double getSkyBrightness() {
        if (Astrocraft.getObserver().isStar()) {
            return 0.0;
        }
        double brightness = Star.getSurfaceBrightness();
        double spyglassZoom = Astrocraft.isUsingSpyglass() ? Star.sqrt(Astrocraft.getSpyglassZoom()) : 1.0;
        return Star.clamp(brightness * brightness / spyglassZoom, 0.0, 1.0);
    }

    public static float getSolarAltitude() {
        double alt = sun.getAltitude();
        return (float)alt / 360.0f - 0.25f;
    }

    public static double getSurfaceBrightness() {
        double POWER = 0.119;
        if (Astrocraft.getObserver().isStar()) {
            return 1.0;
        }
        double total = 1.0;
        for (Star star : planets) {
            double brightness;
            if (star.getMagnitude() > 0.0 || Double.isNaN(brightness = star.getTotalBrightness())) continue;
            double altitude = star.getAltitude();
            double altMult = Star.pow(Star.clamp(0.65 + Star.sin(altitude) * 2.0, 0.0, 1.0), 8.403361344537815);
            total += Star.max(0.0, brightness * altMult);
        }
        double level = Star.pow(total, 0.119) / 16.0;
        if (Double.isNaN(level) || level < 0.0) {
            return 1.0E-6;
        }
        return Star.clamp(level, 0.0, 1.0);
    }

    public static double getSurfaceBrightnessOld() {
        double altitude;
        double brightness;
        double groundBrightness = 0.0;
        double skyBrightness = 0.0;
        for (Star star : planets) {
            brightness = star.getTotalBrightness();
            if (Double.isNaN(brightness)) continue;
            altitude = star.getAltitude();
            skyBrightness += brightness * (2.0 - Star.cos(Math.max(0.0, altitude)) - Star.cos(Math.max(0.0, altitude + 10.0))) / 2.0;
            if (altitude < 0.0) continue;
            groundBrightness += brightness * (1.0 - Star.cos(altitude));
        }
        for (Star star : customStars) {
            brightness = star.getTotalBrightness();
            if (Double.isNaN(brightness)) continue;
            altitude = star.getAltitude();
            skyBrightness += brightness * (2.0 - Star.cos(Math.max(0.0, altitude)) - Star.cos(Math.max(0.0, altitude + 10.0))) / 2.0;
            if (altitude < 0.0) continue;
            groundBrightness += brightness * (1.0 - Star.cos(altitude));
        }
        for (Star star : fixedStars) {
            if (star.getMagnitude() > 2.0) break;
            brightness = star.getTotalBrightness();
            if (Double.isNaN(brightness)) continue;
            altitude = star.getAltitude();
            skyBrightness += brightness * (2.0 - Star.cos(Math.max(0.0, altitude)) - Star.cos(Math.max(0.0, altitude + 10.0))) / 2.0;
            if (altitude < 0.0) continue;
            groundBrightness += brightness * (1.0 - Star.cos(altitude));
        }
        double totalBrightness = groundBrightness;
        if (Astrocraft.getObserver().hasNormalAtmosphere()) {
            totalBrightness += 0.01 * skyBrightness;
        }
        double level = Star.pow(totalBrightness, 0.119) / 15.0;
        return Star.clamp(level, 0.0, 1.0);
    }

    public static void addClaim(double rightAscension, double declination, double radius) {
        if (radius < 1.0E-4) {
            return;
        }
        claims.add(new Claim(Star.mod(rightAscension, 360.0), declination, radius));
    }

    public static void addClaim(Claim claim) {
        if (claim.di < 1.0E-4) {
            return;
        }
        claims.add(claim);
    }

    public Claim getClaim() {
        return new Claim(Star.mod(this.rightAscension, 360.0), this.declination, (double)Star.CONFIG.baseSize * this.diameter * 0.3);
    }

    public static boolean isClaimFree(double rightAscension, double declination, double radius) {
        Claim newClaim = new Claim(rightAscension, declination, radius);
        for (Claim claim : claims) {
            if (claim.isAllowed(newClaim)) continue;
            return false;
        }
        return true;
    }

    public static double getEclipsed(Claim newClaim) {
        double uneclipsed = 1.0;
        for (Claim claim : claims) {
            if (claim.getEclipsed(newClaim) > 0.999999) {
                return 1.0;
            }
            if (!((uneclipsed *= 1.0 - claim.getEclipsed(newClaim)) <= 1.0E-6)) continue;
            return 1.0;
        }
        return 1.0 - uneclipsed;
    }

    public static ArrayList<Star> getPlanets() {
        return planets;
    }

    public static ArrayList<Star> getCustomStars() {
        return customStars;
    }

    public static ArrayList<Star> getStars() {
        return fixedStars;
    }

    public static int getUnorderedLength() {
        return planets.size() + customStars.size();
    }

    public static double[] getCameraPoint() {
        double[] nullcoords = new double[]{0.0, 0.0};
        class_310 client = class_310.method_1551();
        if (client == null) {
            return nullcoords;
        }
        class_1297 camera = client.method_1560();
        if (camera == null) {
            return nullcoords;
        }
        double az = camera.method_36454();
        double al = -camera.method_36455();
        double lat = Astrocraft.getLatitude();
        double de = -Star.asin(Star.sin(lat) * Star.sin(al) + Star.cos(lat) * Star.cos(al) * Star.cos(az));
        double hasin = Star.cos(al) * Star.sin(az) / Star.cos(-de);
        double hacos = (Star.sin(al) - Star.sin(lat) * Star.sin(-de)) / (Star.cos(lat) * Star.cos(-de));
        double ha = -Star.atan2(hasin, hacos);
        double ra = Star.mod(ha + 90.0 + 360.0 * Star.mod(Astrocraft.getWorldTime(), 24000.0) / 24000.0, 360.0);
        double[] coords = new double[]{ra, de};
        return coords;
    }

    public static void setCameraPoint() {
        double[] coords = Star.getCameraPoint();
        double range = 180.0 / Astrocraft.getSpyglassZoom();
        cameraRA = coords[0];
        cameraDE = coords[1];
        cameraDEmin = Star.clamp(coords[1] - range, -90.0, 90.0);
        cameraDEmax = Star.clamp(coords[1] + range, -90.0, 90.0);
        range = Star.abs(cameraDE) > 70.0 ? (range *= 360.0) : (Star.abs(cameraDE) > 50.0 ? (range *= 4.0) : (range *= 2.0));
        cameraRAmin = Star.clamp(coords[0] - range, 0.0, 360.0);
        cameraRAmax = Star.clamp(coords[0] + range, 0.0, 360.0);
    }

    public static boolean cameraShouldReload() {
        if (!Astrocraft.isUsingSpyglass() || !Star.CONFIG.enableSpyglassCulling) {
            return false;
        }
        double[] coords = Star.getCameraPoint();
        double range = 81.81818181818181 / Astrocraft.getSpyglassZoom();
        double cameraDEmin = Star.clamp(cameraDE - range, -90.0, 90.0);
        double cameraDEmax = Star.clamp(cameraDE + range, -90.0, 90.0);
        double cameraRAmin = Star.clamp(cameraRA - range, 0.0, 360.0);
        double cameraRAmax = Star.clamp(cameraRA + range, 0.0, 360.0);
        double ra = coords[0];
        double dec = coords[1];
        return dec < cameraDEmin || dec > cameraDEmax || ra < cameraRAmin || ra > cameraRAmax;
    }

    public Star(double magn, double ra, double de, double r, double g, double b) {
        this.magnitude = magn;
        this.rightAscension = ra;
        this.declination = de;
        this.red = r;
        this.green = g;
        this.blue = b;
    }

    public void setAppearance(double diam, double dist, int text, boolean r, double phase) {
        this.diameter = diam;
        this.distance = dist;
        this.textureIndex = text;
        this.rings = r;
        this.phaseAngle = phase;
        if (Star.CONFIG.enableSunspots && Astrocraft.isUsingSpyglass() && (this.textureIndex == 5 || this.textureIndex == 6)) {
            this.genSunspots();
        }
    }

    public double getMagnitude() {
        return this.magnitude - Astrocraft.getSpyglassMagnitudeBonus();
    }

    public double getRightAscension() {
        return this.rightAscension;
    }

    public double getSolarOffset() {
        return Star.mod(this.getRightAscension() - Astrocraft.getTropicalAngle(), 360.0);
    }

    public double getDeclination() {
        return this.declination;
    }

    public double getDistance() {
        return this.distance;
    }

    public double getRed() {
        return this.red;
    }

    public double getGreen() {
        return this.green;
    }

    public double getBlue() {
        return this.blue;
    }

    private double calcEclipsed() {
        this.eclipsed = Star.getEclipsed(this.getClaim());
        return this.eclipsed;
    }

    private double getEclipsed() {
        return this.eclipsed;
    }

    private double getUmbra() {
        double divergence;
        if (this.diameter < 1.0E-6) {
            return 0.0;
        }
        Planet sunPlanet = Astrocraft.getObserverPlanet().getSun();
        if (sunPlanet == null) {
            return 0.0;
        }
        double sunDiameter = sunPlanet.getSun().getDiameter() / 2.5;
        double sunDistance = sun.getDistance();
        double earthDiameter = Astrocraft.getObserverPlanet().getDiameter();
        double umbralEarthDistance = earthDiameter / (divergence = (sunDiameter - earthDiameter) / sunDistance);
        double umbralDistance = umbralEarthDistance - this.getDistance();
        if (umbralDistance <= 0.0) {
            return 0.0;
        }
        double umbralDiameter = divergence * umbralDistance * (double)Star.CONFIG.diameterScale;
        double KMTOAU = 6.68459E-9;
        double angularDiameter = Star.atan2(umbralDiameter * 6.68459E-9, this.distance);
        Claim umbra = new Claim(Star.mod(180.0 + sun.getRightAscension(), 360.0), -sun.getDeclination(), (double)Star.CONFIG.baseSize * angularDiameter * 0.3 / 2.0 * 2.5);
        return umbra.getEclipsed(this.getClaim());
    }

    public double getAltitude() {
        double latitude = Astrocraft.getLatitude();
        double declination = -this.getDeclination();
        double ha = Astrocraft.getSolarHourAngle() - this.getSolarOffset();
        return Star.asin(Star.sin(latitude) * Star.sin(declination) + Star.cos(latitude) * Star.cos(declination) * -Star.cos(ha));
    }

    private double getTotalBrightness() {
        double fullBrightness = Star.pow(2.512, -this.getMagnitude());
        double eclipsed = this.getEclipsed();
        return Math.max((fullBrightness *= Star.pow(1.0 - this.getUmbra(), 8.0)) * Star.pow(1.0 - eclipsed, 5.0), Double.MIN_NORMAL);
    }

    public double getEffectiveBrightness() {
        double effDiameter;
        if (this.effectiveBrightness > 0.0) {
            return this.effectiveBrightness;
        }
        double totalBrightness = this.getTotalBrightness();
        double adjDiameter = effDiameter = this.getEffectiveDiameter();
        if (effDiameter != this.diameter) {
            adjDiameter = Star.pow(effDiameter, 1.0f / Star.CONFIG.maxSizeMultiplier);
        }
        double lightArea = adjDiameter * adjDiameter;
        return Star.clamp(totalBrightness / Star.pow(lightArea, Star.CONFIG.starBrightnessModifier), 0.0, 1.0);
    }

    public double getEffectiveDiameter() {
        if (this.effectiveDiameter > 0.0) {
            return this.effectiveDiameter;
        }
        double totalBrightness = this.getTotalBrightness();
        double mainBrightness = Math.min(totalBrightness, 1000.0);
        double extraBrightness = Math.max(totalBrightness - 1000.0, 0.0);
        double minimumDiameter = Star.pow(Star.sqrt(mainBrightness + Star.sqrt(extraBrightness)), Star.CONFIG.maxSizeMultiplier);
        if (Astrocraft.isUsingSpyglass()) {
            return Math.max(this.diameter, minimumDiameter /= Star.sqrt(Astrocraft.getSpyglassZoom()));
        }
        return Math.max(this.diameter, minimumDiameter - this.diameter / 2.0);
    }

    public void genCache() {
        this.effectiveBrightness = 0.0;
        this.effectiveBrightness = this.getEffectiveBrightness();
        this.effectiveDiameter = 0.0;
        this.effectiveDiameter = this.getEffectiveDiameter();
    }

    public double getTrueDiameter() {
        return this.diameter;
    }

    public boolean isInView() {
        if (!Astrocraft.isUsingSpyglass() || !Star.CONFIG.enableSpyglassCulling) {
            return true;
        }
        if (this.diameter > 1.0E-5) {
            return true;
        }
        double dec = this.getDeclination();
        if (dec < cameraDEmin || dec > cameraDEmax) {
            return false;
        }
        double ra = this.getSolarOffset();
        if (cameraRA < 15.0 && ra > 345.0 || cameraRA > 345.0 && ra < 15.0) {
            return true;
        }
        return !(ra < cameraRAmin) && !(ra > cameraRAmax);
    }

    private class_243 getVertex(float x, float y, float z, float ra, float de) {
        double px = (double)x * Star.cos(de) - (double)y * Star.sin(de);
        double py = (double)x * Star.sin(de) + (double)y * Star.cos(de);
        double pz = z;
        double rx = px;
        double ry = py * Star.cos(ra) - pz * Star.sin(ra);
        double rz = py * Star.sin(ra) + pz * Star.cos(ra);
        return new class_243(rx, ry, rz);
    }

    private class_243 getVertex(class_243 vec, double ra, double de) {
        return this.getVertex((float)vec.field_1352, (float)vec.field_1351, (float)vec.field_1350, (float)ra, (float)de);
    }

    private class_243 getVertex(float x, float y, float z) {
        double ra = -this.getSolarOffset();
        double de = -this.getDeclination();
        return this.getVertex(x, y, z, (float)ra, (float)de);
    }

    public class_243 getVertex(int index, double radius, double depth) {
        class_243 vec;
        float k = (float)(depth * Star.tan(Star.clamp(radius, 0.0, 89.999)));
        switch (index) {
            case 0: {
                vec = this.getVertex(-k, (float)(-depth), k);
                break;
            }
            case 1: {
                vec = this.getVertex(k, (float)(-depth), k);
                break;
            }
            case 2: {
                vec = this.getVertex(k, (float)(-depth), -k);
                break;
            }
            case 3: {
                vec = this.getVertex(-k, (float)(-depth), -k);
                break;
            }
            default: {
                return null;
            }
        }
        return vec;
    }

    public class_243 getVertex(int index, double radius) {
        return this.getVertex(index, radius, 100.0);
    }

    public int getPhaseIndex() {
        int index = (int)Math.round(this.phaseAngle * 4.0 / 180.0);
        if (this.getSolarOffset() < 180.0) {
            return (8 - index) % 8;
        }
        return index;
    }

    public int getTextureIndex() {
        return this.textureIndex;
    }

    public boolean hasRings() {
        return this.rings;
    }

    public static void addTextured(Star star) {
        textured.add(star);
    }

    private void render(class_287 buffer) {
        double magn = this.getMagnitude();
        if (!this.isInView()) {
            return;
        }
        Random random = new Random((int)(magn * 10000.0));
        double double33 = random.nextDouble() * Math.PI * 2.0;
        if (!Star.CONFIG.roundStars) {
            double33 = (double33 - Math.PI) / Math.pow(1.61, Math.max(-magn, 0.0));
        }
        int copyCount = (int)Math.round(Star.min(Star.CONFIG.copyCount, Star.CONFIG.copyCount * Star.pow(Star.CONFIG.copyPower, -magn)));
        if (Star.abs(magn - 0.4997) < 0.01) {
            copyCount = (int)((double)copyCount / 2.5);
        }
        double ra = this.getSolarOffset();
        double de = this.getDeclination();
        double red = this.getRed();
        double green = this.getGreen();
        double blue = this.getBlue();
        double sunDec = Astrocraft.getSolarDeclinationCached();
        if (Math.abs(Math.min(ra + 180.0, 180.0 - ra)) < 5.0 && Math.abs(de + sunDec) < 5.0 && magn > 2.0) {
            return;
        }
        if (Star.CONFIG.legacyMoon) {
            double moonDec = Astrocraft.getLunarDeclinationCached();
            double moonDead = 3.0 * Astrocraft.getLunarScaleCached();
            double mra = (ra + Astrocraft.getPhaseAngle() + 180.0) % 360.0;
            if (Math.abs(Math.min(mra + 180.0, 180.0 - mra)) < moonDead && Math.abs(de - moonDec) < moonDead) {
                return;
            }
        }
        double effDiameter = this.getEffectiveDiameter() / Star.sqrt(Astrocraft.getSpyglassZoom());
        double trueDiameter = this.getTrueDiameter();
        if (this.calcEclipsed() > 0.9999) {
            return;
        }
        Star.addClaim(this.getClaim());
        if (trueDiameter > 0.25 / Astrocraft.getSpyglassZoom()) {
            Star.addTextured(this);
        }
        if (Star.CONFIG.preventSunStarRendering && this == sun) {
            return;
        }
        double rxt = Star.clamp(1.0 - trueDiameter / effDiameter, 0.0, 1.0);
        if (Astrocraft.isUsingSpyglass() && trueDiameter > 0.0) {
            rxt *= 0.5;
        }
        if (effDiameter > trueDiameter || this.getTextureIndex() == 0) {
            for (int copy = 0; copy < copyCount; ++copy) {
                int v;
                double ara = ra + (Math.random() * 2.0 - 1.0) * Star.CONFIG.copyRange;
                double ade = de + (Math.random() * 2.0 - 1.0) * Star.CONFIG.copyRange;
                double i = -Math.sin(Math.toRadians(ade));
                double l = Math.cos(Math.toRadians(ade));
                double j = -Math.cos(Math.toRadians(ara)) * l;
                double k = Math.sin(Math.toRadians(ara)) * l;
                double[] xCoords = new double[4];
                double[] yCoords = new double[4];
                double[] zCoords = new double[4];
                double double5 = i;
                double double7 = j;
                double double9 = k;
                double double11 = (double)Star.CONFIG.baseSize * effDiameter / 2.0;
                double double13 = double5 * double5 + double7 * double7 + double9 * double9;
                if (!(double13 < 1.0) || !(double13 > 0.01 / Astrocraft.getSpyglassZoom())) continue;
                double13 = 1.0 / Math.sqrt(double13);
                double double15 = (double5 *= double13) * 100.0;
                double double17 = (double7 *= double13) * 100.0;
                double double19 = (double9 *= double13) * 100.0;
                double double21 = class_3532.method_15349((double)double5, (double)double9);
                double double23 = class_3532.method_15374((float)((float)double21));
                double double25 = class_3532.method_15362((float)((float)double21));
                double double27 = class_3532.method_15349((double)Math.sqrt(double5 * double5 + double9 * double9), (double)double7);
                double double29 = class_3532.method_15374((float)((float)double27));
                double double31 = class_3532.method_15362((float)((float)double27));
                if (Star.CONFIG.roundStars) {
                    double33 = random.nextDouble() * Math.PI * 2.0;
                }
                double double35 = class_3532.method_15374((float)((float)double33));
                double double37 = class_3532.method_15362((float)((float)double33));
                float s = (float)Star.CONFIG.starColor / 100.0f;
                float r = 0.75f * (1.0f - s) + (float)red * s;
                float g = 0.75f * (1.0f - s) + (float)green * s;
                float b = 0.75f * (1.0f - s) + (float)blue * s;
                double eb = Star.clamp(this.getEffectiveBrightness(), 0.0, 1.0) * rxt;
                float a = (float)Star.clamp(eb / (double)copyCount, 0.0, 1.0);
                for (v = 0; v < 4; ++v) {
                    double double42 = (double)((v & 2) - 1) * double11;
                    double double44 = (double)((v + 1 & 2) - 1) * double11;
                    double double48 = double42 * double37 - double44 * double35;
                    double double52 = double44 * double37 + double42 * double35;
                    double double54 = double48 * double29 + 0.0 * double31;
                    double double56 = 0.0 * double29 - double48 * double31;
                    double double58 = double56 * double23 - double52 * double25;
                    double double60 = double54;
                    double double62 = double52 * double23 + double56 * double25;
                    double x = double15 + double58;
                    double y = double17 + double60;
                    double z = double19 + double62;
                    xCoords[v] = x;
                    yCoords[v] = y;
                    zCoords[v] = z;
                }
                for (v = 0; v < 4; ++v) {
                    float x = (float)xCoords[v];
                    float y = (float)yCoords[v];
                    float z = (float)zCoords[v];
                    buffer.method_22912(x, y, z).method_22915(r, g, b, a);
                    VersionUtils.nextVertex(buffer);
                }
            }
        }
    }

    public static void renderAll(class_287 bufferBuilder) {
        for (Star star : Star.getPlanets()) {
            if (star.getMagnitude() > Astrocraft.getMagnitudeLimit() && star.getTrueDiameter() < 0.25 / Astrocraft.getSpyglassZoom()) continue;
            star.render(bufferBuilder);
        }
        if (Star.CONFIG.enableCustomStars) {
            for (Star star : Star.getCustomStars()) {
                if (star.getMagnitude() > Astrocraft.getMagnitudeLimit()) continue;
                star.render(bufferBuilder);
            }
        }
        if (Star.CONFIG.enableRealStars) {
            for (Star star : Star.getStars()) {
                if (star.getMagnitude() > Astrocraft.getMagnitudeLimit()) break;
                star.render(bufferBuilder);
            }
        }
        bufferBuilder.method_22912(0.0f, 0.0f, 0.0f).method_1336(0, 0, 0, 0);
        VersionUtils.nextVertex(bufferBuilder);
        bufferBuilder.method_22912(0.0f, 0.0f, 0.0f).method_1336(0, 0, 0, 0);
        VersionUtils.nextVertex(bufferBuilder);
        bufferBuilder.method_22912(0.0f, 0.0f, 0.0f).method_1336(0, 0, 0, 0);
        VersionUtils.nextVertex(bufferBuilder);
        bufferBuilder.method_22912(0.0f, 0.0f, 0.0f).method_1336(0, 0, 0, 0);
        VersionUtils.nextVertex(bufferBuilder);
    }

    private void genSunspots() {
        this.sunspots = new ArrayList();
        for (int i = 0; i < 16; ++i) {
            double tropic;
            double speed;
            double rotation;
            double azimuth;
            double lifetime = 2018903.9999999998 * Star.pow(1.61, -i);
            Random rand = new Random(i * 167 + (int)(((double)Astrocraft.getWorldTime() + 9216000.0) / lifetime));
            double longitude = 360.0 * rand.nextDouble();
            double latitude = 64.0 * rand.nextDouble() * rand.nextDouble();
            double equ = 11.6 * Star.sin(2.0 * rand.nextDouble() - 1.0);
            latitude += Star.abs(equ);
            if (Star.cos(azimuth = longitude + (rotation = Astrocraft.getTimeAngle(360.0 / (speed = 14.713 - 2.396 * Star.pow(Star.sin(latitude *= Star.abs(equ) / equ), 2.0) - 1.787 * Star.pow(Star.sin(latitude), 4.0)) / 365.25)) - (tropic = Astrocraft.getTropicalAngle())) < 0.0) continue;
            double x = Star.sin(azimuth);
            double y = Star.sin(latitude);
            double size = Star.pow(1.12, rand.nextInt(-40 - i, -36)) * Star.abs(Star.cos(azimuth));
            this.sunspots.add(new Sunspot(x, y, size));
        }
    }

    private void renderSunspots(class_287 bufferBuilder, Matrix4f matrix4f2, double depth) {
        depth -= 0.04;
        double bounds = (double)Star.CONFIG.baseSize * this.getTrueDiameter() / 8.0;
        for (Sunspot sunspot : this.sunspots) {
            double size = bounds * sunspot.getSize();
            if (size * Astrocraft.getSpyglassZoom() < 0.112) continue;
            double x = bounds * sunspot.getX();
            double y = bounds * sunspot.getY();
            class_243 w0 = this.getVertex(this.getVertex(0, size, depth), x, y);
            class_243 w1 = this.getVertex(this.getVertex(1, size, depth), x, y);
            class_243 w2 = this.getVertex(this.getVertex(2, size, depth), x, y);
            class_243 w3 = this.getVertex(this.getVertex(3, size, depth), x, y);
            class_287 bb = VersionUtils.setupBuffer(bufferBuilder, class_293.class_5596.field_27382, class_290.field_1585);
            bb.method_22918(matrix4f2, (float)w0.field_1352, (float)w0.field_1351, (float)w0.field_1350).method_22913(0.0f, 0.0f);
            VersionUtils.nextVertex(bb);
            bb.method_22918(matrix4f2, (float)w1.field_1352, (float)w1.field_1351, (float)w1.field_1350).method_22913(0.0f, 0.0f);
            VersionUtils.nextVertex(bb);
            bb.method_22918(matrix4f2, (float)w2.field_1352, (float)w2.field_1351, (float)w2.field_1350).method_22913(0.0f, 0.0f);
            VersionUtils.nextVertex(bb);
            bb.method_22918(matrix4f2, (float)w3.field_1352, (float)w3.field_1351, (float)w3.field_1350).method_22913(0.0f, 0.0f);
            VersionUtils.nextVertex(bb);
            RenderSystem.setShaderColor((float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f);
            GL11.glDepthMask((boolean)true);
            class_286.method_43433((class_9801)bb.method_60800());
            GL11.glDepthMask((boolean)false);
        }
    }

    private void renderTexture(class_287 bufferBuilder, Matrix4f matrix4f2, double depth) {
        int phase = this.getPhaseIndex();
        int texture = this.getTextureIndex();
        int s = phase % 8;
        int m = texture;
        float t = (float)(s + 0) / 8.0f;
        float o = (float)(m + 0) / 8.0f;
        float p = (float)(s + 1) / 8.0f;
        float q = (float)(m + 1) / 8.0f;
        float brightness = (float)MathFuncs.clamp(MathFuncs.sqrt(this.getEffectiveBrightness()), 0.025, 1.0);
        float r = this.textureIndex == 5 || this.textureIndex == 1 ? 1.0f : (float)this.getRed();
        float g = this.textureIndex == 5 || this.textureIndex == 1 ? 1.0f : (float)this.getGreen();
        float b = this.textureIndex == 5 || this.textureIndex == 1 ? 1.0f : (float)this.getBlue();
        double umbra = 0.0;
        if (!Astrocraft.getObserverPlanet().isStar()) {
            umbra = this.getUmbra();
        }
        GL11.glEnable((int)2929);
        if (Star.CONFIG.enableSunspots && Astrocraft.isUsingSpyglass() && this.sunspots != null) {
            this.renderSunspots(bufferBuilder, matrix4f2, depth);
        }
        r = (float)((double)r * Star.max((double)brightness, 0.25 * umbra));
        g = (float)((double)g * Star.max((double)brightness, 0.1 * umbra));
        float visibility = this.textureIndex == 5 || this.textureIndex == 6 ? Astrocraft.getClearness() : Astrocraft.getVisibility();
        RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURES);
        RenderSystem.setShaderColor((float)r, (float)g, (float)(b *= brightness), (float)visibility);
        class_243 v0 = this.getVertex(0, (double)Star.CONFIG.baseSize * this.getTrueDiameter() / 2.0, depth);
        class_243 v1 = this.getVertex(1, (double)Star.CONFIG.baseSize * this.getTrueDiameter() / 2.0, depth);
        class_243 v2 = this.getVertex(2, (double)Star.CONFIG.baseSize * this.getTrueDiameter() / 2.0, depth);
        class_243 v3 = this.getVertex(3, (double)Star.CONFIG.baseSize * this.getTrueDiameter() / 2.0, depth);
        class_243 w0 = this.getVertex(0, (double)Star.CONFIG.baseSize * this.getTrueDiameter() / 8.0, depth);
        class_243 w1 = this.getVertex(1, (double)Star.CONFIG.baseSize * this.getTrueDiameter() / 8.0, depth);
        class_243 w2 = this.getVertex(2, (double)Star.CONFIG.baseSize * this.getTrueDiameter() / 8.0, depth);
        class_243 w3 = this.getVertex(3, (double)Star.CONFIG.baseSize * this.getTrueDiameter() / 8.0, depth);
        class_287 bb = VersionUtils.setupBuffer(bufferBuilder, class_293.class_5596.field_27382, class_290.field_1585);
        bb.method_22918(matrix4f2, (float)v0.field_1352, (float)v0.field_1351, (float)v0.field_1350).method_22913(p, o);
        VersionUtils.nextVertex(bb);
        bb.method_22918(matrix4f2, (float)v1.field_1352, (float)v1.field_1351, (float)v1.field_1350).method_22913(p, q);
        VersionUtils.nextVertex(bb);
        bb.method_22918(matrix4f2, (float)v2.field_1352, (float)v2.field_1351, (float)v2.field_1350).method_22913(t, q);
        VersionUtils.nextVertex(bb);
        bb.method_22918(matrix4f2, (float)v3.field_1352, (float)v3.field_1351, (float)v3.field_1350).method_22913(t, o);
        VersionUtils.nextVertex(bb);
        class_286.method_43433((class_9801)bb.method_60800());
        bb = VersionUtils.setupBuffer(bufferBuilder, class_293.class_5596.field_27382, class_290.field_1585);
        bb.method_22918(matrix4f2, (float)w0.field_1352, (float)w0.field_1351, (float)w0.field_1350).method_22913(0.0f, 0.0f);
        VersionUtils.nextVertex(bb);
        bb.method_22918(matrix4f2, (float)w1.field_1352, (float)w1.field_1351, (float)w1.field_1350).method_22913(0.0f, 0.0f);
        VersionUtils.nextVertex(bb);
        bb.method_22918(matrix4f2, (float)w2.field_1352, (float)w2.field_1351, (float)w2.field_1350).method_22913(0.0f, 0.0f);
        VersionUtils.nextVertex(bb);
        bb.method_22918(matrix4f2, (float)w3.field_1352, (float)w3.field_1351, (float)w3.field_1350).method_22913(0.0f, 0.0f);
        VersionUtils.nextVertex(bb);
        GL11.glDepthMask((boolean)true);
        class_286.method_43433((class_9801)bb.method_60800());
        GL11.glDepthMask((boolean)false);
        r = (float)(this.getRed() * Star.max((double)brightness, 0.25 * umbra));
        g = (float)(this.getGreen() * Star.max((double)brightness, 0.1 * umbra));
        b = (float)(this.getBlue() * (double)brightness);
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)visibility);
        if (this.hasRings()) {
            RenderSystem.setShaderTexture((int)0, (class_2960)RINGS);
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)(visibility * 0.35f));
            bb = VersionUtils.setupBuffer(bufferBuilder, class_293.class_5596.field_27382, class_290.field_1585);
            bb.method_22918(matrix4f2, (float)v0.field_1352, (float)v0.field_1351, (float)v0.field_1350).method_22913(1.0f, 0.0f);
            VersionUtils.nextVertex(bb);
            bb.method_22918(matrix4f2, (float)v1.field_1352, (float)v1.field_1351, (float)v1.field_1350).method_22913(1.0f, 1.0f);
            VersionUtils.nextVertex(bb);
            bb.method_22918(matrix4f2, (float)v2.field_1352, (float)v2.field_1351, (float)v2.field_1350).method_22913(0.0f, 1.0f);
            VersionUtils.nextVertex(bb);
            bb.method_22918(matrix4f2, (float)v3.field_1352, (float)v3.field_1351, (float)v3.field_1350).method_22913(0.0f, 0.0f);
            VersionUtils.nextVertex(bb);
            class_286.method_43433((class_9801)bb.method_60800());
        }
        GL11.glDisable((int)2929);
        RenderSystem.setShaderTexture((int)0, (class_2960)GLARE);
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)visibility);
        bb = VersionUtils.setupBuffer(bufferBuilder, class_293.class_5596.field_27382, class_290.field_1585);
        bb.method_22918(matrix4f2, (float)v0.field_1352, (float)v0.field_1351, (float)v0.field_1350).method_22913(1.0f, 0.0f);
        VersionUtils.nextVertex(bb);
        bb.method_22918(matrix4f2, (float)v1.field_1352, (float)v1.field_1351, (float)v1.field_1350).method_22913(1.0f, 1.0f);
        VersionUtils.nextVertex(bb);
        bb.method_22918(matrix4f2, (float)v2.field_1352, (float)v2.field_1351, (float)v2.field_1350).method_22913(0.0f, 1.0f);
        VersionUtils.nextVertex(bb);
        bb.method_22918(matrix4f2, (float)v3.field_1352, (float)v3.field_1351, (float)v3.field_1350).method_22913(0.0f, 0.0f);
        VersionUtils.nextVertex(bb);
        class_286.method_43433((class_9801)bb.method_60800());
    }

    public static void renderAllTextured(class_287 bufferBuilder, Matrix4f matrix4f2) {
        class_310 client = class_310.method_1551();
        double startDepth = (double)client.field_1773.method_3193() * 3.25;
        double endDepth = (double)client.field_1773.method_3193() * 3.9;
        double stepDepth = (endDepth - startDepth) / (double)textured.size();
        double depth = startDepth;
        for (Star star : textured) {
            star.renderTexture(bufferBuilder, matrix4f2, depth);
            depth += stepDepth;
        }
        if (Star.CONFIG.enableSkybox) {
            SkyboxRenderer.render(bufferBuilder, matrix4f2);
        }
        if (Star.CONFIG.enableDSO) {
            DSRenderer.renderAll(bufferBuilder, matrix4f2, depth);
        }
        GL11.glEnable((int)2929);
    }

    private static class Claim {
        double ra;
        double de;
        double di;

        public Claim(double rightAscension, double declination, double diameter) {
            this.ra = rightAscension;
            this.de = declination;
            this.di = MathFuncs.clamp(diameter / MathFuncs.cos(diameter / 2.0), 1.0E-7, 180.0);
        }

        public boolean isAllowed(Claim newClaim) {
            return this.getEclipsed(newClaim) < 0.9999999;
        }

        public double getEclipsed(Claim newClaim) {
            double moonArea;
            double maximum;
            double sunArea;
            double interHeight;
            double sunLeft = newClaim.ra - newClaim.di / 2.0;
            double sunRight = newClaim.ra + newClaim.di / 2.0;
            double sunBottom = newClaim.de - newClaim.di / 2.0;
            double sunTop = newClaim.de + newClaim.di / 2.0;
            double moonLeft = this.ra - this.di / 2.0;
            double moonRight = this.ra + this.di / 2.0;
            double moonBottom = this.de - this.di / 2.0;
            double moonTop = this.de + this.di / 2.0;
            double interLeft = MathFuncs.max(sunLeft, moonLeft);
            double interRight = MathFuncs.min(sunRight, moonRight);
            double interBottom = MathFuncs.max(sunBottom, moonBottom);
            double interTop = MathFuncs.min(sunTop, moonTop);
            double interWidth = MathFuncs.max(0.0, interRight - interLeft);
            double interArea = interWidth * (interHeight = MathFuncs.max(0.0, interTop - interBottom));
            double eclipsed = MathFuncs.clamp(interArea / (sunArea = newClaim.di * newClaim.di), 0.0, MathFuncs.min(1.0, maximum = (moonArea = this.di * this.di) / sunArea));
            if (Double.isNaN(eclipsed)) {
                return 0.0;
            }
            return eclipsed;
        }
    }

    private static class Sunspot {
        private double x;
        private double y;
        private double size;

        public Sunspot(double x, double y, double size) {
            this.x = x;
            this.y = y;
            this.size = size;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getSize() {
            return this.size;
        }
    }
}

