/*
 * Decompiled with CFR 0.152.
 */
package mod.lwhrvw.astrocraft.config;

import java.util.List;
import java.util.Random;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import mod.lwhrvw.astrocraft.Planet;
import mod.lwhrvw.astrocraft.deepsky.ConfigurableDSO;

@Config(name="astrocraft")
public class AstrocraftConfig
implements ConfigData {
    @ConfigEntry.Category(value="general")
    @ConfigEntry.Gui.Tooltip(count=1)
    @ConfigEntry.BoundedDiscrete(max=6L, min=0L)
    public int magnitudeLimit = 5;
    @ConfigEntry.Category(value="general")
    @ConfigEntry.Gui.Tooltip(count=2)
    public double latitude = -30.0;
    @ConfigEntry.Category(value="stars")
    @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
    public int starOpacity = 100;
    @ConfigEntry.Category(value="stars")
    @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
    public int starColor = 80;
    @ConfigEntry.Category(value="stars")
    public float baseSize = 0.8f;
    @ConfigEntry.Category(value="stars")
    public boolean daytimeStars = false;
    @ConfigEntry.Category(value="stars")
    public boolean roundStars = false;
    @ConfigEntry.Category(value="stars")
    public boolean enableRealStars = true;
    @ConfigEntry.Category(value="stars")
    public boolean enableCustomStars = true;
    @ConfigEntry.Category(value="stars")
    public List<Star> customStars = List.of();
    @ConfigEntry.Category(value="deepsky")
    public boolean enableSkybox = true;
    @ConfigEntry.Category(value="deepsky")
    @ConfigEntry.Gui.Tooltip(count=1)
    public boolean enableDSO = true;
    @ConfigEntry.Category(value="deepsky")
    public double DSOBrightness = 1.0;
    @ConfigEntry.Category(value="deepsky")
    @ConfigEntry.Gui.Tooltip(count=2)
    @ConfigEntry.BoundedDiscrete(max=12L, min=7L)
    @ConfigEntry.Gui.RequiresRestart
    public int spyglassMagnitudeLimit = 11;
    @ConfigEntry.Category(value="deepsky")
    public List<ConfigurableDSO> customDSOs = List.of();
    @ConfigEntry.Category(value="planets")
    public boolean enablePlanets = true;
    @ConfigEntry.Category(value="planets")
    public boolean enableAsteroids = true;
    @ConfigEntry.Category(value="planets")
    @ConfigEntry.Gui.Tooltip(count=2)
    public double yearLength = 365.25;
    @ConfigEntry.Category(value="planets")
    @ConfigEntry.Gui.Tooltip(count=2)
    @ConfigEntry.BoundedDiscrete(max=360L, min=0L)
    public int seasonOffset = 0;
    @ConfigEntry.Category(value="planets")
    @ConfigEntry.Gui.Tooltip(count=1)
    public String observerPlanet = "Earth";
    @ConfigEntry.Category(value="planets")
    public List<ConfigurablePlanet> planets = List.of(new ConfigurablePlanet("Mercury", -0.613, 4879.4, 0.39, 0.240846, 11.2, 0.20563, 0.101, false, new Color(16770244), Planet.Texture.TERRESTIAL, false, Planet.Atmosphere.NONE), new ConfigurablePlanet("Venus", -4.384, 12104.0, 0.723, 0.615198, 5.424, 0.006772, 2.6, false, new Color(255, 255, 247, 1.0f), Planet.Texture.SMOOTH, false, Planet.Atmosphere.THICK), new ConfigurablePlanet("Earth", -3.99, 12742.0, 1.0, 1.0, 1.57869, 0.0167086, 23.45, false, new Color(47, 151, 255, 1.0f), Planet.Texture.TERRESTIAL, false, Planet.Atmosphere.NORMAL, List.of(new ConfigurablePlanet("Moon", 0.28, 8687.0, 0.00257, 0.0748026, 12.86, 0.1098, 6.68, false, new Color(85, 122, 212, 1.0f), Planet.Texture.MOON, false, Planet.Atmosphere.NONE))), new ConfigurablePlanet("Mars", -2.601, 6779.0, 1.524, 1.88085, 1.85, 0.0934, 25.19, false, new Color(0xFF9F3F), Planet.Texture.TERRESTIAL, false, Planet.Atmosphere.NORMAL, List.of(new ConfigurablePlanet("Phobos", 11.7770310244, 23.16, 6.267469E-5, 8.731286E-4, 1.093, 0.0151, 0.0, true, new Color(255, 255, 255, 1.0f), Planet.Texture.TERRESTIAL, false, Planet.Atmosphere.NONE), new ConfigurablePlanet("Deimos", 13.0133921222, 12.54, 1.568E-4, 0.0034579, 0.93, 3.3E-4, 0.0, true, new Color(255, 255, 255, 1.0f), Planet.Texture.TERRESTIAL, false, Planet.Atmosphere.NONE))), new ConfigurablePlanet("Jupiter", -9.395, 139820.0, 5.2, 11.862, 1.31, 0.0484, 3.12, false, new Color(0xFFE99F), Planet.Texture.BANDED, false, Planet.Atmosphere.THICK, List.of(new ConfigurablePlanet("Io", -1.67775163585, 10929.599999999999, 0.01409779425, 0.0048436, 0.05, 0.0, 0.0, true, new Color(255, 255, 64, 1.0f), Planet.Texture.TERRESTIAL, false, Planet.Atmosphere.NONE), new ConfigurablePlanet("Europa", -1.41944836229, 9364.8, 0.02243013209, 0.0097226, 0.471, 0.0, 0.0, true, new Color(239, 239, 255, 1.0f), Planet.Texture.TERRESTIAL, false, Planet.Atmosphere.NONE), new ConfigurablePlanet("Ganymede", -2.074, 15804.599999999999, 0.03577591028, 0.0195881, 0.204, 0.0, 0.0, true, new Color(255, 239, 223, 1.0f), Planet.Texture.TERRESTIAL, false, Planet.Atmosphere.NONE), new ConfigurablePlanet("Callisto", -1.154, 14461.800000000001, 0.062925360875, 0.045692, 0.205, 0.0, 0.0, true, new Color(143, 159, 175, 1.0f), Planet.Texture.TERRESTIAL, false, Planet.Atmosphere.NONE))), new ConfigurablePlanet("Saturn", -8.914, 74898.0, 9.54, 29.4475, 2.49, 0.0541, 26.73, false, new Color(239, 255, 144, 1.0f), Planet.Texture.BANDED, true, Planet.Atmosphere.THICK, List.of(new ConfigurablePlanet("Titan", -2.297, 10299.0, 0.024503089401, 0.043655, 0.34854, 0.02, 0.0, true, new Color(255, 127, 0, 1.0f), Planet.Texture.SMOOTH, false, Planet.Atmosphere.NORMAL), new ConfigurablePlanet("Iapetus", 0.538, 2936.0, 0.07140783456, 0.2171704, 17.28, 0.02768, 0.0, false, new Color(255, 255, 255, 1.0f), Planet.Texture.TERRESTIAL, false, Planet.Atmosphere.NONE), new ConfigurablePlanet("Rhea", -0.244, 3058.0, 0.01057049805, 0.0123701, 0.0, 0.00126, 0.0, true, new Color(255, 255, 255, 1.0f), Planet.Texture.TERRESTIAL, false, Planet.Atmosphere.NONE), new ConfigurablePlanet("Dione", 0.422, 2245.6, 0.00756820932, 0.0074932, 0.0, 0.0022, 0.0, true, new Color(255, 255, 255, 1.0f), Planet.Texture.TERRESTIAL, false, Planet.Atmosphere.NONE), new ConfigurablePlanet("Tethys", 1.0, 2124.0, 0.005908219110000001, 0.00516852, 0.0, 0.0, 0.0, true, new Color(255, 255, 255, 1.0f), Planet.Texture.TERRESTIAL, false, Planet.Atmosphere.NONE))), new ConfigurablePlanet("Uranus", -7.11, 51118.0, 19.8, 84.0205, 0.77, 0.0472, 82.1, false, new Color(47, 208, 255, 1.0f), Planet.Texture.SMOOTH, false, Planet.Atmosphere.NORMAL, List.of(new ConfigurablePlanet("Titania", 0.155, 1576.8, 0.00291387837, 0.0238363, 0.34, 0.0, 0.0, true, new Color(255, 239, 223, 1.0f), Planet.Texture.TERRESTIAL, false, Planet.Atmosphere.NONE), new ConfigurablePlanet("Oberon", 1.048, 1522.8, 0.00390059028, 0.03686031485, 0.058, 0.0, 0.0, true, new Color(255, 223, 207, 1.0f), Planet.Texture.TERRESTIAL, false, Planet.Atmosphere.NONE))), new ConfigurablePlanet("Neptune", -7.0, 49244.0, 30.0, 164.8, 1.77, 0.0086, 29.56, false, new Color(47, 64, 255, 1.0f), Planet.Texture.SMOOTH, false, Planet.Atmosphere.NORMAL, List.of(new ConfigurablePlanet("Triton", -1.2, 2706.8, 0.00237, -0.016089949, 50.188, 0.0, 0.0, false, new Color(223, 239, 255, 1.0f), Planet.Texture.SMOOTH, false, Planet.Atmosphere.THIN))), new ConfigurablePlanet("Pluto", -0.45, 2376.6, 39.48, 247.94, 17.14, 0.2488, 29.6, false, new Color(255, 255, 255, 1.0f), Planet.Texture.TERRESTIAL, false, Planet.Atmosphere.THIN, List.of(new ConfigurablePlanet("Charon", 1.0, 1212.0, 1.31E-4, 0.017487, 0.08, 2.0E-4, 0.0, true, new Color(255, 255, 255, 1.0f), Planet.Texture.MOON, false, Planet.Atmosphere.NONE))));
    @ConfigEntry.Category(value="planets")
    @ConfigEntry.Gui.CollapsibleObject
    public ConfigurablePlanet.Appearance sunAppearance = new ConfigurablePlanet.Appearance(4.83, Planet.Texture.SUN, false, new Color(212, 212, 85, 1.0f), 3481750.0, null);
    @ConfigEntry.Category(value="planets")
    @ConfigEntry.Gui.Tooltip(count=1)
    public boolean bigPlanets = false;
    @ConfigEntry.Category(value="overlay")
    public boolean showConstellations = false;
    @ConfigEntry.Category(value="overlay")
    public boolean showEquatorialGrid = false;
    @ConfigEntry.Category(value="overlay")
    public boolean showEquator = false;
    @ConfigEntry.Category(value="overlay")
    public boolean showEcliptic = false;
    @ConfigEntry.Category(value="overlay")
    public boolean showZodiac = false;
    @ConfigEntry.Category(value="misc")
    public boolean enableSunspots = true;
    @ConfigEntry.Category(value="misc")
    @ConfigEntry.BoundedDiscrete(min=1L, max=50L)
    @ConfigEntry.Gui.Tooltip(count=3)
    public int diameterScale = 16;
    @ConfigEntry.Category(value="misc")
    public boolean enableMeteors = true;
    @ConfigEntry.Category(value="misc")
    @ConfigEntry.BoundedDiscrete(min=0L, max=1000L)
    public int totalMeteors = 100;
    @ConfigEntry.Category(value="misc")
    @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
    public int sporadicMeteors = 6;
    @ConfigEntry.Category(value="misc")
    @ConfigEntry.Gui.Tooltip(count=1)
    public boolean angledSky = true;
    @ConfigEntry.Category(value="misc")
    @ConfigEntry.BoundedDiscrete(min=0L, max=512L)
    public int spaceStart = 180;
    @ConfigEntry.Category(value="misc")
    @ConfigEntry.BoundedDiscrete(min=0L, max=4096L)
    public int spaceHeight = 2048;
    @ConfigEntry.Category(value="misc")
    @ConfigEntry.Gui.Tooltip(count=1)
    public boolean legacyMoon = false;
    @ConfigEntry.Category(value="misc")
    @ConfigEntry.Gui.CollapsibleObject
    public LegacyMoon legacyMoonOptions = new LegacyMoon();
    @ConfigEntry.Category(value="advanced")
    @ConfigEntry.Gui.Tooltip(count=1)
    @ConfigEntry.Gui.RequiresRestart
    public boolean enableConfigMenu = true;
    @ConfigEntry.Category(value="advanced")
    @ConfigEntry.Gui.Tooltip(count=2)
    public int updateTime = 200;
    @ConfigEntry.Category(value="advanced")
    public boolean useWorldSeed = false;
    @ConfigEntry.Category(value="advanced")
    @ConfigEntry.BoundedDiscrete(max=100L, min=0L)
    public int ambientLight = 10;
    @ConfigEntry.Category(value="advanced")
    public float maxSizeMultiplier = 0.4f;
    @ConfigEntry.Category(value="advanced")
    public float starBrightnessBase = 15.0f;
    @ConfigEntry.Category(value="advanced")
    public float starBrightnessModifier = 0.75f;
    @ConfigEntry.Category(value="advanced")
    public boolean deadzone = true;
    @ConfigEntry.Category(value="advanced")
    public int updateOffset = 0;
    @ConfigEntry.Category(value="advanced")
    public double copyCount = 64.0;
    @ConfigEntry.Category(value="advanced")
    public double copyRange = 4.0E-4;
    @ConfigEntry.Category(value="advanced")
    public double copyPower = 1.3;
    @ConfigEntry.Category(value="advanced")
    @ConfigEntry.Gui.Tooltip(count=1)
    public boolean disableSpyglassMagnitudeBonus = false;
    @ConfigEntry.Category(value="advanced")
    public boolean enableSpyglassCulling = true;
    @ConfigEntry.Category(value="advanced")
    public boolean globeMode = false;
    @ConfigEntry.Category(value="advanced")
    public boolean timezones = false;
    @ConfigEntry.Category(value="advanced")
    @ConfigEntry.Gui.CollapsibleObject
    public Globe earthGlobe = new Globe();
    @ConfigEntry.Category(value="advanced")
    @ConfigEntry.Gui.Tooltip(count=1)
    public boolean simulateAtmosphere = false;
    @ConfigEntry.Category(value="advanced")
    public boolean preventSunStarRendering = false;
    @ConfigEntry.Category(value="advanced")
    public double gridStep = 5.0;
    @ConfigEntry.Category(value="advanced")
    public double debugX = 0.0;
    @ConfigEntry.Category(value="advanced")
    public double debugY = 0.0;
    @ConfigEntry.Category(value="advanced")
    public double debugZ = 0.0;

    public static class ConfigurablePlanet {
        public String name;
        @ConfigEntry.Gui.CollapsibleObject
        public Orbit orbit;
        @ConfigEntry.Gui.CollapsibleObject
        public Appearance appearance;
        public List<ConfigurablePlanet> moons = List.of();
        @ConfigEntry.Gui.Excluded
        public int seed = 0;

        public ConfigurablePlanet() {
            this("", -2.0, 0.0, 1.0, 1.0, 0.0, 0.0, 23.45, false, new Color(), Planet.Texture.NONE, false, null);
            this.seed = new Random().nextInt();
        }

        public ConfigurablePlanet(String pname, double magn, double diam, double sma, double per, double inc, double ecc, double obl, boolean equ, Color col, Planet.Texture tx, boolean r, Planet.Atmosphere atmos) {
            this.name = pname;
            this.seed = pname.hashCode();
            this.orbit = new Orbit(sma, per, inc, ecc, obl, equ);
            this.appearance = new Appearance(magn, tx, r, col, diam, atmos);
        }

        public ConfigurablePlanet(String pname, double magn, double diam, double sma, double per, double inc, double ecc, double obl, boolean equ, Color col, Planet.Texture tx, boolean r, Planet.Atmosphere atmos, List<ConfigurablePlanet> moonls) {
            this(pname, magn, diam, sma, per, inc, ecc, obl, equ, col, tx, r, atmos);
            this.moons = moonls;
        }

        public String toString() {
            return this.name;
        }

        public static class Orbit {
            @ConfigEntry.Gui.Tooltip(count=1)
            public double semiMajorAxis;
            @ConfigEntry.Gui.Tooltip(count=1)
            public double period;
            public double inclination;
            public double eccentricity;
            @ConfigEntry.Gui.Excluded
            public double obliquity;
            @ConfigEntry.Gui.Excluded
            public boolean equatorial;

            public Orbit(double sma, double per, double inc, double ecc, double obl, boolean equ) {
                this.semiMajorAxis = sma;
                this.period = per;
                this.inclination = inc;
                this.eccentricity = ecc;
                this.obliquity = obl;
                this.equatorial = equ;
            }

            public Orbit() {
                this(1.0, 1.0, 0.0, 0.0, 23.45, false);
            }
        }

        public static class Appearance {
            @ConfigEntry.Gui.Tooltip(count=1)
            public double magnitude;
            @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
            public Planet.Texture texture;
            public boolean rings;
            @ConfigEntry.Gui.TransitiveObject
            public Color color;
            @ConfigEntry.Gui.Excluded
            public double diameter;
            @ConfigEntry.Gui.Excluded
            public Planet.Atmosphere atmosphere;

            public Appearance(double mag, Planet.Texture tx, boolean r, Color clr, double diam, Planet.Atmosphere atmos) {
                this.magnitude = mag;
                this.texture = tx;
                this.rings = r;
                this.color = clr;
                this.diameter = diam;
                this.atmosphere = atmos;
            }

            public Appearance() {
                this(-2.0, Planet.Texture.NONE, false, new Color(), 0.0, null);
            }
        }
    }

    public static class Color {
        @ConfigEntry.BoundedDiscrete(max=255L)
        public int red;
        @ConfigEntry.BoundedDiscrete(max=255L)
        public int green;
        @ConfigEntry.BoundedDiscrete(max=255L)
        public int blue;
        @ConfigEntry.Gui.Excluded
        public float alpha;

        public Color() {
            this(255, 255, 255, 1.0f);
        }

        public Color(int red, int green, int blue, float alpha) {
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha;
        }

        public Color(int rgb) {
            this.red = (rgb & 0xFF0000) >> 16;
            this.green = (rgb & 0xFF00) >> 8;
            this.blue = (rgb & 0xFF) >> 0;
            this.alpha = 1.0f;
        }

        public float getRed() {
            return (float)this.red / 255.0f;
        }

        public float getGreen() {
            return (float)this.green / 255.0f;
        }

        public float getBlue() {
            return (float)this.blue / 255.0f;
        }

        public String toString() {
            return String.format("%d,%d,%d,%f", this.red, this.green, this.blue, Float.valueOf(this.alpha));
        }
    }

    public static class LegacyMoon {
        @ConfigEntry.Category(value="advanced")
        @ConfigEntry.Gui.Tooltip(count=1)
        public double monthLength = 8.0;
        @ConfigEntry.Category(value="advanced")
        @ConfigEntry.Gui.Tooltip(count=1)
        public boolean enableMovement = true;
        @ConfigEntry.Category(value="advanced")
        public double moonInclination = 12.875;
        @ConfigEntry.Category(value="advanced")
        public boolean enableEclipses = false;
        @ConfigEntry.Category(value="advanced")
        public boolean hideNewMoon = true;
        @ConfigEntry.Category(value="advanced")
        @ConfigEntry.BoundedDiscrete(max=100L, min=0L)
        public int sunLight = 100;
        @ConfigEntry.Category(value="advanced")
        @ConfigEntry.BoundedDiscrete(max=100L, min=0L)
        public int moonLight = 20;
    }

    public static class Globe {
        public double meridianX = 0.0;
        public double equatorZ = 0.0;
        public double blocks90 = 16500.0;
    }

    public static class Star {
        public String name = "";
        public double magn = 0.0;
        public double ra = 0.0;
        public double de = 0.0;
        public double dist = 0.0;
        @ConfigEntry.Gui.TransitiveObject
        public Color color = new Color();
    }
}

