/*
 * Decompiled with CFR 0.152.
 */
package mod.lwhrvw.astrocraft.config;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Scanner;
import mod.lwhrvw.astrocraft.Astrocraft;
import mod.lwhrvw.astrocraft.config.AstrocraftConfig;

public class AstrocraftList {
    private static final AstrocraftConfig CONFIG = Astrocraft.CONFIG;
    private ArrayList<double[]> stars = new ArrayList();
    private ArrayList<double[]> cstars = new ArrayList();
    private ArrayList<double[]> planets = new ArrayList();

    public void loadStars(InputStream stream) {
        this.stars.clear();
        try (Scanner scanner = new Scanner(stream);){
            while (scanner.hasNextLine()) {
                String str = scanner.nextLine();
                String[] data = str.split(" ");
                double magn = Double.parseDouble(data[0]);
                double ra = (Double.parseDouble(data[1]) + 180.0) % 360.0;
                double de = Double.parseDouble(data[2]);
                double red = Double.parseDouble(data[3]);
                double green = Double.parseDouble(data[4]);
                double blue = Double.parseDouble(data[5]);
                int i = 0;
                while ((double)i < AstrocraftList.CONFIG.copyCount) {
                    double ara = ra + (Math.random() * 2.0 - 1.0) * AstrocraftList.CONFIG.copyRange;
                    double ade = de + (Math.random() * 2.0 - 1.0) * AstrocraftList.CONFIG.copyRange;
                    double[] star = new double[]{magn, ara, ade, red, green, blue};
                    this.stars.add(star);
                    ++i;
                }
            }
            scanner.close();
            this.cstars.clear();
        }
        catch (Exception e) {
            System.out.println("An error occurred.");
            e.printStackTrace();
        }
    }

    private void loadCustomStars() {
        this.cstars.clear();
        for (AstrocraftConfig.Star star : AstrocraftList.CONFIG.customStars) {
            if (star.magn > Astrocraft.getMagnitudeLimit()) continue;
            int i = 0;
            while ((double)i < AstrocraftList.CONFIG.copyCount) {
                double ara = star.ra + (Math.random() * 2.0 - 1.0) * AstrocraftList.CONFIG.copyRange;
                double ade = star.de + (Math.random() * 2.0 - 1.0) * AstrocraftList.CONFIG.copyRange;
                double[] starray = new double[]{star.magn, ara, ade, star.color.getRed(), star.color.getGreen(), star.color.getBlue()};
                this.cstars.add(starray);
                ++i;
            }
        }
    }

    private void genPlanetArray(AstrocraftConfig.ConfigurablePlanet planet, double[] parent) {
        AstrocraftConfig.Color color = planet.appearance.color;
        double red = color.getRed();
        double green = color.getGreen();
        double blue = color.getBlue();
        double dist = planet.orbit.semiMajorAxis;
        double year = planet.orbit.period;
        double inc = planet.orbit.inclination;
        double[] planetArray = new double[]{red, green, blue, dist, year, inc};
        double[] both = Arrays.copyOf(planetArray, planetArray.length + parent.length);
        System.arraycopy(parent, 0, both, planetArray.length, parent.length);
        this.planets.add(both);
    }

    private void genPlanetArray(AstrocraftConfig.ConfigurablePlanet planet) {
        this.genPlanetArray(planet, new double[0]);
    }

    private void loadPlanets() {
        this.planets.clear();
        for (AstrocraftConfig.ConfigurablePlanet planet : AstrocraftList.CONFIG.planets) {
            this.genPlanetArray(planet);
        }
    }

    public AstrocraftList() {
        this.loadCustomStars();
        this.loadPlanets();
    }

    public ArrayList<double[]> getStars() {
        return this.stars;
    }

    public ArrayList<double[]> getCustomStars() {
        this.loadCustomStars();
        return this.cstars;
    }

    public ArrayList<double[]> getPlanets() {
        this.loadPlanets();
        return this.planets;
    }
}

