/*
 * Decompiled with CFR 0.152.
 */
package mod.lwhrvw.astrocraft.deepsky;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import mod.lwhrvw.astrocraft.Astrocraft;
import mod.lwhrvw.astrocraft.MathFuncs;
import mod.lwhrvw.astrocraft.VersionUtils;
import mod.lwhrvw.astrocraft.deepsky.ConfigurableDSO;
import mod.lwhrvw.astrocraft.deepsky.DSO;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_7833;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;

public class DSRenderer
extends MathFuncs {
    private static List<DSO> dsos = List.of(new DSO("lmc", 1.6, DSRenderer.cra(5.0, 23.0, 34.0), DSRenderer.cdeg(-69.0, -45.4), -82.0, 10.75, 10.75), new DSO("smc", 3.7, DSRenderer.cra(0.0, 52.0, 44.8), DSRenderer.cdeg(-72.0, -49.0, -43.0), 13.0, 5.2, 5.2), new DSO("andromeda", 2.4, DSRenderer.cra(0.0, 42.0, 44.3), DSRenderer.cdeg(41.0, 16.0, 9.0), 45.0, 1.9670807453416146, 1.475310559006211), new DSO("orion", 4.0, DSRenderer.cra(5.0, 35.0, 17.3), DSRenderer.cdeg(-5.0, -23.0, -28.0), 0.0, 1.4, 1.8), new DSO("lagoon", 4.6, DSRenderer.cra(18.0, 3.0, 37.0), DSRenderer.cdeg(-24.0, -23.0, -12.0), 0.0, 1.5, 1.5), new DSO("gsc", 5.1, DSRenderer.cra(18.0, 36.0, 23.94), DSRenderer.cdeg(-23.0, -54.0, -17.1), 0.0, 0.5, 0.5), new DSO("globular", 5.6, DSRenderer.cra(16.0, 23.0, 35.22), DSRenderer.cdeg(-26.0, -31.0, -32.7), 50.0, 0.43333333333333335, 0.43333333333333335), new DSO("globular", 5.6, DSRenderer.cra(15.0, 18.0, 33.22), DSRenderer.cdeg(2.0, 4.0, 51.7), 100.0, 0.38333333333333336, 0.38333333333333336), new DSO("triangulum", 5.7, DSRenderer.cra(1.0, 33.0, 50.02), DSRenderer.cdeg(30.0, 39.0, 36.7), 0.0, 1.0, 1.0), new DSO("globular", 5.8, DSRenderer.cra(16.0, 41.0, 41.24), DSRenderer.cdeg(36.0, 27.0, 35.5), 70.0, 0.3333333333333333, 0.3333333333333333), new DSO("omega", 6.0, DSRenderer.cra(18.0, 20.0, 26.0), DSRenderer.cdeg(-16.0, -10.0, -36.0), -35.0, 0.18333333333333332, 0.18333333333333332), new DSO("globular", 6.2, DSRenderer.cra(13.0, 42.0, 11.62), DSRenderer.cdeg(28.0, 22.0, 38.2), 90.0, 0.3, 0.3), new DSO("globular", 6.2, DSRenderer.cra(21.0, 29.0, 58.33), DSRenderer.cdeg(12.0, 10.0, 1.2), 101.0, 0.3, 0.3), new DSO("trifid", 4.3, DSRenderer.cra(18.0, 2.0, 23.0), DSRenderer.cdeg(-23.0, -1.0, -48.0), 0.0, 0.4666666666666667, 0.4666666666666667), new DSO("globular", 6.3, DSRenderer.cra(19.0, 39.0, 59.71), DSRenderer.cdeg(-30.0, -57.0, -53.1), 111.0, 0.31666666666666665, 0.31666666666666665), new DSO("eagle", 6.4, DSRenderer.cra(18.0, 18.0, 48.0), DSRenderer.cdeg(-13.0, -49.0), 0.0, 1.1666666666666667, 0.8333333333333334), new DSO("globular", 6.4, DSRenderer.cra(17.0, 17.0, 7.39), DSRenderer.cdeg(43.0, 8.0, 9.4), 151.0, 0.23333333333333334, 0.23333333333333334), new DSO("globular", 6.5, DSRenderer.cra(21.0, 33.0, 27.02), DSRenderer.cdeg(0.0, -49.0, -23.7), 141.0, 0.26666666666666666, 0.26666666666666666), new DSO("globular", 6.5, DSRenderer.cra(17.0, 1.0, 12.6), DSRenderer.cdeg(-30.0, -6.0, -44.5), 131.0, 0.25, 0.25), new DSO("globular", 6.6, DSRenderer.cra(16.0, 57.0, 8.92), DSRenderer.cdeg(-4.0, -5.0, -58.07), 124.0, 0.3333333333333333, 0.3333333333333333), new DSO("globular", 6.7, DSRenderer.cra(16.0, 47.0, 14.18), DSRenderer.cdeg(-1.0, -56.0, -54.7), 156.0, 0.26666666666666666, 0.26666666666666666), new DSO("globular", 6.8, DSRenderer.cra(17.0, 2.0, 37.69), DSRenderer.cdeg(-26.0, -16.0, -4.6), 156.0, 0.2833333333333333, 0.2833333333333333), new DSO("globular", 6.8, DSRenderer.cra(18.0, 24.0, 32.89), DSRenderer.cdeg(-24.0, -52.0, -11.4), 160.0, 0.18666666666666665, 0.18666666666666665), new DSO("bodes", 6.9, DSRenderer.cra(9.0, 55.0, 33.2), DSRenderer.cdeg(69.0, 3.0, 55.0), -80.0, 0.4483333333333333, 0.235), new DSO("globular", 7.2, DSRenderer.cra(21.0, 40.0, 22.12), DSRenderer.cdeg(-23.0, -10.0, -47.5), 0.0, 0.2, 0.2), new DSO("globular", 7.3, DSRenderer.cra(16.0, 17.0, 2.41), DSRenderer.cdeg(-22.0, -58.0, -33.9), 10.0, 0.16666666666666666, 0.16666666666666666), new DSO("dumbbell", 7.4, DSRenderer.cra(19.0, 59.0, 36.34), DSRenderer.cdeg(22.0, 43.0, 16.09), 0.0, 0.13333333333333333, 0.10833333333333334), new DSO("globular", 7.6, DSRenderer.cra(17.0, 37.0, 36.15), DSRenderer.cdeg(-3.0, -14.0, -45.3), 19.0, 0.18333333333333332, 0.18333333333333332), new DSO("globular", 7.6, DSRenderer.cra(14.0, 12.0, 55.25), DSRenderer.cdeg(18.0, 10.0, 5.4), 28.0, 0.21666666666666667, 0.21666666666666667), new DSO("globular", 7.6, DSRenderer.cra(18.0, 55.0, 3.33), DSRenderer.cdeg(-30.0, -28.0, -47.5), 37.0, 0.2, 0.2), new DSO("globular", 7.6, DSRenderer.cra(18.0, 31.0, 23.1), DSRenderer.cdeg(-32.0, -20.0, -53.1), 46.0, 0.18000000000000002, 0.18000000000000002), new DSO("southern_pinwheel", 7.6, DSRenderer.cra(13.0, 37.0, 0.9), DSRenderer.cdeg(-29.0, -51.0, -57.0), 0.0, 0.2, 0.2), new DSO("globular", 7.7, DSRenderer.cra(17.0, 19.0, 11.78), DSRenderer.cdeg(-18.0, -30.0, -58.5), 119.0, 0.155, 0.155), new DSO("globular", 7.7, DSRenderer.cra(5.0, 24.0, 10.59), DSRenderer.cdeg(-24.0, -31.0, -27.3), 128.0, 0.145, 0.145), new DSO("globular", 7.8, DSRenderer.cra(12.0, 39.0, 27.98), DSRenderer.cdeg(-26.0, -44.0, -38.6), 137.0, 0.18333333333333332, 0.18333333333333332), new DSO("globular", 7.9, DSRenderer.cra(18.0, 43.0, 12.76), DSRenderer.cdeg(-32.0, -17.0, -31.6), 146.0, 0.13333333333333333, 0.13333333333333333), new DSO("pinwheel", 7.9, DSRenderer.cra(14.0, 3.0, 12.6), DSRenderer.cdeg(53.0, 20.0, 56.0), -150.0, 0.4666666666666667, 0.36666666666666664), new DSO("whirlpool", 6.1, DSRenderer.cra(13.0, 29.0, 50.82), DSRenderer.cdeg(47.0, 11.0, 47.6), -110.0, 0.6666666666666666, 0.5), new DSO("crab", 7.4, DSRenderer.cra(5.0, 34.0, 31.94), DSRenderer.cdeg(22.0, 0.0, 52.2), -42.86, 0.11666666666666667, 0.11666666666666667), new DSO("ring", 7.800000000000001, DSRenderer.cra(18.0, 53.0, 35.079), DSRenderer.cdeg(33.0, 1.0, 45.03), 0.0, 0.06388888888888888, 0.06388888888888888));
    private static class_287 bufferBuilder;
    private static Matrix4f matrix;
    private static double depth;

    public static void add(DSO dso) {
        dsos.add(dso);
    }

    private static void setState(class_287 bb, Matrix4f matrix4f2, double d) {
        bufferBuilder = bb;
        matrix = matrix4f2;
        depth = d;
    }

    private static Matrix4f getMatrix(DSO dso) {
        Matrix4f mat = new Matrix4f((Matrix4fc)matrix);
        mat.rotate((Quaternionfc)class_7833.field_40714.rotationDegrees((float)(180.0 - dso.getRA() + Astrocraft.getTropicalAngle())));
        mat.rotate((Quaternionfc)class_7833.field_40717.rotationDegrees((float)dso.getDE()));
        mat.rotate((Quaternionfc)class_7833.field_40715.rotationDegrees((float)dso.getOrientation()));
        return mat;
    }

    private static void genVertices(DSO dso, class_287 bb, Matrix4f matrix) {
        double w = depth * DSRenderer.tan(dso.getWidth() / 2.0);
        double h = depth * DSRenderer.tan(dso.getHeight() / 2.0);
        bb.method_22918(matrix, (float)(-h), (float)(-depth), (float)w).method_22913(0.0f, 0.0f);
        VersionUtils.nextVertex(bb);
        bb.method_22918(matrix, (float)h, (float)(-depth), (float)w).method_22913(0.0f, 1.0f);
        VersionUtils.nextVertex(bb);
        bb.method_22918(matrix, (float)h, (float)(-depth), (float)(-w)).method_22913(1.0f, 1.0f);
        VersionUtils.nextVertex(bb);
        bb.method_22918(matrix, (float)(-h), (float)(-depth), (float)(-w)).method_22913(1.0f, 0.0f);
        VersionUtils.nextVertex(bb);
    }

    private static void render(DSO dso) {
        try {
            RenderSystem.setShaderTexture((int)0, (class_2960)dso.getTexture());
        }
        catch (Exception e) {
            RenderSystem.setShaderTexture((int)0, (class_2960)class_2960.method_60655((String)"astrocraft", (String)"textures/placeholder.png"));
        }
        class_287 bb = VersionUtils.setupBuffer(bufferBuilder, class_293.class_5596.field_27382, class_290.field_1585);
        float b = (float)dso.getBrightness();
        float v = Astrocraft.getDeepskyVisibility();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(v * b));
        DSRenderer.genVertices(dso, bb, DSRenderer.getMatrix(dso));
        class_286.method_43433((class_9801)bb.method_60800());
    }

    public static void renderAll(class_287 bufferBuilder, Matrix4f matrix4f2, double depth) {
        DSRenderer.setState(bufferBuilder, matrix4f2, depth);
        for (DSO dso : dsos) {
            if (!(dso.getMagnitude() < Astrocraft.getMagnitudeLimit() + Astrocraft.getSpyglassMagnitudeBonus())) continue;
            DSRenderer.render(dso);
        }
        for (ConfigurableDSO cdso : Astrocraft.CONFIG.customDSOs) {
            DSO dso = cdso.genDSO();
            if (!(dso.getMagnitude() < Astrocraft.getMagnitudeLimit() + Astrocraft.getSpyglassMagnitudeBonus())) continue;
            DSRenderer.render(dso);
        }
    }
}

