/*
 * Decompiled with CFR 0.152.
 */
package mod.lwhrvw.astrocraft.meteors;

import mod.lwhrvw.astrocraft.Astrocraft;
import mod.lwhrvw.astrocraft.MathFuncs;
import mod.lwhrvw.astrocraft.VersionUtils;
import net.minecraft.class_287;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class Meteor
extends MathFuncs {
    private final double START = 0.065;
    private final double LENGTH = 0.51;
    private final double WIDTH = 5.0E-6;
    private final double THRESHOLD = 0.99;
    private double start;
    private double alpha;
    private Vector3d radiant;
    private Vector3d direction;
    private Vector3d color;

    public Meteor(double time, double alpha, Vector3d radiant, Vector3d direction, Vector3d color) {
        this.start = time;
        this.alpha = alpha;
        this.radiant = radiant;
        this.direction = direction;
        this.color = color;
    }

    public double getStart() {
        return this.start;
    }

    public double getDuration() {
        return Meteor.clamp(Meteor.cbrt(this.alpha) * 6.0 / Meteor.cbrt(1.0 - this.alpha), 0.35, 100.0);
    }

    public double getElapsed(double time) {
        return (time - this.start) / this.getDuration();
    }

    public boolean isBegun(double time) {
        return time >= this.start;
    }

    public boolean isFinished(double time) {
        return this.getElapsed(time) >= 1.0;
    }

    public Vector3d getRadiant() {
        return new Vector3d((Vector3dc)this.radiant).mul(100.0);
    }

    public Vector3d getColor() {
        if (Astrocraft.CONFIG.starColor >= 20) {
            return this.color;
        }
        return new Vector3d(1.0, 1.0, 1.0);
    }

    public Vector3d getPosition(double time) {
        double elapsed = this.getElapsed(time);
        double x = this.radiant.x + this.direction.x * (elapsed * 0.51 + 0.065);
        double y = this.radiant.y + this.direction.y * (elapsed * 0.51 + 0.065);
        double z = this.radiant.z + this.direction.z * (elapsed * 0.51 + 0.065);
        return new Vector3d(x, y, z).normalize();
    }

    public void renderLine(class_287 bufferBuilder, Matrix4f matrix4f2, double time) {
        if (!this.isBegun(time) || this.alpha >= 0.99) {
            return;
        }
        Vector3d color = this.getColor();
        Vector3d radiant = this.getRadiant();
        bufferBuilder.method_22918(matrix4f2, (float)radiant.x, (float)radiant.y, (float)radiant.z).method_22915(0.0f, 0.0f, 0.0f, 0.0f);
        VersionUtils.nextVertex(bufferBuilder);
        Vector3d end = this.getPosition(time).mul(100.0);
        float v = Astrocraft.getVisibility();
        bufferBuilder.method_22918(matrix4f2, (float)end.x, (float)end.y, (float)end.z).method_22915((float)color.x, (float)color.y, (float)color.z, (float)(this.alpha * this.alpha) * v * v);
        VersionUtils.nextVertex(bufferBuilder);
    }

    public void renderTriangle(class_287 bufferBuilder, Matrix4f matrix4f2, double time) {
        if (!this.isBegun(time) || this.alpha < 0.99) {
            return;
        }
        Vector3d radiant = this.getRadiant();
        Vector3d color = this.getColor();
        bufferBuilder.method_22918(matrix4f2, (float)radiant.x, (float)radiant.y, (float)radiant.z).method_22915(0.0f, 0.0f, 0.0f, 0.0f);
        VersionUtils.nextVertex(bufferBuilder);
        Vector3d end = this.getPosition(time);
        Vector3d cross = new Vector3d((Vector3dc)radiant).cross((Vector3dc)end);
        cross.mul(5.0E-6 / Math.cbrt(1.0 - this.alpha));
        Vector3d end1 = new Vector3d((Vector3dc)end).add((Vector3dc)cross).normalize().mul(100.0);
        Vector3d end2 = new Vector3d((Vector3dc)end).sub((Vector3dc)cross).normalize().mul(100.0);
        float v = Astrocraft.getVisibility();
        bufferBuilder.method_22918(matrix4f2, (float)end1.x, (float)end1.y, (float)end1.z).method_22915((float)color.x, (float)color.y, (float)color.z, (float)(this.alpha * this.alpha) * v * v);
        VersionUtils.nextVertex(bufferBuilder);
        bufferBuilder.method_22918(matrix4f2, (float)end2.x, (float)end2.y, (float)end2.z).method_22915((float)color.x, (float)color.y, (float)color.z, (float)(this.alpha * this.alpha) * v * v);
        VersionUtils.nextVertex(bufferBuilder);
    }
}

