/*
 * Decompiled with CFR 0.152.
 */
package mod.lwhrvw.astrocraft.meteors;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Random;
import mod.lwhrvw.astrocraft.Astrocraft;
import mod.lwhrvw.astrocraft.meteors.Meteor;
import mod.lwhrvw.astrocraft.meteors.MeteorShower;
import org.joml.Vector3d;

public class MeteorGenerator {
    private static Random rand = new Random("METEOR".hashCode());
    private static ArrayList<Meteor> queue = new ArrayList();
    private static int queueIndex = 0;
    private static ArrayList<Meteor> active = new ArrayList();
    private static long lastDay = 0L;

    private static double randomSignedDouble() {
        return rand.nextDouble(-1.0, 1.0);
    }

    private static Vector3d randomVector3d() {
        return new Vector3d(MeteorGenerator.randomSignedDouble(), MeteorGenerator.randomSignedDouble(), MeteorGenerator.randomSignedDouble());
    }

    private static Meteor genSporadic(double time) {
        Vector3d radiant = MeteorGenerator.randomVector3d();
        return MeteorGenerator.genRandom(time, radiant);
    }

    private static Meteor genRandom(double time, Vector3d radiant) {
        double alpha = rand.nextDouble();
        Vector3d direction = MeteorGenerator.randomVector3d();
        Vector3d color = MeteorGenerator.randomVector3d();
        color.x = 0.8 + 0.2 * Math.cbrt(Math.abs(color.x));
        color.y = 0.75 + 0.25 * Math.cbrt(Math.abs(color.y));
        color.z = 0.7 + 0.3 * Math.cbrt(Math.abs(color.z));
        return new Meteor(time, alpha, radiant, direction, color.normalize());
    }

    private static double randomStartTime() {
        return 24000.0 * (double)lastDay - 18000.0 + 24000.0 * rand.nextDouble();
    }

    public static long calcToday() {
        return (Astrocraft.getWorldTime() + 18000L) / 24000L;
    }

    public static boolean shouldGenForNight() {
        long today = MeteorGenerator.calcToday();
        return today != lastDay;
    }

    public static void sortMeteors(ArrayList<Meteor> ls) {
        ls.sort(new Comparator<Meteor>(){

            @Override
            public int compare(Meteor ls, Meteor rs) {
                return ls.getStart() > rs.getStart() ? 1 : (ls.getStart() < rs.getStart() ? -1 : 0);
            }
        });
    }

    public static void genForNight() {
        double MINSPERDAY = 20.0;
        double BASE_INTENSITY = 0.1;
        lastDay = MeteorGenerator.calcToday();
        rand = new Random((long)"METEOR".hashCode() + lastDay);
        queue.clear();
        active.clear();
        for (MeteorShower shower : MeteorShower.SHOWERS) {
            if (!shower.isActive()) continue;
            double intensity = shower.getIntensity();
            long count = Math.round(intensity * 0.1 * 20.0 * ((double)Astrocraft.CONFIG.totalMeteors / 100.0));
            Vector3d radiant = shower.getRadiant();
            for (long i = 0L; i < count; ++i) {
                queue.add(MeteorGenerator.genRandom(MeteorGenerator.randomStartTime(), radiant));
            }
        }
        long count = Math.round((double)Astrocraft.CONFIG.sporadicMeteors * 0.1 * 20.0 * ((double)Astrocraft.CONFIG.totalMeteors / 100.0));
        for (long i = 0L; i < count; ++i) {
            queue.add(MeteorGenerator.genSporadic(MeteorGenerator.randomStartTime()));
        }
        MeteorGenerator.sortMeteors(queue);
        queueIndex = 0;
    }

    private static Meteor popMeteor(double time) {
        if (queueIndex >= queue.size()) {
            return null;
        }
        Meteor meteor = queue.get(queueIndex);
        if (meteor.isBegun(time)) {
            ++queueIndex;
            return meteor;
        }
        return null;
    }

    public static ArrayList<Meteor> getActive(double time) {
        Meteor meteor;
        while ((meteor = MeteorGenerator.popMeteor(time)) != null) {
            active.add(meteor);
        }
        for (Meteor am : (ArrayList)active.clone()) {
            if (!am.isFinished(time)) continue;
            active.remove(am);
        }
        return active;
    }
}

