/*
 * Decompiled with CFR 0.152.
 */
package mod.lwhrvw.astrocraft.mixin;

import mod.lwhrvw.astrocraft.Astrocraft;
import mod.lwhrvw.astrocraft.Star;
import mod.lwhrvw.astrocraft.config.AstrocraftConfig;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_638.class})
public class MixinClientWorld {
    @Unique
    private static final AstrocraftConfig CONFIG = Astrocraft.CONFIG;
    @Unique
    private float skyAngle;
    @Unique
    private float customStarsSkyAngle;

    @Inject(method={"getSkyColor"}, at={@At(value="HEAD")})
    private void injectGetSkyColor(class_243 pos, float tickDelta, CallbackInfoReturnable<class_243> info) {
        this.skyAngle = Astrocraft.getSolarAltitude((class_638)this, tickDelta);
        this.customStarsSkyAngle = class_3532.method_15362((float)(this.skyAngle * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        this.customStarsSkyAngle = class_3532.method_15363((float)this.skyAngle, (float)0.0f, (float)1.0f);
    }

    @ModifyVariable(method={"getCloudsColor"}, at=@At(value="STORE"), ordinal=1)
    private float injectSkyAngleClouds(float oldSkyAngle) {
        return this.skyAngle;
    }

    @ModifyVariable(method={"getSkyColor"}, at=@At(value="STORE"), ordinal=1)
    private float injectSkyAngleColor(float oldSkyAngle) {
        if (!MixinClientWorld.CONFIG.legacyMoon) {
            return 0.0f;
        }
        return this.skyAngle;
    }

    @ModifyVariable(method={"getSkyColor"}, at=@At(value="STORE"), ordinal=2)
    private float injectSkyColor(float g) {
        if (!MixinClientWorld.CONFIG.legacyMoon) {
            g = (float)Star.getSkyBrightness();
        }
        if (!Astrocraft.getObserver().hasNormalAtmosphere()) {
            g *= 0.1f;
        }
        if (!Astrocraft.getObserver().hasThinAtmosphere()) {
            g *= 0.1f;
        }
        return g * (1.0f - Astrocraft.getSpaceMultiplier()) * Astrocraft.getSolarUneclipsed();
    }

    @ModifyVariable(method={"getSkyColor"}, at=@At(value="STORE"), ordinal=3)
    private float modifySkyR(float r) {
        return r;
    }

    @ModifyVariable(method={"getSkyColor"}, at=@At(value="STORE"), ordinal=4)
    private float modifySkyG(float g) {
        return g;
    }

    @ModifyVariable(method={"getSkyColor"}, at=@At(value="STORE"), ordinal=5)
    private float modifySkyB(float b) {
        return b;
    }

    public float getStarBrightness(float f) {
        if (!MixinClientWorld.CONFIG.legacyMoon) {
            return Star.getStarBrightness();
        }
        if (!Astrocraft.getObserver().hasNormalAtmosphere()) {
            return 0.5f;
        }
        class_310 client = class_310.method_1551();
        float y = client.field_1724 != null ? (float)client.field_1724.method_23318() : 0.0f;
        float g = this.skyAngle - 6.0f;
        float h = 1.0f - (class_3532.method_15362((float)(g * ((float)Math.PI * 2))) * 2.0f + 0.125f) * class_3532.method_15363((float)(1.0f - y / 2048.0f), (float)0.0f, (float)1.0f) * Astrocraft.getSolarUneclipsed();
        h = class_3532.method_15363((float)h, (float)0.0f, (float)1.0f);
        if (Astrocraft.getObserver().hasThickAtmosphere()) {
            h = (float)((double)h * 0.85);
        }
        return h * h * 0.5f;
    }

    public float method_23787(float f) {
        return this.getStarBrightness(f);
    }

    @Overwrite
    public float method_23783(float tickDelta) {
        float moonAlt = Astrocraft.getLunarAltitude((class_638)this, tickDelta);
        float moonLight = class_3532.method_15363((float)(class_3532.method_15362((float)(moonAlt * ((float)Math.PI * 2))) * 2.0f + 0.2f), (float)0.0f, (float)1.0f);
        moonLight = (float)((double)moonLight * ((Math.cos(Math.toRadians(Astrocraft.getLightPhaseAngle())) + 1.0) / 2.0));
        moonLight = (float)((double)moonLight * (1.0 + 0.15 * Math.sin(Math.toRadians(Astrocraft.getApsisAngle()))));
        moonLight *= Astrocraft.getLunarUneclipsed();
        float sunAlt = this.skyAngle;
        float sunLight = class_3532.method_15363((float)(class_3532.method_15362((float)(sunAlt * ((float)Math.PI * 2))) * 2.0f + 0.2f), (float)0.0f, (float)1.0f);
        sunLight *= Astrocraft.getSolarUneclipsed();
        float g = sunLight *= 0.01f * (float)MixinClientWorld.CONFIG.legacyMoonOptions.sunLight;
        g = Math.max(sunLight, moonLight *= 0.01f * (float)MixinClientWorld.CONFIG.legacyMoonOptions.moonLight);
        if (!MixinClientWorld.CONFIG.legacyMoon) {
            g = (float)Star.getSurfaceBrightness();
        }
        float ambientLight = 0.01f * (float)MixinClientWorld.CONFIG.ambientLight;
        g *= 1.0f - ((class_638)this).method_8430(tickDelta) * 5.0f / 16.0f;
        return (g *= 1.0f - ((class_638)this).method_8478(tickDelta) * 5.0f / 16.0f) * (1.0f - ambientLight) + ambientLight;
    }
}

