/*
 * Decompiled with CFR 0.152.
 */
package mod.lwhrvw.astrocraft.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.systems.RenderSystem;
import mod.lwhrvw.astrocraft.Astrocraft;
import mod.lwhrvw.astrocraft.Star;
import mod.lwhrvw.astrocraft.VersionUtils;
import mod.lwhrvw.astrocraft.config.AstrocraftConfig;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_761.class}, priority=1)
public class MixinWorldRenderer {
    @Unique
    private static final AstrocraftConfig CONFIG = Astrocraft.CONFIG;
    @Unique
    Matrix4f matrix4f2;
    @Shadow
    private class_291 field_4113;
    @Shadow
    private class_638 field_4085;

    @Redirect(method={"renderSky(Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;FLnet/minecraft/client/render/Camera;ZLjava/lang/Runnable;)V"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;setShaderColor(FFFF)V", ordinal=3))
    private void modifyStarColor(float r, float g, float b, float a) {
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)(a * MixinWorldRenderer.CONFIG.starBrightnessBase));
    }

    private class_243 rotateMoon(float x, float y, float z) {
        double phaseRad = Math.toRadians(Astrocraft.getPhaseAngle());
        double relRad = -Math.toRadians(Astrocraft.getLunarDeclination());
        double scale = Astrocraft.getLunarScale();
        double sx = (double)x * scale;
        double sy = y;
        double sz = (double)z * scale;
        double px = sx * Math.cos(relRad) - sy * Math.sin(relRad);
        double py = sx * Math.sin(relRad) + sy * Math.cos(relRad);
        double pz = sz;
        double rx = px;
        double ry = py * Math.cos(phaseRad) - pz * Math.sin(phaseRad);
        double rz = py * Math.sin(phaseRad) + pz * Math.cos(phaseRad);
        class_243 vec = new class_243(rx, ry, rz);
        return vec;
    }

    @Redirect(method={"renderSky(Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;FLnet/minecraft/client/render/Camera;ZLjava/lang/Runnable;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/world/ClientWorld;getMoonPhase()I "))
    private int modifyMoonPhase(class_638 world) {
        double monthLength = MixinWorldRenderer.CONFIG.legacyMoonOptions.monthLength;
        if (monthLength < 1.0E-5 && monthLength > -1.0E-5) {
            monthLength = -1.0;
        }
        return (int)((double)((world.method_30271() - 18000L) * 8L) / (monthLength * 24000.0) + 0.5 + 8.0) % 8;
    }

    @Redirect(method={"renderSky(Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;FLnet/minecraft/client/render/Camera;ZLjava/lang/Runnable;)V"}, at=@At(value="INVOKE", target="net/minecraft/client/render/BufferBuilder.vertex(Lorg/joml/Matrix4f;FFF)Lnet/minecraft/client/render/VertexConsumer;", ordinal=6))
    private class_4588 modifyMoonPosition1(class_287 bufferBuilder, Matrix4f matrix, float x, float y, float z) {
        if (!MixinWorldRenderer.CONFIG.angledSky) {
            return bufferBuilder.method_22918(matrix, x, y, z);
        }
        class_243 vec = this.rotateMoon(x, y, -z);
        return bufferBuilder.method_22918(matrix, (float)vec.method_10216(), (float)vec.method_10214(), (float)vec.method_10215());
    }

    @Redirect(method={"renderSky(Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;FLnet/minecraft/client/render/Camera;ZLjava/lang/Runnable;)V"}, at=@At(value="INVOKE", target="net/minecraft/client/render/BufferBuilder.vertex(Lorg/joml/Matrix4f;FFF)Lnet/minecraft/client/render/VertexConsumer;", ordinal=7))
    private class_4588 modifyMoonPosition2(class_287 bufferBuilder, Matrix4f matrix, float x, float y, float z) {
        if (!MixinWorldRenderer.CONFIG.angledSky) {
            return bufferBuilder.method_22918(matrix, x, y, z);
        }
        class_243 vec = this.rotateMoon(-x, y, z);
        return bufferBuilder.method_22918(matrix, (float)vec.method_10216(), (float)vec.method_10214(), (float)vec.method_10215());
    }

    @Redirect(method={"renderSky(Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;FLnet/minecraft/client/render/Camera;ZLjava/lang/Runnable;)V"}, at=@At(value="INVOKE", target="net/minecraft/client/render/BufferBuilder.vertex(Lorg/joml/Matrix4f;FFF)Lnet/minecraft/client/render/VertexConsumer;", ordinal=8))
    private class_4588 modifyMoonPosition3(class_287 bufferBuilder, Matrix4f matrix, float x, float y, float z) {
        if (!MixinWorldRenderer.CONFIG.angledSky) {
            return bufferBuilder.method_22918(matrix, x, y, z);
        }
        class_243 vec = this.rotateMoon(x, y, -z);
        return bufferBuilder.method_22918(matrix, (float)vec.method_10216(), (float)vec.method_10214(), (float)vec.method_10215());
    }

    @Redirect(method={"renderSky(Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;FLnet/minecraft/client/render/Camera;ZLjava/lang/Runnable;)V"}, at=@At(value="INVOKE", target="net/minecraft/client/render/BufferBuilder.vertex(Lorg/joml/Matrix4f;FFF)Lnet/minecraft/client/render/VertexConsumer;", ordinal=9))
    private class_4588 modifyMoonPosition4(class_287 bufferBuilder, Matrix4f matrix, float x, float y, float z) {
        this.matrix4f2 = matrix;
        if (!MixinWorldRenderer.CONFIG.angledSky) {
            return bufferBuilder.method_22918(matrix, x, y, z);
        }
        class_243 vec = this.rotateMoon(-x, y, z);
        return bufferBuilder.method_22918(matrix, (float)vec.method_10216(), (float)vec.method_10214(), (float)vec.method_10215());
    }

    private void adjust(class_4587 matrices, boolean inverse) {
        if (inverse) {
            matrices.method_22907(class_7833.field_40713.rotationDegrees(this.field_4085.method_30274(0.0f) * 360.0f));
            matrices.method_22907(class_7833.field_40715.rotationDegrees(-90.0f));
        } else {
            matrices.method_22907(class_7833.field_40716.rotationDegrees(-90.0f));
            matrices.method_22907(class_7833.field_40714.rotationDegrees(this.field_4085.method_30274(0.0f) * 360.0f));
        }
    }

    private void applyLatitude(class_4587 matrices) {
        double latitude = Astrocraft.getLatitude();
        this.adjust(matrices, true);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(-((float)latitude)));
        this.adjust(matrices, false);
    }

    @Redirect(method={"renderSky(Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;FLnet/minecraft/client/render/Camera;ZLjava/lang/Runnable;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/util/math/MatrixStack;peek()Lnet/minecraft/client/util/math/MatrixStack$Entry;", ordinal=2))
    private class_4587.class_4665 getSunAngle(class_4587 matrices) {
        matrices.method_22903();
        this.applyLatitude(matrices);
        class_4587.class_4665 entry = matrices.method_23760();
        matrices.method_22909();
        return entry;
    }

    @Redirect(method={"renderSky(Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;FLnet/minecraft/client/render/Camera;ZLjava/lang/Runnable;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/util/math/MatrixStack;peek()Lnet/minecraft/client/util/math/MatrixStack$Entry;", ordinal=3))
    private class_4587.class_4665 getStarAngle(class_4587 matrices) {
        matrices.method_22903();
        this.applyLatitude(matrices);
        class_4587.class_4665 entry = matrices.method_23760();
        matrices.method_22909();
        return entry;
    }

    @Redirect(method={"renderSky(Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;FLnet/minecraft/client/render/Camera;ZLjava/lang/Runnable;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/util/math/MatrixStack;multiply(Lorg/joml/Quaternionf;)V", ordinal=0))
    private void modifySunsetAngle(class_4587 matrices, Quaternionf quaternion) {
        if (MixinWorldRenderer.CONFIG.angledSky) {
            double MAX_DECLINATION = -Astrocraft.getObserver().getObliquity();
            double sun = 360.0 * (double)Astrocraft.getWorldTime() / 24000.0 / MixinWorldRenderer.CONFIG.yearLength;
            double dec = MAX_DECLINATION * Math.sin(Math.toRadians(sun));
            double lat = Astrocraft.getLatitude();
            double sunrise = Math.toDegrees(Math.acos(-Math.tan(Math.toRadians(lat)) * Math.tan(Math.toRadians(dec)))) - 90.0;
            matrices.method_22907(class_7833.field_40714.rotationDegrees((float)sunrise));
        }
        matrices.method_22907(quaternion);
    }

    @WrapOperation(method={"renderSky(Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;FLnet/minecraft/client/render/Camera;ZLjava/lang/Runnable;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/world/ClientWorld;getSkyAngle(F)F", ordinal=0)})
    private float modifyTwilightColor(class_638 world, float tickDelta, Operation<Float> original) {
        return Star.getSolarAltitude();
    }

    @Redirect(method={"renderSky(Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;FLnet/minecraft/client/render/Camera;ZLjava/lang/Runnable;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/GameRenderer;getPositionProgram()Lnet/minecraft/client/gl/ShaderProgram;"))
    private class_5944 modifyStarDraw(Matrix4f matrices, Matrix4f projectionMatrix, float tickDelta, class_4184 arg3, boolean bl, Runnable runnable) {
        return class_757.method_34540();
    }

    @Inject(method={"renderSky(Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;FLnet/minecraft/client/render/Camera;ZLjava/lang/Runnable;)V"}, at={@At(value="HEAD")})
    private void reloadStars(CallbackInfo info) {
        if (Astrocraft.shouldReloadStars()) {
            Astrocraft.loadRenderData();
            class_289 tessellator = class_289.method_1348();
            this.field_4113 = new class_291(class_291.class_8555.field_44794);
            class_9801 builtBuffer = this.renderNightSky(tessellator);
            this.field_4113.method_1353();
            this.field_4113.method_1352(builtBuffer);
            class_291.method_1354();
        }
    }

    @Inject(method={"renderStars(Lnet/minecraft/client/render/Tessellator;)Lnet/minecraft/client/render/BuiltBuffer;"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectRenderStars(class_289 tessellator, CallbackInfoReturnable<class_9801> info) {
        class_9801 builtBuffer = this.renderNightSky(tessellator);
        info.setReturnValue((Object)builtBuffer);
    }

    @Inject(method={"renderSky(Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;FLnet/minecraft/client/render/Camera;ZLjava/lang/Runnable;)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;setShaderTexture(ILnet/minecraft/util/Identifier;)V", ordinal=1)})
    private void injectMoonColor(Matrix4f matrices, Matrix4f projectionMatrix, float tickDelta, class_4184 camera, boolean bl, Runnable runnable, CallbackInfo info) {
        if (!Astrocraft.getObserver().getName().equals("Earth") || !MixinWorldRenderer.CONFIG.legacyMoon) {
            RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            return;
        }
        AstrocraftConfig.Color color = new AstrocraftConfig.Color(255, 255, 255, 1.0f);
        float rainGradient = 1.0f - this.field_4085.method_8430(tickDelta);
        if (MixinWorldRenderer.CONFIG.legacyMoonOptions.hideNewMoon && this.modifyMoonPhase(this.field_4085) == 4) {
            float uneclipsed = Astrocraft.getSolarUneclipsed();
            float red = color.getRed() * (1.0f - uneclipsed);
            float green = color.getGreen() * (1.0f - uneclipsed) / 1.61f;
            float blue = color.getBlue() * (1.0f - uneclipsed) / 2.0f;
            RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)(color.alpha * rainGradient));
            return;
        }
        float uneclipsed = Astrocraft.getLunarUneclipsed();
        float red = color.getRed() * (float)Math.max(Math.min((double)uneclipsed * 1.2, 1.0), 0.5);
        float green = color.getGreen() * Math.max(Math.min(uneclipsed * 1.1f, 1.0f), 0.1f);
        float blue = color.getBlue() * Math.min(uneclipsed * 1.0f, 1.0f);
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)(color.alpha * rainGradient));
    }

    @Inject(method={"renderSky(Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;FLnet/minecraft/client/render/Camera;ZLjava/lang/Runnable;)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;setShaderTexture(ILnet/minecraft/util/Identifier;)V", ordinal=0)})
    private void injectSunColor(Matrix4f matrices, Matrix4f projectionMatrix, float tickDelta, class_4184 camera, boolean bl, Runnable runnable, CallbackInfo info) {
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
    }

    @Inject(method={"renderSky(Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;FLnet/minecraft/client/render/Camera;ZLjava/lang/Runnable;)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;setShaderColor(FFFF)V", ordinal=4)})
    public void callRenderTextured(CallbackInfo callbackInfo) {
        this.renderTextured();
    }

    @WrapOperation(method={"renderSky(Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;FLnet/minecraft/client/render/Camera;ZLjava/lang/Runnable;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/render/BufferRenderer;drawWithGlobalProgram(Lnet/minecraft/client/render/BuiltBuffer;)V", ordinal=1)})
    public void renderSun(class_9801 builtBuffer, Operation<Void> original) {
        original.call(new Object[]{builtBuffer});
    }

    public void renderTextured() {
        class_287 bufferBuilder = VersionUtils.setupBuffer(null, class_293.class_5596.field_27382, class_290.field_1576);
        if (this.matrix4f2 == null) {
            return;
        }
        Star.renderAllTextured(bufferBuilder, this.matrix4f2);
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)Astrocraft.getVisibility());
        Star.renderLines(bufferBuilder, this.matrix4f2);
    }

    @Unique
    private class_9801 renderNightSky(class_289 tessellator) {
        class_287 bb = VersionUtils.setupBuffer(null, class_293.class_5596.field_27382, class_290.field_1576);
        Star.renderAll(bb);
        return bb.method_60800();
    }
}

