/*
 * Decompiled with CFR 0.152.
 */
package mod.lwhrvw.astrocraft.overlays;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Scanner;
import mod.lwhrvw.astrocraft.overlays.Line;
import net.minecraft.class_287;
import org.joml.Matrix4f;
import org.joml.Vector4f;

public class ConstellationRenderer {
    private static ArrayList<Constellation> constellations = new ArrayList();

    public static void loadConstellations(InputStream stream) {
        constellations.clear();
        try (Scanner scanner = new Scanner(stream);){
            while (scanner.hasNextLine()) {
                String str = scanner.nextLine();
                String[] data = str.split(" ");
                Constellation con = new Constellation();
                double count = Double.parseDouble(data[0]);
                int i = 0;
                while ((double)i < count) {
                    double sra = (Double.parseDouble(data[i * 4 + 1]) + 180.0) % 360.0;
                    double sde = Double.parseDouble(data[i * 4 + 2]);
                    double dra = (Double.parseDouble(data[i * 4 + 3]) + 180.0) % 360.0;
                    double dde = Double.parseDouble(data[i * 4 + 4]);
                    con.addLine(new Line(sra, sde, dra, dde));
                    ++i;
                }
                constellations.add(con);
            }
            scanner.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void render(class_287 bb, Matrix4f matrix4f2) {
        for (Constellation cons : constellations) {
            cons.render(bb, matrix4f2);
        }
    }

    private static class Constellation {
        ArrayList<Line> lines = new ArrayList();

        public void addLine(Line line) {
            this.lines.add(line);
        }

        public void render(class_287 bufferBuilder, Matrix4f matrix4f2) {
            for (Line line : this.lines) {
                line.render(bufferBuilder, matrix4f2, new Vector4f(0.8f, 1.0f, 0.8f, 0.15f));
            }
        }
    }
}

